/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.emf;

import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import net.astah.golf.emf.CharFontGetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EMFFontHelper {
    private static final String[] logicalFonts = new String[]{"dialog", "dialoginput", "serif", "sansserif", "monospaced"};
    private int style;
    private int size;
    private String fontValue = "";
    private String logicalFontName;
    private static final Logger logger = LoggerFactory.getLogger(EMFFontHelper.class);

    public EMFFontHelper(String string, int n, int n2, String string2) {
        this.logicalFontName = string;
        this.style = n;
        this.size = n2;
        this.fontValue = string2;
    }

    public static boolean isLogicalFont(Font font) {
        for (int k = 0; k < logicalFonts.length; ++k) {
            if (!font.getName().toLowerCase().equals(logicalFonts[k])) continue;
            return true;
        }
        return false;
    }

    public List<StringWithFontInfo> parseString(String string) {
        char[] cArray = string.toCharArray();
        ArrayList<StringWithFontInfo> arrayList = new ArrayList<StringWithFontInfo>();
        Font font = null;
        StringBuilder stringBuilder = new StringBuilder();
        for (char c2 : cArray) {
            Font font2 = this.getCharFont(c2);
            if (font == null) {
                font = font2;
            } else if (!font2.equals(font)) {
                StringWithFontInfo stringWithFontInfo = new StringWithFontInfo(stringBuilder.toString(), font);
                arrayList.add(stringWithFontInfo);
                stringBuilder.delete(0, stringBuilder.length());
                font = font2;
            }
            stringBuilder.append(c2);
        }
        if (font != null) {
            StringWithFontInfo stringWithFontInfo = new StringWithFontInfo(stringBuilder.toString(), font);
            arrayList.add(stringWithFontInfo);
        }
        return arrayList;
    }

    private Font getCharFont(char c2) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("net.astah.golf.emf.CharFontGetter15");
            CharFontGetter charFontGetter = (CharFontGetter)clazz.newInstance();
            return charFontGetter.getCharFont(c2, this.style, this.size, this.logicalFontName, this.fontValue);
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.error("error has occurred.", (Throwable)classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            logger.error("error has occurred.", (Throwable)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.error("error has occurred.", (Throwable)illegalAccessException);
        }
        return new Font(this.logicalFontName, this.style, this.size);
    }

    public class StringWithFontInfo {
        private String str;
        private Font font;

        public StringWithFontInfo(String string, Font font) {
            if (font == null) {
                throw new IllegalArgumentException("font is null.");
            }
            this.font = font;
            this.str = string;
        }

        public Font getFont() {
            return this.font;
        }

        public String getString() {
            return this.str;
        }
    }
}

