/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.emf;

import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import net.astah.golf.emf.EMF;
import net.astah.golf.geom2D.Arc2d;
import net.astah.golf.geom2D.CubicCurve2d;
import net.astah.golf.geom2D.Ellipse2d;
import net.astah.golf.geom2D.RoundRectangle2d;

public class EMFConverter {
    private EMF emf;

    public EMFConverter(EMF eMF) {
        this.emf = eMF;
    }

    public void toEMF(Shape shape, boolean bl, boolean bl2) {
        if (shape instanceof Rectangle2D) {
            this.emf.rectangle2D((Rectangle2D)shape);
        } else if (shape instanceof Line2D) {
            Line2D line2D = (Line2D)shape;
            int[] nArray = new int[]{EMF.doubleToInt(line2D.getX1()), EMF.doubleToInt(line2D.getX2())};
            int[] nArray2 = new int[]{EMF.doubleToInt(line2D.getY1()), EMF.doubleToInt(line2D.getY2())};
            this.emf.polyline(line2D.getBounds(), 2, nArray, nArray2);
        } else if (shape instanceof Polygon) {
            Polygon polygon = (Polygon)shape;
            this.emf.polygon(polygon.getBounds(), polygon.npoints, polygon.xpoints, polygon.ypoints);
        } else if (shape instanceof Ellipse2d) {
            this.emf.ellipse((Ellipse2d)shape);
        } else if (shape instanceof RoundRectangle2d) {
            RoundRectangle2d roundRectangle2d = (RoundRectangle2d)shape;
            if (this.isDifferentAspectRatioOfCorner(roundRectangle2d)) {
                GeneralPath generalPath = this.toGeneralPath(roundRectangle2d);
                this.emf.generalPath(generalPath, bl, bl2);
                return;
            }
            this.emf.roundRect(roundRectangle2d);
        } else if (shape instanceof CubicCurve2d) {
            this.emf.cubicCurve((CubicCurve2d)shape);
        } else if (shape instanceof GeneralPath) {
            this.emf.generalPath((GeneralPath)shape, bl, bl2);
        } else if (shape instanceof Arc2d) {
            this.emf.arc((Arc2d)shape);
        }
    }

    private boolean isDifferentAspectRatioOfCorner(RoundRectangle2d roundRectangle2d) {
        double d2;
        double d3 = roundRectangle2d.getArcHeight();
        return d3 != (d2 = roundRectangle2d.getArcWidth());
    }

    private GeneralPath toGeneralPath(RoundRectangle2d roundRectangle2d) {
        double d2 = roundRectangle2d.getX();
        double d3 = d2 + roundRectangle2d.getWidth();
        double d4 = roundRectangle2d.getArcWidth() / 2.0;
        double d5 = 4.0 * (Math.sqrt(2.0) - 1.0) * d4 / 3.0;
        int n = EMF.doubleToInt(d2 + d4);
        int n2 = EMF.doubleToInt(d3 - d4);
        int n3 = EMF.doubleToInt(d3);
        int n4 = EMF.doubleToInt(d3);
        int n5 = EMF.doubleToInt(d3 - d4);
        int n6 = EMF.doubleToInt(d2 + d4);
        int n7 = EMF.doubleToInt(d2);
        int n8 = EMF.doubleToInt(d2);
        double d6 = roundRectangle2d.getY();
        double d7 = d6 + roundRectangle2d.getHeight();
        double d8 = roundRectangle2d.getArcHeight() / 2.0;
        double d9 = 4.0 * (Math.sqrt(2.0) - 1.0) * d8 / 3.0;
        int n9 = EMF.doubleToInt(d6);
        int n10 = EMF.doubleToInt(d6);
        int n11 = EMF.doubleToInt(d6 + d8);
        int n12 = EMF.doubleToInt(d7 - d8);
        int n13 = EMF.doubleToInt(d7);
        int n14 = EMF.doubleToInt(d7);
        int n15 = EMF.doubleToInt(d7 - d8);
        int n16 = EMF.doubleToInt(d6 + d8);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(n, n9);
        generalPath.lineTo(n2, n10);
        generalPath.curveTo((double)n2 + d5, (double)n10, (double)n3, (double)n11 - d9, (double)n3, (double)n11);
        generalPath.lineTo(n4, n12);
        generalPath.curveTo((double)n4, (double)n12 + d9, (double)n5 + d5, (double)n13, (double)n5, (double)n13);
        generalPath.lineTo(n6, n14);
        generalPath.curveTo((double)n6 - d5, (double)n14, (double)n7, (double)n15 + d9, (double)n7, (double)n15);
        generalPath.lineTo(n8, n16);
        generalPath.curveTo((double)n8, (double)n16 - d9, (double)n - d5, (double)n9, (double)n, (double)n9);
        generalPath.closePath();
        return generalPath;
    }
}

