/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.emf;

import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import net.astah.golf.emf.EMFContents;
import net.astah.golf.emf.EMFHandleTable;
import net.astah.golf.emf.EMFHeader;
import net.astah.golf.emf.EMFOutputStream;
import net.astah.golf.geom2D.Arc2d;
import net.astah.golf.geom2D.CubicCurve2d;
import net.astah.golf.geom2D.Ellipse2d;
import net.astah.golf.geom2D.RoundRectangle2d;
import net.astah.golf.util.ImageUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EMF
implements EMFContents {
    public static final int GM_COMPATIBLE = 1;
    public static final int GM_ADVANCED = 2;
    public static final int TA_TOP = 0;
    public static final int TA_BOTTOM = 8;
    public static final int TA_BASELINE = 24;
    public static final int TA_LEFT = 0;
    public static final int TA_RIGHT = 2;
    public static final int TA_CENTER = 6;
    public static final int TA_NOUPDATECP = 0;
    public static final int TA_UPDATECP = 1;
    public static final int TA_RTLREADING = 256;
    public static final int PS_GEOMETRIC = 65536;
    public static final int PS_COSMETIC = 0;
    public static final int PS_MASK_TYPE = 15;
    public static final int PS_SOLID = 0;
    public static final int PS_DASH = 1;
    public static final int PS_DOT = 2;
    public static final int PS_DASHDOT = 3;
    public static final int PS_DASHDOTDOT = 4;
    public static final int PS_NULL = 5;
    public static final int PS_INSIDEFRAME = 6;
    public static final int PS_USERSTYLE = 7;
    public static final int PS_ALTERNATE = 8;
    public static final int PS_ENDCAP_ROUND = 0;
    public static final int PS_ENDCAP_SQUARE = 256;
    public static final int PS_ENDCAP_FLAT = 512;
    public static final int PS_JOIN_ROUND = 0;
    public static final int PS_JOIN_BEVEL = 4096;
    public static final int PS_JOIN_MITER = 8192;
    public static final int BS_SOLID = 0;
    public static final int BS_HOLLOW = 1;
    public static final int BS_NULL = 1;
    public static final int BS_HATCHED = 2;
    public static final int BS_PATTERN = 3;
    public static final int BS_DIBPATTERN = 5;
    public static final int HS_HORIZONTAL = 0;
    public static final int HS_VERTICAL = 1;
    public static final int HS_FDIAGONAL = 2;
    public static final int HS_BDIAGONAL = 3;
    public static final int HS_CROSS = 4;
    public static final int HS_DIAGCROSS = 5;
    public static final int FW_DONTCARE = 0;
    public static final int FW_THIN = 100;
    public static final int FW_EXTRALIGHT = 200;
    public static final int FW_LIGHT = 300;
    public static final int FW_NORMAL = 400;
    public static final int FW_MEDIUM = 500;
    public static final int FW_SEMIBOLD = 600;
    public static final int FW_BOLD = 700;
    public static final int FW_EXTRABOLD = 800;
    public static final int FW_HEAVY = 900;
    public static final int MM_TEXT = 1;
    public static final int MM_LOMETRIC = 2;
    public static final int MM_HIMETRIC = 3;
    public static final int MM_LOENGLISH = 4;
    public static final int MM_HIENGLISH = 5;
    public static final int MM_TWIPS = 6;
    public static final int MM_ISOTROPIC = 7;
    public static final int MM_ANISOTROPIC = 8;
    public static final int ETO_OPAQUE = 2;
    public static final int ETO_CLIPPED = 4;
    public static final int AC_SRC_OVER = 0;
    public static final int AC_SRC_ALPHA = 1;
    public static final int DIB_RGB_COLORS = 0;
    public static final int DIB_PAL_COLORS = 1;
    public static final int BI_RGB = 0;
    public static final int BI_RLE8 = 1;
    public static final int BI_RLE4 = 2;
    public static final int BI_BITFIELDS = 3;
    public static final int BI_JPEG = 4;
    public static final int BI_PNG = 5;
    public static final int BLACKONWHITE = 1;
    public static final int WHITEONBLACK = 2;
    public static final int COLORONCOLOR = 3;
    public static final int HALFTONE = 4;
    public static final int STRETCH_ANDSCANS = 1;
    public static final int STRETCH_ORSCANS = 2;
    public static final int STRETCH_DELETESCANS = 3;
    public static final int STRETCH_HALFTONE = 4;
    public static final int TRANSPARENT = 1;
    public static final int OPAQUE = 2;
    public static final int MWT_IDENTITY = 1;
    public static final int MWT_LEFTMULTIPLY = 2;
    public static final int MWT_RIGHTMULTIPLY = 3;
    private static final int SRCCOPY = 0xCC0020;
    private EMFHandleTable handleTable;
    private Rectangle imageBounds;
    private int fileSize = 0;
    private int numOfRecords = 0;
    public static final int PT_LINETO = 2;
    public static final int PT_BEZIERTO = 4;
    public static final byte PT_MOVETO = 6;
    private EMFOutputStream outputStream;
    private static final Logger logger = LoggerFactory.getLogger(EMF.class);

    public EMF(Rectangle rectangle) {
        this.imageBounds = rectangle;
        this.handleTable = new EMFHandleTable();
        this.outputStream = new EMFOutputStream();
    }

    private void writeEMF() throws IOException {
        for (int k = 1; k < this.handleTable.getHandleSize() + 1; ++k) {
            this.deleteObject(this.handleTable.getHandle(k));
        }
        this.handleTable.removeHandles();
        this.eof();
        this.fileSize = this.outputStream.size();
        EMFHeader eMFHeader = new EMFHeader(this.imageBounds, this.numOfRecords, this.fileSize, this.handleTable.getNumOfHandleUsed());
        byte[] byArray = this.outputStream.toByteArray();
        this.outputStream.reset();
        this.writeHeader(eMFHeader);
        this.outputStream.write(byArray);
    }

    private void writeHeader(EMFHeader eMFHeader) {
        eMFHeader.write(this.outputStream);
    }

    public int createBrushIndirect(int n, Color color, int n2) {
        int n3 = this.handleTable.addHandle();
        this.increaseRecord();
        this.outputStream.writeInt(39);
        this.outputStream.writeInt(24);
        this.outputStream.writeInt(n3);
        this.outputStream.writeInt(n);
        this.outputStream.writeCOLORREF(color);
        this.outputStream.writeInt(n2);
        return n3;
    }

    public int extCreatePen(int n, int n2, int n3, int n4, int n5, int n6, int n7, Color color, int n8, int n9, float[] fArray) {
        int n10 = this.handleTable.addHandle();
        this.increaseRecord();
        this.outputStream.writeInt(95);
        this.outputStream.writeInt(52 + 4 * n9);
        this.outputStream.writeInt(n10);
        this.outputStream.writeInt(n);
        this.outputStream.writeInt(n2);
        this.outputStream.writeInt(n3);
        this.outputStream.writeInt(n4);
        this.outputStream.writeInt(n5);
        this.outputStream.writeInt(n6);
        this.outputStream.writeInt(n7);
        this.outputStream.writeCOLORREF(color);
        this.outputStream.writeInt(n8);
        this.outputStream.writeInt(n9);
        for (int k = 0; k < n9; ++k) {
            this.outputStream.writeFloat(fArray[k]);
        }
        return n10;
    }

    public void modifyWorldTransform(AffineTransform affineTransform) {
        this.increaseRecord();
        this.outputStream.writeInt(36);
        this.outputStream.writeInt(36);
        this.outputStream.writeFloat((float)affineTransform.getScaleX());
        this.outputStream.writeFloat((float)affineTransform.getShearY());
        this.outputStream.writeFloat((float)affineTransform.getShearX());
        this.outputStream.writeFloat((float)affineTransform.getScaleY());
        this.outputStream.writeFloat((float)affineTransform.getTranslateX());
        this.outputStream.writeFloat((float)affineTransform.getTranslateY());
        this.outputStream.writeInt(2);
    }

    public int createPenIndirect(int n, int n2, Color color) {
        int n3 = this.handleTable.addHandle();
        this.increaseRecord();
        this.outputStream.writeInt(38);
        this.outputStream.writeInt(28);
        this.outputStream.writeInt(n3);
        this.outputStream.writeInt(n);
        this.outputStream.writeInt(n2);
        this.outputStream.writeInt(0);
        this.outputStream.writeCOLORREF(color);
        return n3;
    }

    public int createFontIndirect(Font font, int n, boolean bl, boolean bl2) throws UnsupportedEncodingException, IOException {
        return this.extCreateFontIndirectW(-font.getSize(), 0, n, 0, font.isBold() ? 700 : 400, font.isItalic(), bl, bl2, 1, 0, 0, 4, 0, font.getName());
    }

    public int extCreateFontIndirectW(int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2, boolean bl3, int n6, int n7, int n8, int n9, int n10, String string) throws UnsupportedEncodingException, IOException {
        int n11 = this.handleTable.addHandle();
        this.increaseRecord();
        this.outputStream.writeInt(82);
        this.outputStream.writeInt(332);
        this.outputStream.writeInt(n11);
        this.outputStream.writeInt(n);
        this.outputStream.writeInt(n2);
        this.outputStream.writeInt(n3);
        this.outputStream.writeInt(n4);
        this.outputStream.writeInt(n5);
        this.outputStream.writeByte(bl);
        this.outputStream.writeByte(bl2);
        this.outputStream.writeByte(bl3);
        this.outputStream.writeByte(n6);
        this.outputStream.writeByte(n7);
        this.outputStream.writeByte(n8);
        this.outputStream.writeByte(n9);
        this.outputStream.writeByte(n10);
        this.outputStream.writeString(string, 32);
        this.outputStream.writeString("", 64);
        this.outputStream.writeString("", 32);
        this.outputStream.writeInt(0);
        this.outputStream.writeInt(0);
        this.outputStream.writeInt(0);
        this.outputStream.writeInt(0);
        this.outputStream.writeByte(0);
        this.outputStream.writeByte(0);
        this.outputStream.writeByte(0);
        this.outputStream.writeByte(0);
        this.outputStream.writeInt(0);
        this.outputStream.writeByte(1);
        this.outputStream.writeByte(1);
        this.outputStream.writeByte(1);
        this.outputStream.writeByte(1);
        this.outputStream.writeByte(1);
        this.outputStream.writeByte(1);
        this.outputStream.writeByte(0);
        this.outputStream.writeByte(0);
        this.outputStream.writeByte(0);
        this.outputStream.writeByte(0);
        this.outputStream.writeWord(0);
        return n11;
    }

    public void selectObject(int n) {
        if (this.handleTable.getHandle(n) == -1) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.increaseRecord();
        this.outputStream.writeInt(37);
        this.outputStream.writeInt(12);
        this.outputStream.writeInt(n);
    }

    public void lineTo(int n, int n2) {
        this.increaseRecord();
        this.outputStream.writeInt(54);
        this.outputStream.writeInt(16);
        this.outputStream.writeInt(n);
        this.outputStream.writeInt(n2);
    }

    public void polygon(Rectangle rectangle, int n, int[] nArray, int[] nArray2) {
        this.increaseRecord();
        this.outputStream.writeInt(3);
        this.outputStream.writeInt(n * 8 + 16 + 12);
        this.outputStream.writeInt(rectangle.x);
        this.outputStream.writeInt(rectangle.y);
        this.outputStream.writeInt(rectangle.width);
        this.outputStream.writeInt(rectangle.height);
        this.outputStream.writeInt(n);
        for (int k = 0; k < n; ++k) {
            this.outputStream.writeInt(nArray[k]);
            this.outputStream.writeInt(nArray2[k]);
        }
    }

    public void polyline(Rectangle rectangle, int n, int[] nArray, int[] nArray2) {
        this.increaseRecord();
        this.outputStream.writeInt(4);
        this.outputStream.writeInt(n * 8 + 16 + 12);
        this.outputStream.writeInt(rectangle.x);
        this.outputStream.writeInt(rectangle.y);
        this.outputStream.writeInt(rectangle.width);
        this.outputStream.writeInt(rectangle.height);
        this.outputStream.writeInt(n);
        for (int k = 0; k < n; ++k) {
            this.outputStream.writeInt(nArray[k]);
            this.outputStream.writeInt(nArray2[k]);
        }
    }

    public void rectangle2D(Rectangle2D rectangle2D) {
        this.rectangle(EMF.doubleToInt(rectangle2D.getX()), EMF.doubleToInt(rectangle2D.getY()), EMF.doubleToInt(rectangle2D.getX() + rectangle2D.getWidth()), EMF.doubleToInt(rectangle2D.getY() + rectangle2D.getHeight()));
    }

    public void rectangle(Rectangle rectangle) {
        this.rectangle(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
    }

    public void rectangle(int n, int n2, int n3, int n4) {
        this.increaseRecord();
        this.outputStream.writeInt(43);
        this.outputStream.writeInt(24);
        this.outputStream.writeInt(n);
        this.outputStream.writeInt(n2);
        this.outputStream.writeInt(n3);
        this.outputStream.writeInt(n4);
    }

    public void roundRect(RoundRectangle2d roundRectangle2d) {
        int n = EMF.doubleToInt(roundRectangle2d.getX());
        int n2 = EMF.doubleToInt(roundRectangle2d.getY());
        int n3 = EMF.doubleToInt(roundRectangle2d.getX() + roundRectangle2d.getWidth());
        int n4 = EMF.doubleToInt(roundRectangle2d.getY() + roundRectangle2d.getHeight());
        int n5 = EMF.doubleToInt(roundRectangle2d.getArcWidth());
        int n6 = EMF.doubleToInt(roundRectangle2d.getArcHeight());
        this.roundRect(n, n2, n3, n4, n5, n6);
    }

    public void roundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.increaseRecord();
        this.outputStream.writeInt(44);
        this.outputStream.writeInt(32);
        this.outputStream.writeInt(n);
        this.outputStream.writeInt(n2);
        this.outputStream.writeInt(n3);
        this.outputStream.writeInt(n4);
        this.outputStream.writeInt(n5);
        this.outputStream.writeInt(n6);
    }

    public void ellipse(int n, int n2, int n3, int n4) {
        this.increaseRecord();
        this.outputStream.writeInt(42);
        this.outputStream.writeInt(24);
        this.outputStream.writeInt(n);
        this.outputStream.writeInt(n2);
        this.outputStream.writeInt(n3);
        this.outputStream.writeInt(n4);
    }

    public void ellipse(Ellipse2d ellipse2d) {
        int n = EMF.doubleToInt(ellipse2d.getX());
        int n2 = EMF.doubleToInt(ellipse2d.getY());
        int n3 = EMF.doubleToInt(ellipse2d.getX() + ellipse2d.getWidth());
        int n4 = EMF.doubleToInt(ellipse2d.getY() + ellipse2d.getHeight());
        this.ellipse(n, n2, n3, n4);
    }

    public void arc(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.increaseRecord();
        this.outputStream.writeInt(45);
        this.outputStream.writeInt(40);
        this.outputStream.writeInt(n);
        this.outputStream.writeInt(n2);
        this.outputStream.writeInt(n3);
        this.outputStream.writeInt(n4);
        this.outputStream.writeInt(n5);
        this.outputStream.writeInt(n6);
        this.outputStream.writeInt(n7);
        this.outputStream.writeInt(n8);
    }

    public void arc(Arc2d arc2d) {
        int n = EMF.doubleToInt(arc2d.getX());
        int n2 = EMF.doubleToInt(arc2d.getY());
        int n3 = EMF.doubleToInt(arc2d.getX() + arc2d.getWidth());
        int n4 = EMF.doubleToInt(arc2d.getY() + arc2d.getHeight());
        int n5 = EMF.doubleToInt(arc2d.getStartPoint().getX());
        int n6 = EMF.doubleToInt(arc2d.getStartPoint().getY());
        int n7 = EMF.doubleToInt(arc2d.getEndPoint().getX());
        int n8 = EMF.doubleToInt(arc2d.getEndPoint().getY());
        this.arc(n, n2, n3, n4, n5, n6, n7, n8);
    }

    public void setWindowExtEx(int n, int n2) {
        this.increaseRecord();
        this.outputStream.writeInt(9);
        this.outputStream.writeInt(16);
        this.outputStream.writeInt(n);
        this.outputStream.writeInt(n2);
    }

    public void setWindowOrgEx(int n, int n2) {
        this.increaseRecord();
        this.outputStream.writeInt(10);
        this.outputStream.writeInt(16);
        this.outputStream.writeInt(n);
        this.outputStream.writeInt(n2);
    }

    public void setPolyFillMode(int n) {
        this.increaseRecord();
        this.outputStream.writeInt(19);
        this.outputStream.writeInt(12);
        this.outputStream.writeInt(n);
    }

    public void setViewportOrgEx(int n, int n2) {
        this.increaseRecord();
        this.outputStream.writeInt(12);
        this.outputStream.writeInt(16);
        this.outputStream.writeInt(n);
        this.outputStream.writeInt(n2);
    }

    public void setViewportExtEx(int n, int n2) {
        this.increaseRecord();
        this.outputStream.writeInt(12);
        this.outputStream.writeInt(16);
        this.outputStream.writeInt(n);
        this.outputStream.writeInt(n2);
    }

    public void setMapMode(int n) {
        this.increaseRecord();
        this.outputStream.writeInt(17);
        this.outputStream.writeInt(12);
        this.outputStream.writeInt(n);
    }

    public void setBkMode(int n) {
        this.increaseRecord();
        this.outputStream.writeInt(18);
        this.outputStream.writeInt(12);
        this.outputStream.writeInt(n);
    }

    public void moveToEx(int n, int n2) {
        this.increaseRecord();
        this.outputStream.writeInt(27);
        this.outputStream.writeInt(16);
        this.outputStream.writeInt(n);
        this.outputStream.writeInt(n2);
    }

    public void beginPath() {
        this.increaseRecord();
        this.outputStream.writeInt(59);
        this.outputStream.writeInt(8);
    }

    public void strokePath(Rectangle rectangle) {
        this.increaseRecord();
        this.outputStream.writeInt(64);
        this.outputStream.writeInt(24);
        this.outputStream.writeRect(rectangle);
    }

    public void fillPath(Rectangle rectangle) {
        this.increaseRecord();
        this.outputStream.writeInt(62);
        this.outputStream.writeInt(24);
        this.outputStream.writeRect(rectangle);
    }

    public void strokeAndFillPath(Rectangle rectangle) {
        this.increaseRecord();
        this.outputStream.writeInt(63);
        this.outputStream.writeInt(24);
        this.outputStream.writeRect(rectangle);
    }

    public void endPath() {
        this.increaseRecord();
        this.outputStream.writeInt(60);
        this.outputStream.writeInt(8);
    }

    public void closeFigure() {
        this.increaseRecord();
        this.outputStream.writeInt(61);
        this.outputStream.writeInt(8);
    }

    public void cubicCurve(CubicCurve2d cubicCurve2d) {
        Rectangle rectangle = cubicCurve2d.getBounds();
        Point point = new Point(EMF.doubleToInt(cubicCurve2d.x1), EMF.doubleToInt(cubicCurve2d.y1));
        Point point2 = new Point(EMF.doubleToInt(cubicCurve2d.ctrlx1), EMF.doubleToInt(cubicCurve2d.ctrly1));
        Point point3 = new Point(EMF.doubleToInt(cubicCurve2d.ctrlx2), EMF.doubleToInt(cubicCurve2d.ctrly2));
        Point point4 = new Point(EMF.doubleToInt(cubicCurve2d.x2), EMF.doubleToInt(cubicCurve2d.y2));
        Point[] pointArray = new Point[]{point, point2, point3, point4};
        this.polyBezier(rectangle, 4, pointArray);
    }

    public void polyBezier(Rectangle rectangle, int n, Point[] pointArray) {
        this.increaseRecord();
        this.outputStream.writeInt(2);
        this.outputStream.writeInt(28 + n * 8);
        this.outputStream.writeRect(rectangle);
        this.outputStream.writeInt(n);
        for (int k = 0; k < n; ++k) {
            this.outputStream.writePoint(pointArray[k]);
        }
    }

    public void polyBezierto16(Rectangle rectangle, int n, Point[] pointArray) {
        this.increaseRecord();
        this.outputStream.writeInt(88);
        this.outputStream.writeInt(25 + n * 4);
        this.outputStream.writeRect(rectangle);
        this.outputStream.writeInt(n);
        for (int k = 0; k < n; ++k) {
            this.outputStream.writePoint(pointArray[k]);
        }
    }

    public void polydraw(Rectangle rectangle, int n, Point[] pointArray, byte[] byArray) {
        this.increaseRecord();
        this.outputStream.writeInt(56);
        this.outputStream.writeInt(28 + n * 8 + byArray.length);
        this.outputStream.writeRect(rectangle);
        this.outputStream.writeInt(n);
        for (int k = 0; k < n; ++k) {
            this.outputStream.writePoint(pointArray[k]);
        }
        try {
            this.outputStream.writeByte(byArray);
        }
        catch (IOException iOException) {
            logger.error("error has occurred.", (Throwable)iOException);
        }
    }

    public void setTextColor(Color color) {
        this.increaseRecord();
        this.outputStream.writeInt(24);
        this.outputStream.writeInt(12);
        this.outputStream.writeCOLORREF(color);
    }

    public void setTextAlign(int n) {
        this.increaseRecord();
        this.outputStream.writeInt(22);
        this.outputStream.writeInt(12);
        this.outputStream.writeInt(n);
    }

    public void textOut(int n, int n2, String string, Font font) throws UnsupportedEncodingException, IOException {
        this.increaseRecord();
        int n3 = string.length();
        int n4 = string.getBytes("UTF-16LE").length;
        int n5 = n4 % 4;
        if (n5 > 0) {
            n5 = 4 - n5;
        }
        this.outputStream.writeInt(84);
        this.outputStream.writeInt(76 + n4 + n5 + 4 * n3);
        this.outputStream.writeInt(this.imageBounds.x);
        this.outputStream.writeInt(this.imageBounds.y);
        this.outputStream.writeInt(this.imageBounds.width);
        this.outputStream.writeInt(this.imageBounds.height);
        this.outputStream.writeInt(2);
        this.outputStream.writeInt(1);
        this.outputStream.writeInt(1);
        this.outputStream.writeInt(n);
        this.outputStream.writeInt(n2);
        this.outputStream.writeInt(n3);
        this.outputStream.writeInt(76);
        this.outputStream.writeInt(0);
        this.outputStream.writeInt(0);
        this.outputStream.writeInt(0);
        this.outputStream.writeInt(0);
        this.outputStream.writeInt(0);
        this.outputStream.writeInt(76 + n4 + n5);
        this.outputStream.writeByte(string.getBytes("UTF-16LE"));
        for (int k = 0; k < n5; ++k) {
            this.outputStream.writeByte(0);
        }
        int[] nArray = new int[n3];
        for (int k = 0; k < nArray.length; ++k) {
            double d2 = font.getStringBounds(string, k, k + 1, this.getFontRenderContext()).getWidth();
            this.outputStream.writeInt(EMF.doubleToInt(d2));
        }
    }

    public void modifyWorldTransform(int n) {
        this.increaseRecord();
        this.outputStream.writeInt(36);
        this.outputStream.writeInt(36);
        AffineTransform affineTransform = AffineTransform.getScaleInstance(1.0, 1.0);
        this.outputStream.writeModifyTransform(affineTransform);
        this.outputStream.writeInt(n);
    }

    public void modifyWorldTransform(double d2, double d3, double d4) {
        this.increaseRecord();
        this.outputStream.writeInt(36);
        this.outputStream.writeInt(36);
        AffineTransform affineTransform = AffineTransform.getRotateInstance(d2, d3, d4);
        this.outputStream.writeModifyTransform(affineTransform);
        this.outputStream.writeInt(2);
    }

    public void modifyWorldTransform(double d2, double d3) {
        this.increaseRecord();
        this.outputStream.writeInt(36);
        this.outputStream.writeInt(36);
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(d2, d3);
        this.outputStream.writeModifyTransform(affineTransform);
        this.outputStream.writeInt(2);
    }

    public void setEMFRectangle(Rectangle rectangle) {
        this.increaseRecord();
        this.outputStream.writeInt(43);
        this.outputStream.writeInt(24);
        this.outputStream.writeInt(rectangle.x);
        this.outputStream.writeInt(rectangle.y);
        this.outputStream.writeInt(rectangle.width);
        this.outputStream.writeInt(rectangle.height);
    }

    public void setGDIComment(String string) {
        this.increaseRecord();
        this.outputStream.writeInt(70);
        byte[] byArray = string.getBytes();
        this.outputStream.writeInt(12 + (int)Math.ceil((double)byArray.length * 1.0 / 4.0) * 4);
        this.outputStream.writeInt(byArray.length);
        try {
            this.outputStream.writeByte(byArray);
        }
        catch (IOException iOException) {
            logger.error("error has occurred.", (Throwable)iOException);
        }
        if (byArray.length % 4 != 0) {
            for (int k = 0; k < 4 - byArray.length % 4; ++k) {
                this.outputStream.writeByte(0);
            }
        }
    }

    public void drawImage(Image image, int n, int n2, int n3, int n4, Color color) {
        this.setStretchBltMode(3);
        this.writeStretchDIBits(this.imageBounds, n, n2 + n4 - 1, n3, -n4, image, null, color);
    }

    public void setStretchBltMode(int n) {
        this.increaseRecord();
        this.outputStream.writeInt(21);
        this.outputStream.writeInt(12);
        this.outputStream.writeInt(n);
    }

    private void writeStretchDIBits(Rectangle rectangle, int n, int n2, int n3, int n4, Image image, Object object, Color color) {
        this.increaseRecord();
        this.outputStream.writeInt(81);
        byte[] byArray = ImageUtilities.getBytes(image, color, "*BGRA", 1, null);
        int n5 = byArray.length;
        this.outputStream.writeInt(120 + n5);
        this.outputStream.writeInt(rectangle.x);
        this.outputStream.writeInt(rectangle.y);
        this.outputStream.writeInt(rectangle.width);
        this.outputStream.writeInt(rectangle.height);
        this.outputStream.writeInt(n);
        this.outputStream.writeInt(n2);
        this.outputStream.writeInt(0);
        this.outputStream.writeInt(0);
        int n6 = image.getWidth(null);
        int n7 = image.getHeight(null);
        this.outputStream.writeInt(n6);
        this.outputStream.writeInt(n7);
        int n8 = 80;
        this.outputStream.writeInt(n8);
        this.outputStream.writeInt(40);
        this.outputStream.writeInt(n8 + 40);
        this.outputStream.writeInt(n5);
        this.outputStream.writeInt(0);
        this.outputStream.writeInt(0xCC0020);
        this.outputStream.writeInt(n3);
        this.outputStream.writeInt(n4);
        this.outputStream.writeInt(40);
        this.outputStream.writeInt(n6);
        this.outputStream.writeInt(n7);
        this.outputStream.writeWord(1);
        this.outputStream.writeWord(32);
        this.outputStream.writeInt(0);
        this.outputStream.writeInt(n5);
        this.outputStream.writeInt(0);
        this.outputStream.writeInt(0);
        this.outputStream.writeInt(0);
        this.outputStream.writeInt(0);
        try {
            this.outputStream.writeByte(byArray);
        }
        catch (IOException iOException) {
            logger.error("error has occurred.", (Throwable)iOException);
        }
    }

    public void setMiterLimit(float f2) {
        this.outputStream.writeInt(58);
        this.outputStream.writeInt(12);
        this.outputStream.writeFloat(f2);
    }

    public void generalPath(GeneralPath generalPath, boolean bl, boolean bl2) {
        this.beginPath();
        PathIterator pathIterator = generalPath.getPathIterator(null);
        double[] dArray = new double[6];
        Point[] pointArray = new Point[]{new Point(), new Point(), new Point()};
        Point point = new Point();
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(dArray);
            switch (n) {
                case 0: {
                    int n2 = EMF.doubleToInt(dArray[0]);
                    int n3 = EMF.doubleToInt(dArray[1]);
                    this.moveToEx(n2, n3);
                    point.x = n2;
                    point.y = n3;
                    break;
                }
                case 1: {
                    int n2 = EMF.doubleToInt(dArray[0]);
                    int n3 = EMF.doubleToInt(dArray[1]);
                    this.lineTo(n2, n3);
                    point.x = n2;
                    point.y = n3;
                    break;
                }
                case 2: {
                    this.convertToCubicCoords(dArray, point);
                    this.polyBezierTo(dArray, pointArray, point);
                    break;
                }
                case 3: {
                    this.polyBezierTo(dArray, pointArray, point);
                    break;
                }
                case 4: {
                    this.closeFigure();
                }
            }
            pathIterator.next();
        }
        this.endPath();
        if (bl && bl2) {
            this.strokeAndFillPath(this.imageBounds);
        } else if (bl && !bl2) {
            this.strokePath(this.imageBounds);
        } else {
            this.fillPath(this.imageBounds);
        }
    }

    private void convertToCubicCoords(double[] dArray, Point point) {
        double d2 = point.x;
        double d3 = point.y;
        double d4 = dArray[0];
        double d5 = dArray[1];
        double d6 = dArray[2];
        double d7 = dArray[3];
        dArray[0] = d2 + 2.0 * (d4 - d2) / 3.0;
        dArray[1] = d3 + 2.0 * (d5 - d3) / 3.0;
        dArray[2] = d6 + 2.0 * (d4 - d6) / 3.0;
        dArray[3] = d7 + 2.0 * (d5 - d7) / 3.0;
        dArray[4] = d6;
        dArray[5] = d7;
    }

    private void polyBezierTo(double[] dArray, Point[] pointArray, Point point) {
        pointArray[0].x = EMF.doubleToInt(dArray[0]);
        pointArray[0].y = EMF.doubleToInt(dArray[1]);
        pointArray[1].x = EMF.doubleToInt(dArray[2]);
        pointArray[1].y = EMF.doubleToInt(dArray[3]);
        pointArray[2].x = EMF.doubleToInt(dArray[4]);
        pointArray[2].y = EMF.doubleToInt(dArray[5]);
        this.polyBezierTo(this.imageBounds, pointArray);
        point.x = pointArray[2].x;
        point.y = pointArray[2].y;
    }

    private void polyBezierTo(Rectangle rectangle, Point[] pointArray) {
        this.increaseRecord();
        int n = pointArray.length;
        this.outputStream.writeInt(5);
        this.outputStream.writeInt(28 + n * 8);
        this.outputStream.writeRect(rectangle);
        this.outputStream.writeInt(n);
        for (int k = 0; k < n; ++k) {
            this.outputStream.writePoint(pointArray[k]);
        }
    }

    private void increaseRecord() {
        ++this.numOfRecords;
    }

    private void eof() {
        this.increaseRecord();
        this.outputStream.writeInt(14);
        this.outputStream.writeInt(20);
        this.outputStream.writeInt(0);
        this.outputStream.writeInt(0);
        this.outputStream.writeInt(20);
    }

    public void deleteObject(int n) {
        if (n != -1) {
            this.increaseRecord();
            this.outputStream.writeInt(40);
            this.outputStream.writeInt(12);
            this.outputStream.writeInt(n);
        }
    }

    public EMFOutputStream getEMFOutputStream() {
        try {
            this.writeEMF();
        }
        catch (IOException iOException) {
            logger.error("error has occurred.", (Throwable)iOException);
        }
        return this.outputStream;
    }

    public FontRenderContext getFontRenderContext() {
        return new FontRenderContext(new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f), true, true);
    }

    public static int doubleToInt(double d2) {
        return Math.round((float)d2);
    }
}

