/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.draw;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoableEdit;
import net.astah.golf.view.swing.InputEventSupport;
import net.astah.jomt.jutil.SwingInvoker;

public class UndoableTextField
extends JTextField
implements FocusListener {
    private static final long serialVersionUID = -4980073587854108998L;
    private final List<UndoableEdit> undo = new ArrayList<UndoableEdit>();
    private final List<UndoableEdit> redo = new ArrayList<UndoableEdit>();

    public UndoableTextField() {
        this.getDocument().addUndoableEditListener(new UndoableListener());
        this.addKeyListener(new KeyHandler());
    }

    public UndoableTextField(int n) {
        super(n);
        this.getDocument().addUndoableEditListener(new UndoableListener());
        this.addKeyListener(new KeyHandler());
    }

    public UndoableTextField(String string) {
        super(string);
        this.getDocument().addUndoableEditListener(new UndoableListener());
        this.addKeyListener(new KeyHandler());
    }

    public UndoableTextField(String string, int n) {
        super(string, n);
        this.getDocument().addUndoableEditListener(new UndoableListener());
        this.addKeyListener(new KeyHandler());
    }

    public void setText(String string, boolean bl) {
        ArrayList<UndoableEdit> arrayList = new ArrayList<UndoableEdit>(this.undo);
        super.setText(string);
        if (!bl) {
            this.undo.clear();
            this.undo.addAll(arrayList);
        }
    }

    public static void main(String[] stringArray) {
        SwingInvoker.runInEDT(new Runnable(){

            @Override
            public void run() {
                JFrame jFrame = new JFrame("Test undo on textfield");
                jFrame.getContentPane().add((Component)new UndoableTextField(20), "Center");
                jFrame.pack();
                jFrame.setVisible(true);
            }
        });
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.undo.clear();
        this.redo.clear();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    final class KeyHandler
    extends KeyAdapter {
        KeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (InputEventSupport.isControlDown(keyEvent)) {
                UndoableEdit undoableEdit;
                if (keyEvent.getKeyCode() == 90 && !UndoableTextField.this.undo.isEmpty()) {
                    UndoableEdit undoableEdit2 = (UndoableEdit)UndoableTextField.this.undo.get(UndoableTextField.this.undo.size() - 1);
                    if (undoableEdit2 != null) {
                        undoableEdit2.undo();
                        UndoableTextField.this.undo.remove(undoableEdit2);
                        UndoableTextField.this.redo.add(undoableEdit2);
                        keyEvent.consume();
                    }
                } else if (keyEvent.getKeyCode() == 89 && !UndoableTextField.this.redo.isEmpty() && (undoableEdit = (UndoableEdit)UndoableTextField.this.redo.get(UndoableTextField.this.redo.size() - 1)) != null) {
                    undoableEdit.redo();
                    UndoableTextField.this.redo.remove(undoableEdit);
                    UndoableTextField.this.undo.add(undoableEdit);
                    keyEvent.consume();
                }
            }
        }
    }

    final class UndoableListener
    implements UndoableEditListener {
        UndoableListener() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            UndoableTextField.this.undo.add(undoableEditEvent.getEdit());
            UndoableTextField.this.redo.clear();
        }
    }
}

