/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.draw;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoableEdit;
import net.astah.golf.view.swing.InputEventSupport;
import net.astah.golf.widget.swing.AdjustFontSizeTextArea;

public class UndoableTextArea
extends AdjustFontSizeTextArea
implements FocusListener {
    private static final long serialVersionUID = 634654500184011932L;
    final List<UndoableEdit> undo = new ArrayList<UndoableEdit>();
    final List<UndoableEdit> redo = new ArrayList<UndoableEdit>();

    public UndoableTextArea() {
        this.getDocument().addUndoableEditListener(new UndoableListener());
        this.addKeyListener(new KeyHandler());
        this.addFocusListener(this);
    }

    public UndoableTextArea(int n, int n2) {
        super(n, n2);
        this.getDocument().addUndoableEditListener(new UndoableListener());
        this.addKeyListener(new KeyHandler());
    }

    public UndoableTextArea(String string) {
        super(string);
        this.getDocument().addUndoableEditListener(new UndoableListener());
        this.addKeyListener(new KeyHandler());
    }

    public UndoableTextArea(String string, int n, int n2) {
        super(string, n, n2);
        this.getDocument().addUndoableEditListener(new UndoableListener());
        this.addKeyListener(new KeyHandler());
    }

    public void setText(String string, boolean bl) {
        ArrayList<UndoableEdit> arrayList = new ArrayList<UndoableEdit>(this.undo);
        super.setText(string);
        if (!bl) {
            this.undo.clear();
            this.undo.addAll(arrayList);
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Test undo on textArea");
        jFrame.getContentPane().add((Component)new UndoableTextArea(5, 20), "Center");
        jFrame.pack();
        jFrame.setVisible(true);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.undo.clear();
        this.redo.clear();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    final class KeyHandler
    extends KeyAdapter {
        KeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (InputEventSupport.isControlDown(keyEvent)) {
                UndoableEdit undoableEdit;
                if (keyEvent.getKeyCode() == 90 && !UndoableTextArea.this.undo.isEmpty()) {
                    UndoableEdit undoableEdit2 = UndoableTextArea.this.undo.get(UndoableTextArea.this.undo.size() - 1);
                    if (undoableEdit2 != null) {
                        undoableEdit2.undo();
                        UndoableTextArea.this.undo.remove(undoableEdit2);
                        UndoableTextArea.this.redo.add(undoableEdit2);
                        keyEvent.consume();
                    }
                } else if (keyEvent.getKeyCode() == 89 && !UndoableTextArea.this.redo.isEmpty() && (undoableEdit = UndoableTextArea.this.redo.get(UndoableTextArea.this.redo.size() - 1)) != null) {
                    undoableEdit.redo();
                    UndoableTextArea.this.redo.remove(undoableEdit);
                    UndoableTextArea.this.undo.add(undoableEdit);
                    keyEvent.consume();
                }
            }
        }
    }

    final class UndoableListener
    implements UndoableEditListener {
        UndoableListener() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            UndoableTextArea.this.undo.add(undoableEditEvent.getEdit());
            UndoableTextArea.this.redo.clear();
        }
    }
}

