/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.draw;

import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import net.astah.golf.control.BaseCommandSetting;
import net.astah.golf.control.FocusActionListener;
import net.astah.golf.control.GolfAction;
import net.astah.golf.model.ModelPropertyEditor;

public class GTextField
extends JTextField
implements ModelPropertyEditor<String> {
    private static final long serialVersionUID = 2481574442921512252L;
    protected static FocusActionListener focusListener;
    private static GolfAction actionListener;
    private boolean dirty = false;
    private DirtyDocumentListener dirtyDocumentListener = new DirtyDocumentListener();

    public GTextField() {
        this.init();
    }

    public GTextField(String string) {
        super(string);
        this.init();
    }

    public GTextField(int n) {
        super(n);
        this.init();
    }

    public GTextField(String string, int n) {
        super(string, n);
        this.init();
    }

    public GTextField(Document document, String string, int n) {
        super(document, string, n);
        this.init();
    }

    protected void init() {
        this.addFocusListener(focusListener);
        this.addActionListener(actionListener);
        this.getDocument().addDocumentListener(this.dirtyDocumentListener);
    }

    public static GolfAction getActionListener() {
        return actionListener;
    }

    public static FocusActionListener getFocusActionListener() {
        return focusListener;
    }

    @Override
    protected void fireActionPerformed() {
        if (this.isDirty()) {
            super.fireActionPerformed();
        }
    }

    @Override
    public void setInitialValue(String string) {
        this.getDocument().removeDocumentListener(this.dirtyDocumentListener);
        this.setText(string);
        this.dirty = false;
        this.getDocument().addDocumentListener(this.dirtyDocumentListener);
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public String getValue() {
        return this.getText();
    }

    static {
        actionListener = new GolfAction(BaseCommandSetting.getModelUpdateCommandName());
        focusListener = new FocusActionListener(BaseCommandSetting.getModelUpdateCommandName());
    }

    private final class DirtyDocumentListener
    implements DocumentListener {
        private DirtyDocumentListener() {
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            GTextField.this.dirty = true;
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            GTextField.this.dirty = true;
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            GTextField.this.dirty = true;
        }
    }
}

