/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.draw;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import net.astah.golf.draw.GGeometry;
import net.astah.golf.draw.GGraphics;
import net.astah.golf.draw.GNode;
import net.astah.golf.draw.GTransform;
import net.astah.golf.draw.GTranslate;
import net.astah.golf.draw.RenderingHintsHelper;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.geom2D.Rectangle2d;
import net.astah.golf.util.GolfUtilities;
import net.astah.golf.widget.CColor;
import net.astah.golf.widget.CGraphics;
import net.astah.golf.widget.CGraphics2D;
import net.astah.golf.widget.swing.SwingGraphics;

public class GText
extends GGeometry {
    String text;
    String[] lines = null;
    int noLines = 0;
    Font font;
    protected boolean underlineOn;
    double leading = 0.0;
    private boolean wrapLine = false;
    private float wrappingWidth = 10.0f;
    private Pnt2d[] knobPoints;
    private List<Object[]> textLayouts;
    private boolean textLayoutShouldBeUpdated = true;
    public static double sizeRatio = 1.0;
    protected boolean highlighted = false;
    private static CColor highlightColor;

    public GText() {
        this(null, null);
    }

    public GText(String string) {
        this(string, null);
    }

    public GText(String string, Font font) {
        this.boundingBox = new Rectangle2d();
        this.setText(string);
        this.setFont(font);
    }

    @Override
    public void setPoint(double d2, double d3) {
        super.setPoint(d2, d3);
        this.boundingBoxShouldBeUpdated = true;
    }

    public void setText(String string) {
        if (this.text != null && string != null && this.text.equals(string)) {
            return;
        }
        this.textLayoutShouldBeUpdated = true;
        this.boundingBoxShouldBeUpdated = true;
        this.text = string;
        if (string != null) {
            int n = 0;
            int n2 = string.length();
            for (int k = 0; k < n2; ++k) {
                if (string.charAt(k) != '\n') continue;
                ++n;
            }
            this.setNewText(string, n);
        }
    }

    public void setNewText(String string, int n) {
        this.lines = new String[n + 1];
        if (n == 0) {
            this.lines[0] = string;
            this.noLines = 1;
        } else {
            this.noLines = 0;
            boolean bl = true;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\r", true);
            while (stringTokenizer.hasMoreElements()) {
                String string2 = stringTokenizer.nextToken();
                char c2 = string2.charAt(0);
                if (c2 == '\n') {
                    if (bl) {
                        this.lines[this.noLines] = " ";
                        ++this.noLines;
                    }
                    bl = true;
                    continue;
                }
                if (c2 == '\r') continue;
                bl = false;
                this.lines[this.noLines] = string2;
                ++this.noLines;
            }
        }
    }

    public String getText() {
        return this.text;
    }

    public void setFont(Font font) {
        if (this.font == null || font == null || !this.font.equals(font)) {
            this.font = font;
            this.boundingBoxShouldBeUpdated = true;
            this.textLayoutShouldBeUpdated = true;
            if (GraphicsEnvironment.isHeadless() && font != null && sizeRatio != 1.0) {
                this.font = font.deriveFont((float)((double)font.getSize() * sizeRatio));
            }
        }
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    public Rectangle2d getFrame(CGraphics cGraphics) {
        return this.getBounds2d(cGraphics);
    }

    @Override
    public Rectangle2d getBounds2d(CGraphics cGraphics) {
        int n;
        if (!this.boundingBoxShouldBeUpdated) {
            return this.boundingBox;
        }
        Rectangle2D rectangle2D = this.font == null ? cGraphics.getStringBounds(this.lines[0]) : cGraphics.getStringBounds(this.lines[0], this.font);
        double d2 = rectangle2D.getWidth();
        double d3 = rectangle2D.getHeight();
        double d4 = this.y - d3;
        for (n = 1; n < this.noLines; ++n) {
            rectangle2D = cGraphics.getStringBounds(this.lines[n]);
            d3 += rectangle2D.getHeight();
            double d5 = rectangle2D.getWidth();
            if (!(d5 > d2)) continue;
            d2 = d5;
        }
        n = this.getDescent();
        this.boundingBox.setRect(this.x, d4 + (double)n, d2, d3 + (double)(this.noLines - 1) * this.leading);
        this.boundingBoxShouldBeUpdated = false;
        return this.boundingBox;
    }

    public int getDescent() {
        if (this.doWrapLine()) {
            return 0;
        }
        if (this.font != null) {
            return (int)(GolfUtilities.computeStringHeight(this.font, "m") * 0.2) + 1;
        }
        return 3;
    }

    @Override
    public double getHeight(CGraphics cGraphics, int n) {
        Rectangle2D rectangle2D = this.font == null ? cGraphics.getStringBounds(this.lines[n]) : cGraphics.getStringBounds(this.lines[n], this.font);
        return rectangle2D.getHeight();
    }

    @Override
    public int getDiagonalLength(GGraphics gGraphics) {
        Rectangle2d rectangle2d = this.getBounds2d(gGraphics.graphics);
        return (int)Math.round(Math.sqrt(rectangle2d.width * rectangle2d.width + rectangle2d.height * rectangle2d.height) * gGraphics.camera.scale);
    }

    public void setLeading(double d2) {
        this.leading = d2;
    }

    public double getLeading() {
        return this.leading;
    }

    @Override
    public Pnt2d[] getKnobPoints() {
        if (this.knobPoints == null) {
            this.knobPoints = new Pnt2d[4];
            this.knobPoints[0] = new Pnt2d();
            this.knobPoints[1] = new Pnt2d();
            this.knobPoints[2] = new Pnt2d();
            this.knobPoints[3] = new Pnt2d();
        }
        this.knobPoints[0].set(this.boundingBox.x, this.boundingBox.y);
        this.knobPoints[1].set(this.boundingBox.x, this.boundingBox.y + this.boundingBox.height);
        this.knobPoints[2].set(this.boundingBox.x + this.boundingBox.width, this.boundingBox.y + this.boundingBox.height);
        this.knobPoints[3].set(this.boundingBox.x + this.boundingBox.width, this.boundingBox.y);
        return this.knobPoints;
    }

    public int getNoLines() {
        return this.noLines;
    }

    public String getLine(int n) {
        return this.lines[n];
    }

    public void setString(String string) {
        this.setText(string);
    }

    public String getString() {
        return this.text;
    }

    public void setWrapLine(boolean bl) {
        if (this.wrapLine != bl) {
            this.wrapLine = bl;
            this.textLayoutShouldBeUpdated = true;
            this.boundingBoxShouldBeUpdated = true;
        }
    }

    public boolean doWrapLine() {
        return this.wrapLine;
    }

    public float getWrappingWidth() {
        return this.wrappingWidth;
    }

    public void setWrappingWidth(float f2) {
        if (this.wrappingWidth != f2) {
            this.wrappingWidth = f2;
            this.textLayoutShouldBeUpdated = true;
            this.boundingBoxShouldBeUpdated = true;
        }
    }

    @Override
    protected List<Object[]> getTextLayouts(CGraphics2D cGraphics2D) {
        if (this.textLayouts == null || this.textLayoutShouldBeUpdated) {
            this.textLayouts = this.createTextLayouts(cGraphics2D);
        }
        return this.textLayouts;
    }

    private List<Object[]> createTextLayouts(CGraphics2D cGraphics2D) {
        this.textLayoutShouldBeUpdated = false;
        AffineTransform affineTransform = cGraphics2D.getTransform();
        AffineTransform affineTransform2 = new AffineTransform();
        cGraphics2D.setTransform(affineTransform2);
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        FontRenderContext fontRenderContext = cGraphics2D.getFontRenderContext();
        Map<TextAttribute, ?> map = this.getAttributeMap();
        if (this.doWrapLine()) {
            double d2 = 0.0;
            for (int k = 0; k < this.getNoLines(); ++k) {
                String string = this.getLine(k);
                if (string.length() == 0) {
                    d2 = this.getLeading();
                }
                AttributedString attributedString = new AttributedString(string, map);
                LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedString.getIterator(), fontRenderContext);
                while (lineBreakMeasurer.getPosition() < string.length()) {
                    TextLayout textLayout = lineBreakMeasurer.nextLayout(this.getWrappingWidth());
                    Object[] objectArray = new Object[]{new Pnt2d(0.0, d2 += (double)textLayout.getAscent()), textLayout};
                    arrayList.add(objectArray);
                    d2 += (double)(textLayout.getDescent() + textLayout.getLeading());
                }
            }
        } else {
            if (!this.underlineOn) {
                cGraphics2D.setTransform(affineTransform);
                return null;
            }
            double d3 = 0.0;
            for (int k = 0; k < this.noLines; ++k) {
                String string = this.getLine(k);
                if (string.length() > 0) {
                    AttributedString attributedString = new AttributedString(string, map);
                    LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedString.getIterator(), fontRenderContext);
                    while (lineBreakMeasurer.getPosition() < string.length()) {
                        TextLayout textLayout = lineBreakMeasurer.nextLayout(Float.MAX_VALUE);
                        Object[] objectArray = new Object[]{new Pnt2d(0.0, d3), textLayout};
                        arrayList.add(objectArray);
                    }
                }
                if (this.noLines - k - 1 == 0) continue;
                d3 += this.getHeight(cGraphics2D, k) + this.getLeading();
            }
        }
        cGraphics2D.setTransform(affineTransform);
        return arrayList;
    }

    private Map<TextAttribute, ?> getAttributeMap() {
        Map<Object, Object> map;
        Map<Object, Object> map2 = map = this.font == null ? new HashMap() : this.font.getAttributes();
        if (this.underlineOn) {
            map.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL);
        }
        return map;
    }

    public boolean intersect(Rectangle2d rectangle2d, CGraphics2D cGraphics2D) {
        Rectangle2d rectangle2d2 = this.getBounds2d(cGraphics2D);
        return rectangle2d.intersects(rectangle2d2);
    }

    @Override
    void draw(CGraphics2D cGraphics2D, CColor cColor, CColor cColor2) {
        int n;
        Rectangle2d rectangle2d;
        if (highlightColor != null && this.highlighted && this.parent instanceof GGeometry && (rectangle2d = ((GGeometry)this.parent).getBounds2d(cGraphics2D)) != null) {
            cGraphics2D.setColor(highlightColor);
            cGraphics2D.fill(rectangle2d);
        }
        if ((n = this.getNoLines()) < 1) {
            return;
        }
        Object object = cGraphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        if (RenderingHintsHelper.isTextAntiAliasing) {
            cGraphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            cGraphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        Font font = this.getFont();
        if (font != null) {
            cGraphics2D.setFont(font);
        }
        cGraphics2D.setColor(cColor);
        this.drawText(cGraphics2D, this.getString());
        cGraphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }

    private void drawText(CGraphics2D cGraphics2D, String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        List<Object[]> list = this.getTextLayouts(cGraphics2D);
        if (list == null || list.size() == 0) {
            GTranslate gTranslate = new GTranslate(this.x, this.y);
            if (SwingGraphics.preScale > 0.0) {
                gTranslate.setOffset(this.x * SwingGraphics.preScale, this.y * SwingGraphics.preScale);
            }
            gTranslate.saveTransform(cGraphics2D);
            gTranslate.transform(cGraphics2D);
            double d2 = 0.0;
            for (int k = 0; k < this.noLines; ++k) {
                String string2 = this.getLine(k);
                if (string2.length() > 0) {
                    cGraphics2D.drawString(string2, 0.0f, (float)d2);
                }
                if (this.noLines - k - 1 == 0) continue;
                d2 += this.getHeight(cGraphics2D, k) + this.getLeading();
            }
            gTranslate.loadTransform(cGraphics2D);
            return;
        }
        String string3 = string;
        for (Object[] objectArray : list) {
            Pnt2d pnt2d = (Pnt2d)objectArray[0];
            TextLayout textLayout = (TextLayout)objectArray[1];
            string3 = this.drawMultilineTextDrawable(cGraphics2D, string3, pnt2d, textLayout);
        }
    }

    private String drawMultilineTextDrawable(CGraphics2D cGraphics2D, String string, Pnt2d pnt2d, TextLayout textLayout) {
        String string2 = string;
        int n = textLayout.getCharacterCount();
        if (n > 0) {
            GTranslate gTranslate = new GTranslate(this.x, this.y);
            if (SwingGraphics.preScale > 0.0) {
                gTranslate.setOffset(this.x * SwingGraphics.preScale, this.y * SwingGraphics.preScale);
            }
            gTranslate.saveTransform(cGraphics2D);
            gTranslate.transform(cGraphics2D);
            if (this.underlineOn) {
                Map<TextAttribute, ?> map = this.getAttributeMap();
                String string3 = this.translateStr(string.substring(0, n)).trim();
                if (string3.length() != 0) {
                    AttributedString attributedString = new AttributedString(string3, map);
                    cGraphics2D.drawString(attributedString.getIterator(), (float)pnt2d.x, (float)pnt2d.y);
                }
            } else {
                cGraphics2D.drawString(string.substring(0, n), (float)pnt2d.x, (float)pnt2d.y);
            }
            gTranslate.loadTransform(cGraphics2D);
            string2 = string.substring(n);
        }
        if (string.charAt(n - 1) != '\n' && string2.startsWith("\n")) {
            string2 = string2.substring("\n".length());
        }
        return string2;
    }

    @Override
    public boolean isPicked(CGraphics2D cGraphics2D, Rectangle rectangle) {
        if (this.pickable) {
            int n;
            GTransform gTransform = null;
            int n2 = this.transformList.size();
            if (n2 > 0) {
                gTransform = (GTransform)this.transformList.get(0);
                gTransform.saveTransform(cGraphics2D);
                for (n = 0; n < n2; ++n) {
                    ((GTransform)this.transformList.get(n)).transform(cGraphics2D);
                }
            }
            if (rectangle.width == 0) {
                rectangle = new Rectangle(rectangle.x, rectangle.y, 1, rectangle.height == 0 ? 1 : rectangle.height);
            } else if (rectangle.height == 0) {
                rectangle = new Rectangle(rectangle.x, rectangle.y, rectangle.width, 1);
            }
            if (this.getNoLines() > 0 && this.isSelected(rectangle, cGraphics2D)) {
                if (gTransform != null) {
                    gTransform.loadTransform(cGraphics2D);
                }
                return true;
            }
            n2 = this.nodeList.size();
            for (n = 0; n < n2; ++n) {
                GNode gNode = (GNode)this.nodeList.get(n);
                if (!gNode.pickable || !gNode.isPicked(cGraphics2D, rectangle)) continue;
                if (gTransform != null) {
                    gTransform.loadTransform(cGraphics2D);
                }
                return true;
            }
            if (gTransform != null) {
                gTransform.loadTransform(cGraphics2D);
            }
        }
        return false;
    }

    private boolean isSelected(Rectangle rectangle, CGraphics2D cGraphics2D) {
        Rectangle2d rectangle2d = new Rectangle2d(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        return this.intersect(rectangle2d, cGraphics2D);
    }

    public boolean isUnderlineOn() {
        return this.underlineOn;
    }

    public void setUnderlineOn(boolean bl) {
        if (this.isUnderlineOn() != bl) {
            this.underlineOn = bl;
            this.textLayoutShouldBeUpdated = true;
        }
    }

    public String translateStr(String string) {
        for (int k = string.length(); k > 0; --k) {
            if ("\u3002\u3002".equals(string.substring(k - 1, k)) || " ".equals(string.substring(k - 1, k)) || "\u3000".equals(string.substring(k - 1, k))) continue;
            return string.substring(0, k);
        }
        return "";
    }

    public void setHighlighted(boolean bl) {
        this.highlighted = bl;
    }

    public boolean isHighlighted() {
        return this.highlighted;
    }

    public static void setHighlightColor(CColor cColor) {
        highlightColor = cColor;
    }
}

