/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.draw;

import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import net.astah.golf.draw.GCurve;
import net.astah.golf.draw.GRimmedGeometry;
import net.astah.golf.geom2D.CubicCurve2d;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GSharpCurve
extends GCurve {
    private GeneralPath graph = new GeneralPath();
    private CubicCurve2d cubicCurve2d2 = new CubicCurve2d();
    static BasicStroke CURVE_STROKE = new BasicStroke(1.0f, 2, 0, 10.0f, null, 0.0f);
    private static final Logger logger = LoggerFactory.getLogger(GSharpCurve.class);

    public GSharpCurve(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, double d15, double d16, double d17) {
        super(d2, d3, d4, d5, d6, d7, d8, d9);
        this.setCurve2(d10, d11, d12, d13, d14, d15, d16, d17);
    }

    @Override
    public void setCurve(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        super.setCurve(d2, d3, d4, d5, d6, d7, d8, d9);
        this.updateGraph();
    }

    public void setCurve2(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        this.cubicCurve2d2.setCurve(d8, d9, d6, d7, d4, d5, d2, d3);
        this.updateGraph();
    }

    private void updateGraph() {
        if (this.graph != null) {
            this.setRimWidth(1);
            this.graph.reset();
            this.graph.append(this.cubicCurve2d, true);
            this.graph.append(this.cubicCurve2d2, true);
            this.graph.closePath();
            this.moveKnobAndShadow();
            if (logger.isDebugEnabled()) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("curve1: x1=").append(this.cubicCurve2d.x1);
                stringBuilder.append(", y1=").append(this.cubicCurve2d.y1);
                stringBuilder.append(", cx1=").append(this.cubicCurve2d.ctrlx1);
                stringBuilder.append(", cy1=").append(this.cubicCurve2d.ctrly1);
                stringBuilder.append(", cx2=").append(this.cubicCurve2d.ctrlx2);
                stringBuilder.append(", cy2=").append(this.cubicCurve2d.ctrly2);
                stringBuilder.append(", x2=").append(this.cubicCurve2d.x2);
                stringBuilder.append(", y2=").append(this.cubicCurve2d.y2);
                logger.debug(stringBuilder.toString());
                stringBuilder = new StringBuilder();
                stringBuilder.append("curve2: x1=").append(this.cubicCurve2d2.x1);
                stringBuilder.append(", y1=").append(this.cubicCurve2d2.y1);
                stringBuilder.append(", cx1=").append(this.cubicCurve2d2.ctrlx1);
                stringBuilder.append(", cy1=").append(this.cubicCurve2d2.ctrly1);
                stringBuilder.append(", cx2=").append(this.cubicCurve2d2.ctrlx2);
                stringBuilder.append(", cy2=").append(this.cubicCurve2d2.ctrly2);
                stringBuilder.append(", x2=").append(this.cubicCurve2d2.x2);
                stringBuilder.append(", y2=").append(this.cubicCurve2d2.y2);
                logger.debug(stringBuilder.toString());
            }
        }
    }

    @Override
    public Shape getShape(int n) {
        return this.graph;
    }

    @Override
    public BasicStroke getStroke() {
        return CURVE_STROKE;
    }

    public void setStroke(BasicStroke basicStroke) {
        CURVE_STROKE = basicStroke;
    }

    @Override
    public String toString() {
        return "GSharpCurve";
    }

    @Override
    public GRimmedGeometry getShadow() {
        GSharpCurve gSharpCurve = new GSharpCurve(this.cubicCurve2d.x1, this.cubicCurve2d.y1, this.cubicCurve2d.ctrlx1, this.cubicCurve2d.ctrly1, this.cubicCurve2d.ctrlx2, this.cubicCurve2d.ctrly2, this.cubicCurve2d.x2, this.cubicCurve2d.y2, this.cubicCurve2d2.x2, this.cubicCurve2d2.y2, this.cubicCurve2d2.ctrlx2, this.cubicCurve2d2.ctrly2, this.cubicCurve2d2.ctrlx1, this.cubicCurve2d2.ctrly1, this.cubicCurve2d2.x1, this.cubicCurve2d2.y1);
        return gSharpCurve;
    }
}

