/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.draw;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.astah.golf.draw.GCamera;
import net.astah.golf.draw.GDepthEvent;
import net.astah.golf.draw.GDepthListener;
import net.astah.golf.draw.GGraphics;
import net.astah.golf.draw.GNode;
import net.astah.golf.draw.GRect;
import net.astah.golf.draw.GRoot;
import net.astah.golf.draw.GSceneEvent;
import net.astah.golf.draw.GSceneListener;
import net.astah.golf.draw.GTransform;
import net.astah.golf.widget.CGraphics2D;

public class GScene
implements GDepthListener {
    private List<GNode> treeList = new ArrayList<GNode>(1);
    private GCamera camera = null;
    private List<GSceneListener> sceneListenerList = new ArrayList<GSceneListener>(1);
    boolean visible = true;
    boolean pickable = true;
    boolean selectable = true;
    private boolean doAntialiasing = true;

    public GScene() {
    }

    public GScene(GCamera gCamera) {
        this.setCamera(gCamera);
    }

    public void addTree(GRoot gRoot) {
        this.treeList.add(GNode.getInsertPosition(this.treeList, gRoot.depth), gRoot);
        gRoot.addDepthListener(this);
    }

    public void removeTree(GRoot gRoot) {
        this.removeTree((GNode)gRoot);
    }

    public void removeAllTrees() {
        while (this.treeList.size() > 0) {
            this.removeTree(this.treeList.get(0));
        }
    }

    public GRoot[] getAllTrees() {
        return this.treeList.toArray(new GRoot[this.treeList.size()]);
    }

    public void setCamera(GCamera gCamera) {
        this.camera = gCamera;
    }

    public GCamera getCamera() {
        return this.camera;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setPickable(boolean bl) {
        this.pickable = bl;
    }

    public boolean isPickable() {
        return this.pickable;
    }

    public void setSelectable(boolean bl) {
        this.selectable = bl;
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public void draw(GGraphics gGraphics) {
        int n = this.treeList.size();
        boolean bl = true;
        for (int k = 0; k < n; ++k) {
            GNode gNode = this.treeList.get(k);
            if (!gNode.visible || gGraphics.isEnableViewport() && (!gGraphics.isEnableViewport() || !gNode.intersect(gGraphics.getViewport()))) continue;
            gGraphics.setCamera(this.camera);
            CGraphics2D cGraphics2D = gGraphics.getGraphics2D();
            if (!gGraphics.printing) {
                GTransform.resetTransform(cGraphics2D);
            }
            if (this.camera != null) {
                if (gGraphics.printing) {
                    if (bl) {
                        this.camera.transform(cGraphics2D);
                        bl = false;
                    }
                } else {
                    this.camera.transform(cGraphics2D);
                }
            }
            gGraphics.setAntialiasing(this.doAntialiasing);
            if (gGraphics.drawingOrder == null) {
                gNode.draw(gGraphics);
                continue;
            }
            for (int i2 = 0; i2 < gGraphics.drawingOrder.length; ++i2) {
                if (gGraphics.drawingOrder[i2] == 0) continue;
                gNode.draw(gGraphics, gGraphics.drawingOrder[i2]);
            }
        }
    }

    void transformByCamera(CGraphics2D cGraphics2D) {
        GTransform.resetTransform(cGraphics2D);
        if (this.camera != null) {
            this.camera.transform(cGraphics2D);
        }
    }

    public void draw(GGraphics gGraphics, int n) {
        int n2 = this.treeList.size();
        for (int k = 0; k < n2; ++k) {
            GNode gNode = this.treeList.get(k);
            if (!gNode.visible) continue;
            gGraphics.setCamera(this.camera);
            this.transformByCamera(gGraphics.getGraphics2D());
            gNode.draw(gGraphics, n);
        }
    }

    public void drawTemp(GGraphics gGraphics) {
        int n = this.treeList.size();
        for (int k = 0; k < n; ++k) {
            GNode gNode = this.treeList.get(k);
            if (!gNode.visible) continue;
            gGraphics.setCamera(this.camera);
            this.transformByCamera(gGraphics.getGraphics2D());
            gNode.drawTemp(gGraphics);
        }
    }

    public List<GNode> getPickedNodesWithLevel(CGraphics2D cGraphics2D, Rectangle rectangle, int n) {
        return this.getPickedNodesWithLevel(cGraphics2D, rectangle, n, false);
    }

    public List<GNode> getPickedNodesWithLevel(CGraphics2D cGraphics2D, Rectangle rectangle, int n, boolean bl) {
        if (this.pickable) {
            this.transformByCamera(cGraphics2D);
            ArrayList<GNode> arrayList = new ArrayList<GNode>();
            for (int k = this.treeList.size() - 1; !(k < 0 || bl && arrayList.size() != 0); --k) {
                List<GNode> list = this.treeList.get(k).getPickedNodesWithLevel(cGraphics2D, rectangle, n);
                if (list == null || list.size() <= 0) continue;
                this.setupPickedNodeList(list, bl, arrayList, rectangle);
            }
            return arrayList;
        }
        return null;
    }

    void setupPickedNodeList(List<GNode> list, boolean bl, List<GNode> list2, Rectangle rectangle) {
        if (list != null) {
            int n;
            ArrayList<GNode> arrayList = new ArrayList<GNode>(0);
            int n2 = 15;
            for (n = 0; n < list.size(); ++n) {
                GNode gNode = list.get(n);
                if (gNode == null || !(gNode instanceof GRect) || !((GRect)gNode).getShape(0).contains(rectangle.getCenterX(), rectangle.getCenterY()) || !(((GRect)gNode).getWidth() < (double)n2) || !(((GRect)gNode).getHeight() < (double)n2)) continue;
                arrayList.add(gNode);
            }
            if (!arrayList.isEmpty()) {
                this.setupNodeList(arrayList, bl, list2);
                return;
            }
            if (bl && list.size() > 0) {
                this.setupNodeList(list, bl, list2);
            } else {
                for (n = 0; n < list.size(); ++n) {
                    list2.add(list.get(n));
                }
            }
        }
    }

    private void setupNodeList(List<GNode> list, boolean bl, List<GNode> list2) {
        int n;
        int n2 = list.get((int)0).depth;
        for (n = 1; n < list.size(); ++n) {
            if (list.get(n) == null || list.get((int)n).depth >= n2) continue;
            n2 = list.get((int)n).depth;
        }
        for (n = 0; n < list.size(); ++n) {
            if (list.get(n) == null || list.get((int)n).depth != n2) continue;
            list2.add(list.get(n));
        }
    }

    public List<GNode> getPickedNodes(CGraphics2D cGraphics2D, Rectangle rectangle, int n) {
        return this.getPickedNodes(cGraphics2D, rectangle, n, false);
    }

    public List<GNode> getPickedNodes(CGraphics2D cGraphics2D, Rectangle rectangle, int n, boolean bl) {
        if (this.pickable) {
            this.transformByCamera(cGraphics2D);
            ArrayList<GNode> arrayList = new ArrayList<GNode>();
            for (int k = this.treeList.size() - 1; !(k < 0 || bl && arrayList.size() != 0); --k) {
                List<GNode> list = this.treeList.get(k).getPickedNodes(cGraphics2D, rectangle, n);
                if (list == null || list.size() <= 0) continue;
                this.setupPickedNodeList(list, bl, arrayList, rectangle);
            }
            return arrayList;
        }
        return null;
    }

    public void selectWithLevel(CGraphics2D cGraphics2D, Rectangle rectangle, int n) {
        this.selectWithLevel(cGraphics2D, rectangle, n, false);
    }

    public void selectWithLevel(CGraphics2D cGraphics2D, Rectangle rectangle, int n, boolean bl) {
        if (this.selectable && this.pickable) {
            List<GNode> list = this.getPickedNodesWithLevel(cGraphics2D, rectangle, n, bl);
            for (int k = 0; k < list.size(); ++k) {
                list.get(k).setSelected(true);
            }
        }
    }

    public void select(CGraphics2D cGraphics2D, Rectangle rectangle, int n) {
        this.select(cGraphics2D, rectangle, n, false);
    }

    public void select(CGraphics2D cGraphics2D, Rectangle rectangle, int n, boolean bl) {
        if (this.selectable && this.pickable) {
            List<GNode> list = this.getPickedNodes(cGraphics2D, rectangle, n, bl);
            for (int k = 0; k < list.size(); ++k) {
                list.get(k).setSelected(true);
            }
        }
    }

    public void unselect() {
        List<GNode> list = this.getSelectedNodes();
        for (int k = 0; k < list.size(); ++k) {
            list.get(k).setSelected(false);
        }
    }

    public List<GNode> getSelectedNodes() {
        int n = this.treeList.size();
        ArrayList<GNode> arrayList = new ArrayList<GNode>();
        for (int k = 0; k < n; ++k) {
            List<GNode> list = this.treeList.get(k).getSelectedNodes();
            if (list == null || list.isEmpty()) continue;
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public List<GNode> getAllNodes() {
        int n = this.treeList.size();
        ArrayList<GNode> arrayList = new ArrayList<GNode>();
        for (int k = 0; k < n; ++k) {
            arrayList.add(this.treeList.get(k));
            List<GNode> list = this.treeList.get(k).getAllNodes();
            if (list == null || list.isEmpty()) continue;
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public List<GNode> getSelectedNodes(int n) {
        int n2 = this.treeList.size();
        ArrayList<GNode> arrayList = new ArrayList<GNode>();
        for (int k = 0; k < n2; ++k) {
            List<GNode> list = this.treeList.get(k).getSelectedNodes(n);
            if (list == null) continue;
            for (int i2 = 0; i2 < list.size(); ++i2) {
                if (list.get(i2) == null) continue;
                arrayList.add(list.get(i2));
            }
        }
        return arrayList;
    }

    public synchronized void addSceneListener(GSceneListener gSceneListener) {
        this.sceneListenerList.add(gSceneListener);
    }

    public synchronized void removeSceneListener(GSceneListener gSceneListener) {
        this.sceneListenerList.remove(gSceneListener);
    }

    public synchronized void fireSceneChange(GSceneEvent gSceneEvent) {
        int n = this.sceneListenerList.size();
        for (int k = 0; k < n; ++k) {
            this.sceneListenerList.get(k).sceneChange(gSceneEvent);
        }
    }

    public void repaintComponent() {
        int n = this.treeList.size();
        for (int k = 0; k < n; ++k) {
            GNode gNode = this.treeList.get(k);
            if (!gNode.visible) continue;
            gNode.repaintComponent();
        }
    }

    @Override
    public void depthChange(GDepthEvent gDepthEvent) {
        GNode.depthChange(this.treeList, gDepthEvent);
    }

    public GNode getTree() {
        return this.treeList.size() == 0 ? null : this.treeList.get(0);
    }

    public void addTree(GNode gNode) {
        this.treeList.add(GNode.getInsertPosition(this.treeList, gNode.depth), gNode);
        gNode.addDepthListener(this);
    }

    public void removeTree(GNode gNode) {
        this.treeList.remove(gNode);
        gNode.removeDepthListener(this);
    }

    public boolean isDoAntialiasing() {
        return this.doAntialiasing;
    }

    public void setDoAntialiasing(boolean bl) {
        this.doAntialiasing = bl;
    }
}

