/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.draw;

import java.util.ArrayList;
import java.util.List;
import net.astah.golf.draw.GGeneralPath;
import net.astah.golf.draw.GRimmedGeometry;
import net.astah.golf.geom2D.Pnt2d;

public class GRoundedGeneralPath
extends GGeneralPath {
    private static final int DELTA = 15;
    private static final int CURVE_HEIGHT = 5;

    public GRoundedGeneralPath() {
    }

    public GRoundedGeneralPath(Pnt2d[] pnt2dArray) {
        super(pnt2dArray);
    }

    @Override
    public void setPoints(Pnt2d[] pnt2dArray) {
        this.boundingBoxShouldBeUpdated = true;
        this.path.reset();
        Pnt2d[] pnt2dArray2 = this.getAllPoints(pnt2dArray);
        if (pnt2dArray2.length > 0) {
            this.path.moveTo((float)pnt2dArray2[0].x, (float)pnt2dArray2[0].y);
            for (int k = 1; k <= pnt2dArray2.length; k += 2) {
                Pnt2d pnt2d = pnt2dArray2[k % pnt2dArray2.length];
                Pnt2d pnt2d2 = pnt2dArray2[(k + 1) % pnt2dArray2.length];
                this.path.lineTo((float)pnt2d.x, (float)pnt2d.y);
                Pnt2d pnt2d3 = this.getControlPoint(pnt2d, pnt2d2);
                this.path.quadTo((float)pnt2d3.x, (float)pnt2d3.y, (float)pnt2d2.x, (float)pnt2d2.y);
            }
            this.path.closePath();
        }
        this.points = pnt2dArray;
        this.moveKnobAndShadow();
    }

    private Pnt2d[] getAllPoints(Pnt2d[] pnt2dArray) {
        ArrayList<Pnt2d> arrayList = new ArrayList<Pnt2d>();
        if (pnt2dArray != null) {
            for (int k = 0; k < pnt2dArray.length; ++k) {
                arrayList.addAll(this.getEndPoints(pnt2dArray[k], pnt2dArray[(k + 1) % pnt2dArray.length]));
            }
        }
        return arrayList.toArray(new Pnt2d[0]);
    }

    private List<Pnt2d> getEndPoints(Pnt2d pnt2d, Pnt2d pnt2d2) {
        ArrayList<Pnt2d> arrayList = new ArrayList<Pnt2d>();
        Pnt2d pnt2d3 = this.getDeltaPoint(pnt2d, pnt2d2);
        arrayList.add(new Pnt2d(pnt2d.x + pnt2d3.x, pnt2d.y + pnt2d3.y));
        arrayList.add(new Pnt2d(pnt2d2.x - pnt2d3.x, pnt2d2.y - pnt2d3.y));
        return arrayList;
    }

    private Pnt2d getDeltaPoint(Pnt2d pnt2d, Pnt2d pnt2d2) {
        if (pnt2d.x == pnt2d2.x) {
            int n = pnt2d.y < pnt2d2.y ? 10 : -10;
            return new Pnt2d(0.0, n);
        }
        double d2 = this.getGradient(pnt2d, pnt2d2);
        double d3 = Math.sqrt(Math.pow(15.0, 2.0) / (1.0 + Math.pow(d2, 2.0)));
        double d4 = pnt2d.x < pnt2d2.x ? d3 : -d3;
        double d5 = d2 * d4;
        return new Pnt2d(d4, d5);
    }

    private double getGradient(Pnt2d pnt2d, Pnt2d pnt2d2) {
        double d2 = pnt2d2.x - pnt2d.x;
        double d3 = pnt2d2.y - pnt2d.y;
        return d3 / d2;
    }

    private Pnt2d getControlPoint(Pnt2d pnt2d, Pnt2d pnt2d2) {
        double d2 = Math.min(pnt2d.x, pnt2d2.x) + Math.abs(pnt2d.x - pnt2d2.x) / 2.0;
        double d3 = Math.min(pnt2d.y, pnt2d2.y) + Math.abs(pnt2d.y - pnt2d2.y) / 2.0;
        if (pnt2d.x == pnt2d2.x) {
            double d4 = pnt2d.y < pnt2d2.y ? 5.0 : -5.0;
            return new Pnt2d(d2 + d4, d3);
        }
        double d5 = this.getGradient(pnt2d, pnt2d2);
        double d6 = Math.sqrt(Math.pow(5.0, 2.0) / (1.0 + Math.pow(d5, 2.0)));
        double d7 = pnt2d.x < pnt2d2.x ? -d6 : d6;
        double d8 = -d5 * d7;
        return new Pnt2d(d2 + d8, d3 + d7);
    }

    @Override
    public GRimmedGeometry getShadow() {
        GRoundedGeneralPath gRoundedGeneralPath = new GRoundedGeneralPath(this.points);
        gRoundedGeneralPath.setRimWidth(this.rimWidth);
        return gRoundedGeneralPath;
    }
}

