/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.draw;

import java.awt.Shape;
import net.astah.golf.draw.GGraphics;
import net.astah.golf.draw.GRimmedGeometry;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.geom2D.Rectangle2d;
import net.astah.golf.geom2D.RoundRectangle2d;

public class GRoundRect
extends GRimmedGeometry {
    RoundRectangle2d roundRectangle2d;

    public GRoundRect() {
        this(0.0, 0.0, 0.0, 0.0);
        this.roundRectangle2d = new RoundRectangle2d();
    }

    public GRoundRect(RoundRectangle2d roundRectangle2d) {
        this(roundRectangle2d.x, roundRectangle2d.y, roundRectangle2d.width, roundRectangle2d.height);
        this.roundRectangle2d = new RoundRectangle2d();
    }

    public GRoundRect(double d2, double d3, double d4, double d5) {
        super.setPoint(d2, d3);
        this.roundRectangle2d = new RoundRectangle2d(d2, d3, d4, d5);
    }

    public GRoundRect(double d2, double d3, double d4, double d5, double d6, double d7) {
        super.setPoint(d2, d3);
        this.roundRectangle2d = new RoundRectangle2d(d2, d3, d4, d5, d6, d7);
    }

    @Override
    public void setPoint(double d2, double d3) {
        super.setPoint(d2, d3);
        this.roundRectangle2d.setRoundRect(d2, d3, this.getWidth(), this.getHeight());
    }

    public void setRoundRect(RoundRectangle2d roundRectangle2d) {
        this.setRoundRect(roundRectangle2d.x, roundRectangle2d.y, roundRectangle2d.width, roundRectangle2d.height, roundRectangle2d.getArcWidth(), roundRectangle2d.getArcHeight());
    }

    public void setRoundRect(double d2, double d3, double d4, double d5) {
        this.roundRectangle2d.setRoundRect(d2, d3, d4, d5);
        super.setPoint(d2, d3);
    }

    public void setRoundRect(double d2, double d3, double d4, double d5, double d6, double d7) {
        this.roundRectangle2d.setRoundRect(d2, d3, d4, d5, d6, d7);
        super.setPoint(d2, d3);
    }

    public void setWidth(double d2) {
        this.roundRectangle2d.setWidth(d2);
        this.moveKnobAndShadow();
    }

    public void setHeight(double d2) {
        this.roundRectangle2d.setWidth(d2);
        this.moveKnobAndShadow();
    }

    public double getWidth() {
        return this.roundRectangle2d.getWidth();
    }

    public double getHeight() {
        return this.roundRectangle2d.getHeight();
    }

    @Override
    public int getNoShapes() {
        return 1;
    }

    @Override
    public Shape getShape(int n) {
        return this.roundRectangle2d;
    }

    @Override
    public Pnt2d[] getKnobPoints() {
        Pnt2d[] pnt2dArray = new Pnt2d[4];
        double d2 = this.getWidth();
        double d3 = this.getHeight();
        pnt2dArray[0] = new Pnt2d(this.x, this.y);
        pnt2dArray[1] = new Pnt2d(this.x, this.y + d3);
        pnt2dArray[2] = new Pnt2d(this.x + d2, this.y + d3);
        pnt2dArray[3] = new Pnt2d(this.x + d2, this.y);
        return pnt2dArray;
    }

    @Override
    public int getDiagonalLength(GGraphics gGraphics) {
        double d2 = this.getWidth();
        double d3 = this.getHeight();
        return (int)Math.round(Math.sqrt(d2 * d2 + d3 * d3) * gGraphics.camera.scale);
    }

    @Override
    public GRimmedGeometry getShadow() {
        GRoundRect gRoundRect = new GRoundRect(this.x, this.y, this.getWidth(), this.getHeight(), this.getArcWidth(), this.getArcHeight());
        gRoundRect.setRimWidth(this.rimWidth);
        return gRoundRect;
    }

    public double getArcWidth() {
        return this.roundRectangle2d.getArcWidth();
    }

    public double getArcHeight() {
        return this.roundRectangle2d.getArcHeight();
    }

    public void setArcRatio(double d2) {
        this.roundRectangle2d.setArcRatio(d2);
    }

    @Override
    public boolean intersect(Rectangle2d rectangle2d) {
        boolean bl = this.isRimmedPick();
        if (bl) {
            double d2 = this.getX();
            double d3 = this.getY();
            double d4 = this.getX() + this.getWidth();
            double d5 = this.getY() + this.getHeight();
            if (rectangle2d.intersectsLine(d2, d3, d2, d5)) {
                return true;
            }
            if (rectangle2d.intersectsLine(d2, d5, d4, d5)) {
                return true;
            }
            if (rectangle2d.intersectsLine(d4, d3, d4, d5)) {
                return true;
            }
            return rectangle2d.intersectsLine(d2, d3, d4, d3);
        }
        Rectangle2d rectangle2d2 = new Rectangle2d(this.x, this.y, this.getWidth(), this.getHeight());
        return rectangle2d.intersects(rectangle2d2);
    }
}

