/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.draw;

import java.awt.BasicStroke;
import net.astah.golf.draw.GGeometry;
import net.astah.golf.util.Debug;

public abstract class GRimmedGeometry
extends GGeometry {
    public static final byte SOLID = 0;
    public static final byte DASH1 = 1;
    public static final byte DASH2 = 2;
    public static final byte DASH3 = 3;
    byte rimPattern = 0;
    int rimWidth = 1;
    int rimPatternScale = 1;
    boolean filled = false;
    static BasicStroke solid1 = new BasicStroke();
    static BasicStroke solid2 = new BasicStroke(2.0f);

    public void setRimWidth(int n) {
        this.rimWidth = n;
    }

    public int getRimWidth() {
        return this.rimWidth;
    }

    public void setRimPattern(byte by) {
        this.rimPattern = by;
    }

    public byte getRimPattern() {
        return this.rimPattern;
    }

    public void setRimPatternScale(int n) {
        this.rimPatternScale = n;
    }

    public int getRimPatternScale() {
        return this.rimPatternScale;
    }

    public void setFilled(boolean bl) {
        this.filled = bl;
    }

    @Override
    public boolean isFilled() {
        return this.filled;
    }

    @Override
    public BasicStroke getStroke() {
        switch (this.rimPattern) {
            case 0: {
                switch (this.rimWidth) {
                    case 1: {
                        return solid1;
                    }
                    case 2: {
                        return solid2;
                    }
                }
                return new BasicStroke(this.rimWidth);
            }
            case 1: {
                return new BasicStroke(this.rimWidth, 0, 0, 10.0f, new float[]{this.rimPatternScale, this.rimPatternScale}, 0.0f);
            }
            case 2: {
                return new BasicStroke(this.rimWidth, 0, 0, 10.0f, new float[]{2.0f * (float)this.rimPatternScale, this.rimPatternScale}, 0.0f);
            }
            case 3: {
                return new BasicStroke(this.rimWidth, 0, 0, 10.0f, new float[]{12.0f * (float)this.rimPatternScale, 6.0f * (float)this.rimPatternScale}, 0.0f);
            }
        }
        Debug.impossible();
        return null;
    }
}

