/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.draw;

import java.awt.Shape;
import net.astah.golf.draw.GGraphics;
import net.astah.golf.draw.GRimmedGeometry;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.geom2D.Rectangle2d;

public class GRect
extends GRimmedGeometry {
    Rectangle2d rectangle2d;
    private Pnt2d[] knobPoints;

    public GRect() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public GRect(Rectangle2d rectangle2d) {
        this(rectangle2d.x, rectangle2d.y, rectangle2d.width, rectangle2d.height);
    }

    public GRect(double d2, double d3, double d4, double d5) {
        super.setPoint(d2, d3);
        this.rectangle2d = new Rectangle2d(d2, d3, d4, d5);
    }

    @Override
    public void setPoint(double d2, double d3) {
        super.setPoint(d2, d3);
        this.rectangle2d.setRect(d2, d3, this.getWidth(), this.getHeight());
    }

    public void setRect(Rectangle2d rectangle2d) {
        this.setRect(rectangle2d.x, rectangle2d.y, rectangle2d.width, rectangle2d.height);
    }

    public void setRect(double d2, double d3, double d4, double d5) {
        this.rectangle2d.setRect(d2, d3, d4, d5);
        super.setPoint(d2, d3);
    }

    public void setWidth(double d2) {
        this.rectangle2d.width = d2;
        this.moveKnobAndShadow();
    }

    public void setHeight(double d2) {
        this.rectangle2d.height = d2;
        this.moveKnobAndShadow();
    }

    public double getWidth() {
        return this.rectangle2d.width;
    }

    public double getHeight() {
        return this.rectangle2d.height;
    }

    @Override
    public int getNoShapes() {
        return 1;
    }

    @Override
    public Shape getShape(int n) {
        return this.rectangle2d;
    }

    @Override
    public Pnt2d[] getKnobPoints() {
        if (this.knobPoints == null) {
            this.knobPoints = new Pnt2d[4];
            this.knobPoints[0] = new Pnt2d();
            this.knobPoints[1] = new Pnt2d();
            this.knobPoints[2] = new Pnt2d();
            this.knobPoints[3] = new Pnt2d();
        }
        double d2 = this.getWidth();
        double d3 = this.getHeight();
        this.knobPoints[0].set(this.x, this.y);
        this.knobPoints[1].set(this.x, this.y + d3);
        this.knobPoints[2].set(this.x + d2, this.y + d3);
        this.knobPoints[3].set(this.x + d2, this.y);
        return this.knobPoints;
    }

    @Override
    public int getDiagonalLength(GGraphics gGraphics) {
        double d2 = this.getWidth();
        double d3 = this.getHeight();
        return (int)Math.round(Math.sqrt(d2 * d2 + d3 * d3) * gGraphics.camera.scale);
    }

    @Override
    public GRimmedGeometry getShadow() {
        GRect gRect = new GRect(this.x, this.y, this.getWidth(), this.getHeight());
        gRect.setRimWidth(this.rimWidth);
        return gRect;
    }

    @Override
    public boolean intersect(Rectangle2d rectangle2d) {
        boolean bl = this.isRimmedPick();
        if (bl) {
            double d2 = this.getX();
            double d3 = this.getY();
            double d4 = this.getX() + this.getWidth();
            double d5 = this.getY() + this.getHeight();
            if (rectangle2d.intersectsLine(d2, d3, d2, d5)) {
                return true;
            }
            if (rectangle2d.intersectsLine(d2, d5, d4, d5)) {
                return true;
            }
            if (rectangle2d.intersectsLine(d4, d3, d4, d5)) {
                return true;
            }
            return rectangle2d.intersectsLine(d2, d3, d4, d3);
        }
        Rectangle2d rectangle2d2 = new Rectangle2d(this.x, this.y, this.getWidth(), this.getHeight());
        return rectangle2d.intersects(rectangle2d2);
    }
}

