/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.draw;

import java.awt.Shape;
import java.awt.geom.Point2D;
import net.astah.golf.draw.GGraphics;
import net.astah.golf.draw.GRimmedGeometry;
import net.astah.golf.geom2D.Line2d;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.geom2D.Rectangle2d;

public class GPolyline
extends GRimmedGeometry {
    static boolean isLineShowShadow = false;
    private boolean isShowShadowWhenUnselect = true;
    Pnt2d[] points;
    Line2d[] line2ds;

    public GPolyline() {
        this.boundingBox = new Rectangle2d();
        Pnt2d[] pnt2dArray = new Pnt2d[]{new Pnt2d()};
        this.setPnts(pnt2dArray);
    }

    public GPolyline(Pnt2d[] pnt2dArray) {
        this.boundingBox = new Rectangle2d();
        this.setPnts(pnt2dArray);
    }

    public void setPoints(Pnt2d[] pnt2dArray) {
        this.setPnts(pnt2dArray);
        this.moveKnobAndShadow();
    }

    void setPnts(Pnt2d[] pnt2dArray) {
        this.boundingBoxShouldBeUpdated = true;
        this.points = pnt2dArray;
        this.line2ds = new Line2d[pnt2dArray.length - 1];
        for (int k = 0; k < pnt2dArray.length - 1; ++k) {
            this.line2ds[k] = new Line2d(pnt2dArray[k], pnt2dArray[k + 1]);
        }
    }

    public Pnt2d[] getPoints() {
        return this.points;
    }

    @Override
    public int getNoShapes() {
        return this.line2ds.length;
    }

    @Override
    public Shape getShape(int n) {
        return this.line2ds[n];
    }

    @Override
    public Pnt2d[] getKnobPoints() {
        return this.points;
    }

    @Override
    public int getDiagonalLength(GGraphics gGraphics) {
        return (int)Math.round(Point2D.distance(this.getMinX(), this.getMinY(), this.getMaxX(), this.getMaxY()) * gGraphics.camera.scale);
    }

    double getMinX() {
        double d2 = this.points[0].x;
        for (int k = 1; k < this.points.length; ++k) {
            if (!(this.points[k].x < d2)) continue;
            d2 = this.points[k].x;
        }
        return d2;
    }

    double getMinY() {
        double d2 = this.points[0].y;
        for (int k = 1; k < this.points.length; ++k) {
            if (!(this.points[k].y < d2)) continue;
            d2 = this.points[k].y;
        }
        return d2;
    }

    double getMaxX() {
        double d2 = this.points[0].x;
        for (int k = 1; k < this.points.length; ++k) {
            if (!(this.points[k].x > d2)) continue;
            d2 = this.points[k].x;
        }
        return d2;
    }

    double getMaxY() {
        double d2 = this.points[0].y;
        for (int k = 1; k < this.points.length; ++k) {
            if (!(this.points[k].y > d2)) continue;
            d2 = this.points[k].y;
        }
        return d2;
    }

    @Override
    public GRimmedGeometry getShadow() {
        GPolyline gPolyline = new GPolyline(this.points);
        gPolyline.setRimWidth(this.rimWidth);
        return gPolyline;
    }

    public Rectangle2d getBounds2d() {
        if (!this.boundingBoxShouldBeUpdated) {
            return this.boundingBox;
        }
        this.boundingBox.setRect(0.0, 0.0, 0.0, 0.0);
        if (this.points[0] != null) {
            Pnt2d pnt2d = this.points[0];
            this.boundingBox.setRect(pnt2d.x, pnt2d.y, 1.0, 1.0);
        }
        for (int k = 1; k < this.points.length; ++k) {
            this.boundingBox.add(this.points[k]);
        }
        this.boundingBoxShouldBeUpdated = false;
        return this.boundingBox;
    }

    @Override
    public boolean intersect(Rectangle2d rectangle2d) {
        if (rectangle2d.isEmpty() || this.points == null) {
            return true;
        }
        for (int k = 0; k < this.line2ds.length; ++k) {
            Line2d line2d = this.line2ds[k];
            if (!rectangle2d.intersectsLine(line2d)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isShowShadow() {
        return super.isShowShadow() && (isLineShowShadow || this.isShowShadowWhenUnselect);
    }

    public static void setLineShowShadow(boolean bl) {
        isLineShowShadow = bl;
    }

    public void setShowShadowWhenUnselect(boolean bl) {
        this.isShowShadowWhenUnselect = bl;
    }
}

