/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.draw;

import java.awt.Shape;
import net.astah.golf.draw.GGraphics;
import net.astah.golf.draw.GRimmedGeometry;
import net.astah.golf.geom2D.Ellipse2d;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.geom2D.Rectangle2d;

public class GOval
extends GRimmedGeometry {
    Ellipse2d ellipse2d = new Ellipse2d();
    private Pnt2d[] knobPoints;

    public GOval() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public GOval(double d2, double d3, double d4, double d5) {
        super.setPoint(d2, d3);
        this.ellipse2d = new Ellipse2d(d2, d3, d4, d5);
    }

    @Override
    public void setPoint(double d2, double d3) {
        super.setPoint(d2, d3);
        this.ellipse2d.setFrame(d2, d3, this.getWidth(), this.getHeight());
    }

    public void setWidth(double d2) {
        this.ellipse2d.width = d2;
        this.moveKnobAndShadow();
    }

    public void setHeight(double d2) {
        this.ellipse2d.height = d2;
        this.moveKnobAndShadow();
    }

    public double getWidth() {
        return this.ellipse2d.width;
    }

    public double getHeight() {
        return this.ellipse2d.height;
    }

    @Override
    public int getNoShapes() {
        return 1;
    }

    @Override
    public Shape getShape(int n) {
        return this.ellipse2d;
    }

    @Override
    public Pnt2d[] getKnobPoints() {
        if (this.knobPoints == null) {
            this.knobPoints = new Pnt2d[4];
            this.knobPoints[0] = new Pnt2d();
            this.knobPoints[1] = new Pnt2d();
            this.knobPoints[2] = new Pnt2d();
            this.knobPoints[3] = new Pnt2d();
        }
        double d2 = this.getWidth();
        double d3 = this.getHeight();
        this.knobPoints[0].set(this.x, this.y);
        this.knobPoints[1].set(this.x, this.y + d3);
        this.knobPoints[2].set(this.x + d2, this.y + d3);
        this.knobPoints[3].set(this.x + d2, this.y);
        return this.knobPoints;
    }

    @Override
    public int getDiagonalLength(GGraphics gGraphics) {
        double d2 = this.getWidth();
        double d3 = this.getHeight();
        return (int)Math.round(Math.sqrt(d2 * d2 + d3 * d3) * gGraphics.camera.scale);
    }

    @Override
    public GRimmedGeometry getShadow() {
        GOval gOval = new GOval(this.x, this.y, this.getWidth(), this.getHeight());
        gOval.setRimWidth(this.rimWidth);
        return gOval;
    }

    @Override
    public boolean intersect(Rectangle2d rectangle2d) {
        return this.isRimmedPick() ? this.ellipse2d.intersects(rectangle2d) && !this.ellipse2d.contains(rectangle2d.x, rectangle2d.y, rectangle2d.width, rectangle2d.height) : this.ellipse2d.intersects(rectangle2d);
    }
}

