/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.draw;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.astah.golf.draw.GDepthEvent;
import net.astah.golf.draw.GDepthListener;
import net.astah.golf.draw.GGraphics;
import net.astah.golf.draw.GKnob;
import net.astah.golf.draw.GNodeSelectionEvent;
import net.astah.golf.draw.GNodeSelectionListener;
import net.astah.golf.draw.GTransform;
import net.astah.golf.draw.GTranslate;
import net.astah.golf.geom2D.Rectangle2d;
import net.astah.golf.widget.CGraphics2D;

public class GNode
implements GDepthListener,
GNodeSelectionListener {
    public static final byte NONE = 0;
    public static final byte KNOB = 1;
    public static final byte SHADOW = 2;
    public static final byte REVERSE = 4;
    public static final int MOVE = 8;
    byte selectionType = 0;
    boolean visible = true;
    protected boolean pickable = true;
    boolean selectable = true;
    protected List<GNode> nodeList = new ArrayList<GNode>(0);
    protected List<GNodeSelectionListener> nodeSelectionListenerList = new ArrayList<GNodeSelectionListener>(0);
    GNode parent = null;
    protected List<GTransform> transformList = new ArrayList<GTransform>(0);
    boolean selected = false;
    int type = 0;
    Object model = null;
    int level = -1;
    int depth = 0;
    boolean enableCopyPaste = true;
    List<GDepthListener> depthListenerList = new ArrayList<GDepthListener>(0);
    GTranslate selectionTranslate;
    static double shadowPointX = 5.0;
    static double shadowPointY = 5.0;
    private List<GNode> selectedNodeList;
    private List<GNode> pickedNodeListA;
    private List<GNode> pickedNodeListB;
    protected boolean wasDrawn = false;
    public static boolean pickHiddenNode = false;
    private static GDepthEvent tmpDepthEvent = new GDepthEvent();
    List<GNode> tempNodeList = new ArrayList<GNode>(0);

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setPickable(boolean bl) {
        this.pickable = bl;
    }

    public boolean isPickable() {
        return this.pickable;
    }

    public void setSelectable(boolean bl) {
        this.selectable = bl;
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public void setSelected(boolean bl) {
        if (this.selected != bl && (!bl || this.selectable)) {
            if (this.nodeSelectionListenerList.size() > 0) {
                this.fireSelectionChange(new GNodeSelectionEvent(this, bl));
            }
            this.selected = bl;
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setLevel(int n) {
        this.level = n;
    }

    public int getLevel() {
        return this.level;
    }

    public void setType(int n) {
        this.type = n;
    }

    public int getType() {
        return this.type;
    }

    public void setSelectionType(byte by) {
        this.selectionType = by;
    }

    public byte getSelectionType() {
        return this.selectionType;
    }

    public void addTransform(GTransform gTransform) {
        this.transformList.add(0, gTransform);
    }

    public List<GTransform> getTransform() {
        return this.transformList;
    }

    public void removeTransform(GTransform gTransform) {
        this.transformList.remove(gTransform);
    }

    public void addChild(GNode gNode) {
        this.nodeList.add(GNode.getInsertPosition(this.nodeList, gNode.depth), gNode);
        gNode.setParent(this);
        gNode.addDepthListener(this);
    }

    public static int getInsertPosition(List<GNode> list, int n) {
        int n2 = list.size();
        int n3 = list.size();
        for (n2 = 0; n2 < n3 && list.get((int)n2).depth > n; ++n2) {
        }
        return n2;
    }

    public void removeChild(GNode gNode) {
        if (gNode.parent == this) {
            gNode.removeAllChildren();
            gNode.setParent(null);
            gNode.removeDepthListener(this);
            gNode.clearNodeSelectionListener();
            this.nodeList.remove(gNode);
            gNode.setModel(null);
        } else {
            this.nodeList.remove(gNode);
        }
    }

    public void removeAllChildren() {
        while (this.nodeList.size() > 0) {
            this.removeChild(this.nodeList.get(0));
        }
    }

    void setParent(GNode gNode) {
        this.parent = gNode;
    }

    public GNode getParent() {
        return this.parent;
    }

    public void setModel(Object object) {
        this.model = object;
    }

    public Object getModel() {
        return this.model;
    }

    public void draw(GGraphics gGraphics) {
        this.wasDrawn = false;
        if (this.visible && (!gGraphics.isEnableViewport() || gGraphics.isEnableViewport() && this.intersect(gGraphics.getViewport()))) {
            CGraphics2D cGraphics2D = gGraphics.getGraphics2D();
            GTransform gTransform = null;
            int n = this.transformList.size();
            if (n > 0) {
                gTransform = this.transformList.get(0);
                gTransform.saveTransform(cGraphics2D);
                for (int k = 0; k < n; ++k) {
                    this.transformList.get(k).transform(cGraphics2D);
                }
            }
            this.drawNode(gGraphics, cGraphics2D, gTransform);
        }
    }

    public void drawNode(GGraphics gGraphics, CGraphics2D cGraphics2D, GTransform gTransform) {
        for (int k = 0; k < this.nodeList.size(); ++k) {
            GNode gNode = this.nodeList.get(k);
            if (!gNode.visible || gGraphics.isEnableViewport() && (!gGraphics.isEnableViewport() || !gNode.intersect(gGraphics.getViewport()))) continue;
            gNode.draw(gGraphics);
            this.wasDrawn = true;
        }
        if (gTransform != null) {
            gTransform.loadTransform(cGraphics2D);
        }
    }

    public void draw(GGraphics gGraphics, int n) {
        if (this.visible) {
            if (this.and(n)) {
                this.draw(gGraphics);
            } else {
                this.drawNode(gGraphics, n);
            }
        }
    }

    public void drawNode(GGraphics gGraphics, int n) {
        int n2;
        CGraphics2D cGraphics2D = gGraphics.getGraphics2D();
        GTransform gTransform = null;
        int n3 = this.transformList.size();
        if (n3 > 0) {
            gTransform = this.transformList.get(0);
            gTransform.saveTransform(cGraphics2D);
            for (n2 = 0; n2 < n3; ++n2) {
                this.transformList.get(n2).transform(cGraphics2D);
            }
        }
        n3 = this.nodeList.size();
        for (n2 = 0; n2 < n3; ++n2) {
            GNode gNode = this.nodeList.get(n2);
            if (!gNode.visible) continue;
            gNode.draw(gGraphics, n);
        }
        if (gTransform != null) {
            gTransform.loadTransform(cGraphics2D);
        }
    }

    public List<GNode> getPickedNodesWithLevel(CGraphics2D cGraphics2D, Rectangle rectangle, int n) {
        if (this.pickable && this.shouldPick()) {
            if (this.pickedNodeListA == null) {
                this.pickedNodeListA = new ArrayList<GNode>();
            } else {
                this.pickedNodeListA.clear();
            }
            if (this.level == n) {
                if (this.isPicked(cGraphics2D, rectangle)) {
                    this.pickedNodeListA.add(this);
                    return this.pickedNodeListA;
                }
            } else {
                int n2;
                GTransform gTransform = null;
                int n3 = this.transformList.size();
                if (n3 > 0) {
                    gTransform = this.transformList.get(0);
                    gTransform.saveTransform(cGraphics2D);
                    for (n2 = 0; n2 < n3; ++n2) {
                        this.transformList.get(n2).transform(cGraphics2D);
                    }
                }
                n3 = this.nodeList.size();
                for (n2 = 0; n2 < n3; ++n2) {
                    List<GNode> list;
                    GNode gNode = this.nodeList.get(n2);
                    if (!gNode.pickable || !gNode.shouldPick() || (list = gNode.getPickedNodesWithLevel(cGraphics2D, rectangle, n)) == null || list.isEmpty()) continue;
                    this.pickedNodeListA.addAll(list);
                }
                if (gTransform != null) {
                    gTransform.loadTransform(cGraphics2D);
                }
                return this.pickedNodeListA;
            }
        }
        return null;
    }

    public List<GNode> getPickedNodes(CGraphics2D cGraphics2D, Rectangle rectangle, int n) {
        if (this.pickable && this.shouldPick()) {
            if (this.pickedNodeListB == null) {
                this.pickedNodeListB = new ArrayList<GNode>();
            } else {
                this.pickedNodeListB.clear();
            }
            if (this.and(n)) {
                if (this.isPicked(cGraphics2D, rectangle)) {
                    this.pickedNodeListB.add(this);
                    return this.pickedNodeListB;
                }
            } else {
                int n2;
                GTransform gTransform = null;
                int n3 = this.transformList.size();
                if (n3 > 0) {
                    gTransform = this.transformList.get(0);
                    gTransform.saveTransform(cGraphics2D);
                    for (n2 = 0; n2 < n3; ++n2) {
                        this.transformList.get(n2).transform(cGraphics2D);
                    }
                }
                n3 = this.nodeList.size();
                for (n2 = 0; n2 < n3; ++n2) {
                    List<GNode> list;
                    GNode gNode = this.nodeList.get(n2);
                    if (!gNode.pickable || !gNode.shouldPick() || (list = gNode.getPickedNodes(cGraphics2D, rectangle, n)) == null || list.isEmpty()) continue;
                    this.pickedNodeListB.addAll(list);
                }
                if (gTransform != null) {
                    gTransform.loadTransform(cGraphics2D);
                }
                return this.pickedNodeListB;
            }
        }
        return null;
    }

    public boolean and(int n) {
        int n2;
        return this.type != 0 && (n2 = n & this.type) != 0;
    }

    protected boolean shouldPick() {
        return this.wasDrawn || pickHiddenNode;
    }

    public boolean isPicked(CGraphics2D cGraphics2D, Rectangle rectangle) {
        if (this.pickable) {
            int n;
            GTransform gTransform = null;
            int n2 = this.transformList.size();
            if (n2 > 0) {
                gTransform = this.transformList.get(0);
                gTransform.saveTransform(cGraphics2D);
                for (n = 0; n < n2; ++n) {
                    this.transformList.get(n).transform(cGraphics2D);
                }
            }
            n2 = this.nodeList.size();
            for (n = 0; n < n2; ++n) {
                GNode gNode = this.nodeList.get(n);
                if (!gNode.pickable || !gNode.isPicked(cGraphics2D, rectangle)) continue;
                if (gTransform != null) {
                    gTransform.loadTransform(cGraphics2D);
                }
                return true;
            }
            if (gTransform != null) {
                gTransform.loadTransform(cGraphics2D);
            }
        }
        return false;
    }

    public List<GNode> getSelectedNodes() {
        if (this.selectedNodeList == null) {
            this.selectedNodeList = new ArrayList<GNode>();
        } else {
            this.selectedNodeList.clear();
        }
        if (this.selected) {
            this.selectedNodeList.add(this);
        }
        int n = this.nodeList.size();
        for (int k = 0; k < n; ++k) {
            List<GNode> list = this.nodeList.get(k).getSelectedNodes();
            if (list == null || list.isEmpty()) continue;
            this.selectedNodeList.addAll(list);
        }
        return this.selectedNodeList;
    }

    public List<GNode> getAllNodes() {
        ArrayList<GNode> arrayList = new ArrayList<GNode>();
        arrayList.addAll(this.nodeList);
        for (int k = 0; k < this.nodeList.size(); ++k) {
            List<GNode> list = this.nodeList.get(k).getAllNodes();
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public List<GNode> getSelectedNodes(int n) {
        if (this.selectedNodeList == null) {
            this.selectedNodeList = new ArrayList<GNode>();
        } else {
            this.selectedNodeList.clear();
        }
        if (this.selected && this.and(n)) {
            this.selectedNodeList.add(this);
        }
        int n2 = this.nodeList.size();
        for (int k = 0; k < n2; ++k) {
            List<GNode> list = this.nodeList.get(k).getSelectedNodes(n);
            if (list == null || list.isEmpty()) continue;
            this.selectedNodeList.addAll(list);
        }
        return this.selectedNodeList;
    }

    public void addNodeSelectionListener(GNodeSelectionListener gNodeSelectionListener) {
        if (!this.nodeSelectionListenerList.contains(gNodeSelectionListener)) {
            this.nodeSelectionListenerList.add(gNodeSelectionListener);
        }
    }

    public void removeNodeSelectionListener(GNodeSelectionListener gNodeSelectionListener) {
        this.nodeSelectionListenerList.remove(gNodeSelectionListener);
    }

    public void clearNodeSelectionListener() {
        this.nodeSelectionListenerList.clear();
    }

    void fireSelectionChange(GNodeSelectionEvent gNodeSelectionEvent) {
        int n = this.nodeSelectionListenerList.size();
        for (int k = 0; k < n; ++k) {
            this.nodeSelectionListenerList.get(k).selectionChange(gNodeSelectionEvent);
        }
    }

    @Override
    public void selectionChange(GNodeSelectionEvent gNodeSelectionEvent) {
        this.selectionChange(gNodeSelectionEvent.selected);
    }

    public void selectionChange(boolean bl) {
        if (bl) {
            if ((this.selectionType & 8) != 0) {
                this.selectionTranslate = new GTranslate(-shadowPointX, -shadowPointY);
                this.addTransform(this.selectionTranslate);
            }
        } else {
            this.removeTransform(this.selectionTranslate);
        }
    }

    public void repaintComponent() {
        if (this.visible) {
            int n = this.nodeList.size();
            for (int k = 0; k < n; ++k) {
                GNode gNode = this.nodeList.get(k);
                if (!gNode.visible) continue;
                gNode.repaintComponent();
            }
        }
    }

    public void setDepth(int n) {
        if (this.depth != n) {
            this.depth = n;
            if (this.depthListenerList.size() > 0) {
                tmpDepthEvent.setSource(this);
                this.fireDepthChange(tmpDepthEvent);
                tmpDepthEvent.setSource(null);
            }
        }
    }

    public int getDepth() {
        return this.depth;
    }

    public void addDepthListener(GDepthListener gDepthListener) {
        this.depthListenerList.add(gDepthListener);
    }

    public void removeDepthListener(GDepthListener gDepthListener) {
        this.depthListenerList.remove(gDepthListener);
    }

    void fireDepthChange(GDepthEvent gDepthEvent) {
        int n = this.depthListenerList.size();
        for (int k = 0; k < n; ++k) {
            this.depthListenerList.get(k).depthChange(gDepthEvent);
        }
    }

    @Override
    public void depthChange(GDepthEvent gDepthEvent) {
        GNode.depthChange(this.nodeList, gDepthEvent);
    }

    public static void depthChange(List<GNode> list, GDepthEvent gDepthEvent) {
        GNode gNode = (GNode)gDepthEvent.getSource();
        list.remove(gNode);
        list.add(GNode.getInsertPosition(list, gNode.depth), gNode);
    }

    public static void setShadowPoint(double d2, double d3) {
        shadowPointX = d2;
        shadowPointY = d3;
    }

    public static double getShadowPointX() {
        return shadowPointX;
    }

    public static double getShadowPointY() {
        return shadowPointY;
    }

    public void addNode(GNode gNode) {
        this.addChild(gNode);
    }

    public void addNode(GNode gNode, boolean bl) {
        this.addChild(gNode);
    }

    public void addNodes(GNode[] gNodeArray) {
        for (int k = 0; k < gNodeArray.length; ++k) {
            this.addNode(gNodeArray[k]);
        }
    }

    public void removeNode(GNode gNode) {
        if (gNode.parent == this) {
            gNode.setParent(null);
            gNode.removeDepthListener(this);
            gNode.clearNodeSelectionListener();
            this.nodeList.remove(gNode);
        } else {
            this.nodeList.remove(gNode);
        }
    }

    public void removeNodes(GNode[] gNodeArray) {
        for (int k = 0; k < gNodeArray.length; ++k) {
            this.removeNode(gNodeArray[k]);
        }
    }

    public List<GNode> getChildren() {
        return this.nodeList;
    }

    public void addTempNode(GNode gNode) {
        gNode.setParent(this);
        this.tempNodeList.add(gNode);
    }

    public void removeTempNode(GNode gNode) {
        if (gNode.parent == this) {
            gNode.setParent(null);
        }
        this.tempNodeList.remove(gNode);
    }

    public void removeAllTempNodes() {
        while (this.tempNodeList.size() > 0) {
            this.removeTempNode(this.tempNodeList.get(0));
        }
    }

    public void drawTemp(GGraphics gGraphics) {
        if (this.visible) {
            int n;
            CGraphics2D cGraphics2D = gGraphics.getGraphics2D();
            GTransform gTransform = null;
            int n2 = this.transformList.size();
            if (n2 > 0) {
                gTransform = this.transformList.get(0);
                gTransform.saveTransform(cGraphics2D);
                for (n = 0; n < n2; ++n) {
                    this.transformList.get(n).transform(cGraphics2D);
                }
            }
            n2 = this.tempNodeList.size();
            for (n = 0; n < n2; ++n) {
                GNode gNode = this.tempNodeList.get(n);
                if (!gNode.visible) continue;
                gNode.draw(gGraphics);
            }
            if (gTransform != null) {
                gTransform.loadTransform(cGraphics2D);
            }
        }
    }

    public static void setKnobType(int n) {
        GKnob.setKnobType(n);
    }

    public boolean intersect(Rectangle2d rectangle2d) {
        return true;
    }

    protected List<Object[]> getTextLayouts(CGraphics2D cGraphics2D) {
        return null;
    }

    public void setEnableCopyPaste(boolean bl) {
        this.enableCopyPaste = bl;
    }

    public boolean isEnableCopyPaste() {
        return this.enableCopyPaste;
    }

    public boolean isTempNode() {
        for (GNode gNode : this.parent.tempNodeList) {
            if (gNode != this) continue;
            return true;
        }
        return false;
    }

    public List<GNodeSelectionListener> getNodeSelectionListenerList() {
        return this.nodeSelectionListenerList;
    }
}

