/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.draw;

import net.astah.golf.draw.GGeometry;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.geom2D.Rectangle2d;
import net.astah.golf.geom2D.Vec2d;
import net.astah.golf.util.Debug;

public class GKnobs {
    public static Pnt2d sizeOf(GGeometry gGeometry, Rectangle2d rectangle2d, int n, Vec2d vec2d) {
        return GKnobs.getSizeOfInterim(rectangle2d, gGeometry, n, vec2d);
    }

    public static Rectangle2d resize(GGeometry gGeometry, Rectangle2d rectangle2d, int n, Pnt2d pnt2d) {
        Pnt2d pnt2d2 = GKnobs.getEndPoint(rectangle2d, n, pnt2d);
        return GKnobs.getTempRect(gGeometry, n, pnt2d2.x, pnt2d2.y);
    }

    static Rectangle2d getTempRect(GGeometry gGeometry, int n, double d2, double d3) {
        Pnt2d[] pnt2dArray = gGeometry.getKnobPoints();
        Pnt2d pnt2d = pnt2dArray[(n + 2) % 4];
        switch (n) {
            case 0: {
                return GKnobs.getRectForCase0(pnt2d, d2, d3);
            }
            case 3: {
                return GKnobs.getRectForCase3(pnt2d, d2, d3);
            }
            case 2: {
                return GKnobs.getRectForCase2(pnt2d, d2, d3);
            }
            case 1: {
                return GKnobs.getRectForCase1(pnt2d, d2, d3);
            }
        }
        Debug.impossible();
        return null;
    }

    static Rectangle2d getRectForCase0(Pnt2d pnt2d, double d2, double d3) {
        double d4 = d2;
        double d5 = d3;
        double d6 = pnt2d.x - d2;
        double d7 = pnt2d.y - d3;
        return new Rectangle2d(d4, d5, d6, d7);
    }

    static Rectangle2d getRectForCase1(Pnt2d pnt2d, double d2, double d3) {
        double d4 = d2;
        double d5 = d3;
        double d6 = pnt2d.x - d2;
        double d7 = pnt2d.y - d3;
        d4 = d2;
        d5 = pnt2d.y;
        d6 = pnt2d.x - d2;
        d7 = d3 - pnt2d.y;
        return new Rectangle2d(d4, d5, d6, d7);
    }

    static Rectangle2d getRectForCase2(Pnt2d pnt2d, double d2, double d3) {
        double d4 = d2;
        double d5 = d3;
        double d6 = pnt2d.x - d2;
        double d7 = pnt2d.y - d3;
        d4 = pnt2d.x;
        d5 = pnt2d.y;
        d6 = d2 - pnt2d.x;
        d7 = d3 - pnt2d.y;
        return new Rectangle2d(d4, d5, d6, d7);
    }

    static Rectangle2d getRectForCase3(Pnt2d pnt2d, double d2, double d3) {
        double d4 = d2;
        double d5 = d3;
        double d6 = pnt2d.x - d2;
        double d7 = pnt2d.y - d3;
        d4 = pnt2d.x;
        d5 = d3;
        d6 = d2 - pnt2d.x;
        d7 = pnt2d.y - d3;
        return new Rectangle2d(d4, d5, d6, d7);
    }

    static Pnt2d getEndPoint(Rectangle2d rectangle2d, int n, Pnt2d pnt2d) {
        double d2 = pnt2d.getX();
        double d3 = pnt2d.getY();
        switch (n) {
            case 0: {
                d2 = rectangle2d.getWidth() - pnt2d.getX();
                d3 = rectangle2d.getHeight() - pnt2d.getY();
                break;
            }
            case 1: {
                d2 = rectangle2d.getWidth() - pnt2d.getX();
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                d3 = rectangle2d.getHeight() - pnt2d.getY();
                break;
            }
            default: {
                throw new IllegalArgumentException("draggedNobIndex is illegal value.");
            }
        }
        pnt2d.set(rectangle2d.getMinX() + d2, rectangle2d.getMinY() + d3);
        return pnt2d;
    }

    static Pnt2d getSizeOfInterim(Rectangle2d rectangle2d, GGeometry gGeometry, int n, Vec2d vec2d) {
        Pnt2d pnt2d = gGeometry.getKnobPoints()[n];
        Pnt2d pnt2d2 = new Pnt2d(pnt2d.x + vec2d.x, pnt2d.y + vec2d.y);
        double d2 = pnt2d2.getX() - pnt2d.getX();
        double d3 = pnt2d2.getY() - pnt2d.getY();
        switch (n) {
            case 0: {
                d2 = -pnt2d2.getX() + pnt2d.getX();
                d3 = -pnt2d2.getY() + pnt2d.getY();
                break;
            }
            case 1: {
                d2 = -pnt2d2.getX() + pnt2d.getX();
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                d3 = -pnt2d2.getY() + pnt2d.getY();
                break;
            }
            default: {
                throw new IllegalArgumentException("draggedNobIndex is illegal value. " + n);
            }
        }
        return new Pnt2d(rectangle2d.getWidth() + d2, rectangle2d.getHeight() + d3);
    }
}

