/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.draw;

import net.astah.golf.draw.GGeometry;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.widget.CColor;
import net.astah.golf.widget.CGraphics2D;
import net.astah.golf.widget.CImage;
import net.astah.golf.widget.CImageIcon;

public class GImage
extends GGeometry {
    private CImageIcon image;
    private Pnt2d[] knobPoints;
    private double width = 0.0;
    private double height = 0.0;

    public GImage(CImageIcon cImageIcon) {
        this.image = cImageIcon;
        this.width = cImageIcon.getWidth(null);
        this.height = cImageIcon.getHeight(null);
    }

    @Override
    public void setPoint(double d2, double d3) {
        super.setPoint(d2, d3);
    }

    public void setWidth(double d2) {
        this.width = d2;
        this.moveKnobAndShadow();
    }

    public void setHeight(double d2) {
        this.height = d2;
        this.moveKnobAndShadow();
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    @Override
    public int getNoShapes() {
        return 0;
    }

    @Override
    public int getNoImage() {
        return 1;
    }

    @Override
    public CImageIcon getImage(int n) {
        return this.image;
    }

    @Override
    public Pnt2d[] getKnobPoints() {
        if (this.knobPoints == null) {
            this.knobPoints = new Pnt2d[4];
            this.knobPoints[0] = new Pnt2d();
            this.knobPoints[1] = new Pnt2d();
            this.knobPoints[2] = new Pnt2d();
            this.knobPoints[3] = new Pnt2d();
        }
        double d2 = this.getWidth();
        double d3 = this.getHeight();
        this.knobPoints[0].set(this.x, this.y);
        this.knobPoints[1].set(this.x, this.y + d3);
        this.knobPoints[2].set(this.x + d2, this.y + d3);
        this.knobPoints[3].set(this.x + d2, this.y);
        return this.knobPoints;
    }

    @Override
    void draw(CGraphics2D cGraphics2D, CColor cColor, CColor cColor2) {
        int n = this.getNoImage();
        for (int k = 0; k < n; ++k) {
            CImage cImage = this.getImage(k).getImage();
            int n2 = (int)Math.round(this.getX());
            int n3 = (int)Math.round(this.getY());
            int n4 = (int)Math.round(this.getWidth());
            int n5 = (int)Math.round(this.getHeight());
            cGraphics2D.drawImage(cImage, n2, n3, n4, n5, null);
        }
    }

    public void setImage(CImageIcon cImageIcon) {
        this.image = cImageIcon;
    }

    public String toString() {
        return "GImage";
    }
}

