/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.draw;

import net.astah.golf.control.GolfAction;
import net.astah.golf.draw.GGraphics;
import net.astah.golf.draw.GImage;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.geom2D.Rectangle2d;
import net.astah.golf.widget.CImageIcon;

public class GIconButton
extends GImage {
    public static final int RELATION_MODE = 0;
    public static final int POPUP_MODE = 1;
    private GolfAction action;
    private int clickCount;
    private int type;
    private boolean callMode = false;

    public GIconButton(CImageIcon cImageIcon, String string, int n) {
        super(cImageIcon);
        this.action = new GolfAction(string);
        this.clickCount = n;
    }

    @Override
    public boolean intersect(Rectangle2d rectangle2d) {
        Rectangle2d rectangle2d2 = new Rectangle2d(this.x, this.y, this.getWidth(), this.getHeight());
        return rectangle2d.intersects(rectangle2d2);
    }

    @Override
    public int getNoShapes() {
        return 1;
    }

    public int getClickCount() {
        return this.clickCount;
    }

    public void setClickCount(int n) {
        this.clickCount = n;
    }

    public GolfAction getAction() {
        return this.action;
    }

    public void setAction(GolfAction golfAction) {
        this.action = golfAction;
    }

    public boolean contains(double d2, double d3) {
        Rectangle2d rectangle2d = new Rectangle2d(this.x, this.y, this.getWidth(), this.getHeight());
        return rectangle2d.contains(d2, d3);
    }

    public void setModeType(int n) {
        this.type = n;
    }

    public int getModeType() {
        return this.type;
    }

    @Override
    public void draw(GGraphics gGraphics) {
        if (gGraphics.printing) {
            return;
        }
        super.draw(gGraphics);
    }

    public boolean isCallMode() {
        return this.callMode;
    }

    public void setCallMode(boolean bl) {
        this.callMode = bl;
    }

    public double getDistance(double d2, double d3) {
        Pnt2d pnt2d = new Pnt2d(this.x + this.getWidth() / 2.0, this.y + this.getHeight() / 2.0);
        return pnt2d.distance(d2, d3);
    }

    public Pnt2d getCenterPnt() {
        return new Pnt2d(this.x + this.getWidth() / 2.0, this.y + this.getHeight() / 2.0);
    }
}

