/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.draw;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import net.astah.golf.draw.GGraphics;
import net.astah.golf.draw.GKnob;
import net.astah.golf.draw.GNode;
import net.astah.golf.draw.GRimmedGeometry;
import net.astah.golf.draw.GRoundKnob;
import net.astah.golf.draw.GText;
import net.astah.golf.draw.GTransform;
import net.astah.golf.draw.GTranslate;
import net.astah.golf.draw.RenderingHintsHelper;
import net.astah.golf.emf.EMFGraphics2D;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.geom2D.Rectangle2d;
import net.astah.golf.util.RuntimeGlobal;
import net.astah.golf.widget.CColor;
import net.astah.golf.widget.CGraphics;
import net.astah.golf.widget.CGraphics2D;
import net.astah.golf.widget.CImage;
import net.astah.golf.widget.CImageIcon;
import net.astah.golf.widget.GolfWidgetFactory;
import net.astah.golf.widget.swing.SwingGraphics2D;

public abstract class GGeometry
extends GNode {
    double x = 0.0;
    double y = 0.0;
    byte colorNo = 0;
    byte backgroundNo = 0;
    Color backgroundColor;
    Color foregroundColor;
    static byte gradationNo = 0;
    float intensity = 1.0f;
    float alpha = 1.0f;
    static byte knobColorNo = 0;
    static boolean fillKnob = false;
    static byte shadowColorNo = 0;
    static float shadowAlpha = 0.5f;
    boolean rimmedPick = false;
    public static boolean isIgnoreRimmedPick = false;
    private boolean useIgnoreRimmedPick = false;
    static boolean isShowShadow = false;
    protected Rectangle2d boundingBox = null;
    protected boolean boundingBoxShouldBeUpdated = true;
    public static final byte GRADATION_NONE = 0;
    public static final byte GRADATION_DIAGNOL = 1;
    public static final byte GRADATION_HORZIZONTAL = 2;
    public static final byte GRADATION_VERTICAL = 3;

    public void setPoint(Pnt2d pnt2d) {
        this.setPoint(pnt2d.x, pnt2d.y);
    }

    public void setPoint(double d2, double d3) {
        this.x = d2;
        this.y = d3;
        this.moveKnobAndShadow();
    }

    public void moveKnobAndShadow() {
        int n = this.nodeList.size();
        for (int k = 0; k < n; ++k) {
            if (((GNode)this.nodeList.get((int)k)).level != GKnob.knobLevel && ((GNode)this.nodeList.get((int)k)).level != GKnob.knobLevel - 2) continue;
            this.selectionChange(false);
            this.selectionChange(true);
            break;
        }
        this.removeShadowLevelNodes();
        if (this.isShowShadow() && (this.selectionType & 2) != 0) {
            this.shadowSelectionChange();
        }
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public void setColorNo(byte by) {
        this.colorNo = by;
    }

    public byte getColorNo() {
        return this.colorNo;
    }

    public void setBackgroundNo(byte by) {
        this.backgroundNo = by;
    }

    public byte getBackgroundNo() {
        return this.backgroundNo;
    }

    public static void setGradationNo(byte by) {
        gradationNo = by;
    }

    public static byte getGradationNo() {
        return gradationNo;
    }

    public void setKnobColorNo(byte by) {
        knobColorNo = by;
    }

    public int getKnobColorNo() {
        return knobColorNo;
    }

    public void setFillKnob(boolean bl) {
        fillKnob = bl;
    }

    public boolean getFillKnob() {
        return fillKnob;
    }

    public void setShadowColorNo(byte by) {
        shadowColorNo = by;
    }

    public byte getShadowColorNo() {
        return shadowColorNo;
    }

    public void setShadowAlpha(float f2) {
        shadowAlpha = f2;
    }

    public float getShadowAlpha() {
        return shadowAlpha;
    }

    public void setIntensity(float f2) {
        this.intensity = f2;
    }

    public float getIntensity() {
        return this.intensity;
    }

    public void setAlpha(float f2) {
        this.alpha = f2;
    }

    public float getAlpha() {
        return this.alpha;
    }

    @Override
    public void draw(GGraphics gGraphics) {
        int n;
        this.wasDrawn = false;
        if (gGraphics.printing && (this.level == GKnob.knobLevel || this.level == GKnob.knobLevel - 2) || !this.visible || gGraphics.colorMap == null) {
            return;
        }
        CGraphics2D cGraphics2D = gGraphics.getGraphics2D();
        GTransform gTransform = null;
        int n2 = this.transformList.size();
        if (n2 > 0) {
            gTransform = (GTransform)this.transformList.get(0);
            gTransform.saveTransform(cGraphics2D);
            for (n = 0; n < n2; ++n) {
                ((GTransform)this.transformList.get(n)).transform(cGraphics2D);
            }
        }
        n = GGeometry.getInsertPosition(this.nodeList, this.depth);
        this.drawChild(gGraphics, 0, n);
        CColor cColor = null;
        cColor = this.foregroundColor != null ? (this.alpha != 1.0f ? GolfWidgetFactory.instance().createColor(GolfWidgetFactory.instance().createCColor(this.foregroundColor), this.intensity, this.alpha) : GolfWidgetFactory.instance().createCColor(this.foregroundColor)) : GolfWidgetFactory.instance().createColor(gGraphics.colorMap[this.colorNo], this.intensity, this.alpha);
        CColor cColor2 = null;
        cColor2 = this.backgroundColor != null ? GolfWidgetFactory.instance().createColor(GolfWidgetFactory.instance().createCColor(this.backgroundColor), this.intensity, this.alpha) : GolfWidgetFactory.instance().createColor(gGraphics.colorMap[this.backgroundNo], this.intensity, this.alpha);
        if (gGraphics.xorMode) {
            cGraphics2D.setXORMode(gGraphics.gCanvas.getBackground());
        }
        if (this.alpha != 0.0f) {
            this.draw(cGraphics2D, cColor, cColor2);
        }
        this.wasDrawn = true;
        if (gGraphics.xorMode) {
            cGraphics2D.setPaintMode();
        }
        this.drawChild(gGraphics, n, this.nodeList.size());
        if (gTransform != null) {
            gTransform.loadTransform(cGraphics2D);
        }
    }

    private void drawChild(GGraphics gGraphics, int n, int n2) {
        for (int k = n; k < n2; ++k) {
            GNode gNode = (GNode)this.nodeList.get(k);
            if (!gNode.visible) continue;
            gNode.draw(gGraphics);
        }
    }

    private Color getGradationStartColor(Color color) {
        double d2 = 0.22;
        int n = 231;
        int n2 = color.getRed();
        int n3 = color.getGreen();
        int n4 = color.getBlue();
        int n5 = (int)(1.0 / (1.0 - d2));
        if (n2 > 0 && n2 < n5) {
            n2 = n5;
        }
        if (n3 > 0 && n3 < n5) {
            n3 = n5;
        }
        if (n4 > 0 && n4 < n5) {
            n4 = n5;
        }
        int n6 = (int)((double)n2 / d2);
        int n7 = (int)((double)n3 / d2);
        int n8 = (int)((double)n4 / d2);
        if (n6 < n) {
            n6 = n;
        }
        if (n7 < n) {
            n7 = n;
        }
        if (n8 < n) {
            n8 = n;
        }
        return new Color(Math.min(n6, 255), Math.min(n7, 255), Math.min(n8, 255));
    }

    void draw(CGraphics2D cGraphics2D, CColor cColor, CColor cColor2) {
        int n = this.getNoShapes();
        if (n > 0) {
            cGraphics2D.setStroke(this.getStroke());
            for (int k = 0; k < n; ++k) {
                Shape shape = this.getShape(k);
                Object object = cGraphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                if (shape instanceof Rectangle2D) {
                    if (RenderingHintsHelper.isRectAntiAliasing) {
                        cGraphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    } else {
                        cGraphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                    }
                } else if (shape instanceof GText) {
                    if (RenderingHintsHelper.isTextAntiAliasing) {
                        cGraphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    } else {
                        cGraphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                    }
                } else if (RenderingHintsHelper.isOtherAntiAliasing) {
                    cGraphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                } else {
                    cGraphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                }
                if (this.isFilled()) {
                    if (gradationNo == 0 || this.level == GKnob.knobLevel - 1 || this.level == GKnob.knobLevel - 2 || this.isTempNode()) {
                        cGraphics2D.setColor(cColor2);
                    } else {
                        float f2 = (float)shape.getBounds().getMinX();
                        float f3 = (float)shape.getBounds().getMinY();
                        float f4 = 0.0f;
                        float f5 = 0.0f;
                        Color color = cColor2.transferToAWTColor();
                        Color color2 = this.getGradationStartColor(color);
                        boolean bl = false;
                        if (gradationNo == 1) {
                            f4 = (float)shape.getBounds().getMaxX();
                            f5 = (float)shape.getBounds().getMaxY();
                        } else if (gradationNo == 2) {
                            f4 = (float)shape.getBounds().getMaxX();
                            f5 = (float)shape.getBounds().getMinY();
                        } else if (gradationNo == 3) {
                            f4 = (float)shape.getBounds().getMinX();
                            f5 = (float)shape.getBounds().getMaxY();
                        }
                        GradientPaint gradientPaint = new GradientPaint(f2, f3, color2, f4, f5, color, bl);
                        cGraphics2D.setPaint(gradientPaint);
                    }
                    cGraphics2D.fill(shape);
                }
                cGraphics2D.setColor(cColor);
                boolean bl = false;
                if ((this.level == GKnob.knobLevel - 1 || this.level == GKnob.knobLevel - 2) && cGraphics2D instanceof SwingGraphics2D && ((SwingGraphics2D)cGraphics2D).getGraphics2D() instanceof EMFGraphics2D) {
                    bl = true;
                    ((EMFGraphics2D)((SwingGraphics2D)cGraphics2D).getGraphics2D()).setShadow(true);
                }
                cGraphics2D.draw(shape);
                if (bl) {
                    ((EMFGraphics2D)((SwingGraphics2D)cGraphics2D).getGraphics2D()).setShadow(false);
                }
                cGraphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
            }
        }
    }

    public void setRimmedPick(boolean bl) {
        this.rimmedPick = bl;
    }

    public boolean isRimmedPick() {
        return this.rimmedPick && (!this.useIgnoreRimmedPick || !isIgnoreRimmedPick);
    }

    public void setUseIgnoreRimmedPick(boolean bl) {
        this.useIgnoreRimmedPick = bl;
    }

    @Override
    public boolean isPicked(CGraphics2D cGraphics2D, Rectangle rectangle) {
        if (this.pickable) {
            int n;
            GTransform gTransform = null;
            int n2 = this.transformList.size();
            if (n2 > 0) {
                gTransform = (GTransform)this.transformList.get(0);
                gTransform.saveTransform(cGraphics2D);
                for (n = 0; n < n2; ++n) {
                    ((GTransform)this.transformList.get(n)).transform(cGraphics2D);
                }
            }
            if (rectangle.width == 0) {
                rectangle = new Rectangle(rectangle.x, rectangle.y, 1, rectangle.height == 0 ? 1 : rectangle.height);
            } else if (rectangle.height == 0) {
                rectangle = new Rectangle(rectangle.x, rectangle.y, rectangle.width, 1);
            }
            n = this.getNoShapes();
            if (n > 0 && this.isSelected(rectangle)) {
                if (gTransform != null) {
                    gTransform.loadTransform(cGraphics2D);
                }
                return true;
            }
            n2 = this.nodeList.size();
            for (int k = 0; k < n2; ++k) {
                GNode gNode = (GNode)this.nodeList.get(k);
                if (!gNode.pickable || !gNode.isPicked(cGraphics2D, rectangle)) continue;
                if (gTransform != null) {
                    gTransform.loadTransform(cGraphics2D);
                }
                return true;
            }
            if (gTransform != null) {
                gTransform.loadTransform(cGraphics2D);
            }
        }
        return false;
    }

    private boolean isSelected(Rectangle rectangle) {
        Rectangle2d rectangle2d = new Rectangle2d(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        return this.intersect(rectangle2d);
    }

    @Override
    public void selectionChange(boolean bl) {
        super.selectionChange(bl);
        if (bl) {
            this.removeShadowLevelNodes();
            if ((this.selectionType & 2) != 0) {
                this.shadowSelectionChange();
            }
            if ((this.selectionType & 1) != 0) {
                this.knobSelectionChange();
            }
        } else {
            this.removeKnobLevelNodes();
        }
    }

    protected void knobSelectionChange() {
        Pnt2d[] pnt2dArray = this.getKnobPoints();
        if (pnt2dArray != null) {
            for (int k = 0; k < pnt2dArray.length; ++k) {
                GRimmedGeometry gRimmedGeometry = null;
                gRimmedGeometry = RuntimeGlobal.sysProp.getIntWithDefault("diagram.editor.knob.selected") == 0 ? new GKnob(pnt2dArray[k].x - 3.0, pnt2dArray[k].y - 3.0, k) : new GRoundKnob(pnt2dArray[k].x - 3.0, pnt2dArray[k].y - 3.0, k);
                gRimmedGeometry.setColorNo(knobColorNo);
                if (fillKnob) {
                    gRimmedGeometry.setFilled(true);
                    gRimmedGeometry.setBackgroundNo(knobColorNo);
                }
                gRimmedGeometry.setDepth(this.depth - 1);
                this.addNode(gRimmedGeometry);
            }
        }
    }

    protected void shadowSelectionChange() {
        GRimmedGeometry gRimmedGeometry = this.getShadow();
        if (gRimmedGeometry != null) {
            gRimmedGeometry.setColorNo(shadowColorNo);
            gRimmedGeometry.setBackgroundNo(shadowColorNo);
            gRimmedGeometry.setAlpha(shadowAlpha);
            gRimmedGeometry.setFilled(this.isFilled());
            gRimmedGeometry.setPickable(false);
            gRimmedGeometry.setSelectable(false);
            gRimmedGeometry.level = this.isShowShadow() ? GKnob.knobLevel - 1 : GKnob.knobLevel - 2;
            gRimmedGeometry.setDepth(this.depth + 1);
            gRimmedGeometry.addTransform(new GTranslate(shadowPointX, shadowPointY));
            this.addNode(gRimmedGeometry);
        }
    }

    private void removeKnobLevelNodes() {
        int n = 0;
        while (n < this.nodeList.size()) {
            GNode gNode = (GNode)this.nodeList.get(n);
            if (gNode.level == GKnob.knobLevel || gNode.level == GKnob.knobLevel - 2) {
                this.nodeList.remove(gNode);
                continue;
            }
            ++n;
        }
    }

    private void removeShadowLevelNodes() {
        int n = 0;
        while (n < this.nodeList.size()) {
            GNode gNode = (GNode)this.nodeList.get(n);
            if (gNode.level == GKnob.knobLevel - 1) {
                this.nodeList.remove(gNode);
                continue;
            }
            ++n;
        }
    }

    public int getNoShapes() {
        return 0;
    }

    public int getNoImage() {
        return 0;
    }

    public Shape getShape(int n) {
        return null;
    }

    public CImageIcon getImage(int n) {
        return null;
    }

    public Font getFont() {
        return null;
    }

    public double getHeight(CGraphics cGraphics, int n) {
        return 0.0;
    }

    public Pnt2d[] getKnobPoints() {
        return null;
    }

    public BasicStroke getStroke() {
        return null;
    }

    public boolean isFilled() {
        return false;
    }

    public CImage getImage() {
        return null;
    }

    public Rectangle2d getBounds2d(CGraphics cGraphics) {
        return null;
    }

    public GRimmedGeometry getShadow() {
        return null;
    }

    public int getDiagonalLength(GGraphics gGraphics) {
        return Integer.MAX_VALUE;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(CColor cColor) {
        this.backgroundColor = cColor.transferToAWTColor();
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public void setForegroundColor(CColor cColor) {
        this.foregroundColor = cColor.transferToAWTColor();
    }

    public boolean isShowShadow() {
        return isShowShadow;
    }

    public static void setShowShadow(boolean bl) {
        isShowShadow = bl;
    }
}

