/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.draw;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import net.astah.golf.draw.GGraphics;
import net.astah.golf.draw.GPolyline;
import net.astah.golf.draw.GRimmedGeometry;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.geom2D.Rectangle2d;

public abstract class GGeneralPath
extends GRimmedGeometry {
    protected GeneralPath path;
    protected Pnt2d[] points;

    public GGeneralPath() {
        this(new Pnt2d[]{new Pnt2d()});
    }

    public GGeneralPath(Pnt2d[] pnt2dArray) {
        this.boundingBox = new Rectangle2d();
        this.path = new GeneralPath();
        this.setPoints(pnt2dArray);
    }

    public abstract void setPoints(Pnt2d[] var1);

    public Pnt2d[] getPoints() {
        return this.points;
    }

    @Override
    public int getNoShapes() {
        return 1;
    }

    @Override
    public Shape getShape(int n) {
        return this.path;
    }

    @Override
    public Pnt2d[] getKnobPoints() {
        return this.points;
    }

    @Override
    public int getDiagonalLength(GGraphics gGraphics) {
        return (int)Math.round(Point2D.distance(this.getMinX(), this.getMinY(), this.getMaxX(), this.getMaxY()) * gGraphics.camera.scale);
    }

    double getMinX() {
        double d2 = this.points[0].x;
        for (int k = 1; k < this.points.length; ++k) {
            if (!(this.points[k].x < d2)) continue;
            d2 = this.points[k].x;
        }
        return d2;
    }

    double getMinY() {
        double d2 = this.points[0].y;
        for (int k = 1; k < this.points.length; ++k) {
            if (!(this.points[k].y < d2)) continue;
            d2 = this.points[k].y;
        }
        return d2;
    }

    double getMaxX() {
        double d2 = this.points[0].x;
        for (int k = 1; k < this.points.length; ++k) {
            if (!(this.points[k].x > d2)) continue;
            d2 = this.points[k].x;
        }
        return d2;
    }

    double getMaxY() {
        double d2 = this.points[0].y;
        for (int k = 1; k < this.points.length; ++k) {
            if (!(this.points[k].y > d2)) continue;
            d2 = this.points[k].y;
        }
        return d2;
    }

    @Override
    public abstract GRimmedGeometry getShadow();

    public Rectangle2d getBounds2d() {
        if (!this.boundingBoxShouldBeUpdated) {
            return this.boundingBox;
        }
        this.boundingBox.setRect(0.0, 0.0, 0.0, 0.0);
        if (this.points[0] != null) {
            Pnt2d pnt2d = this.points[0];
            this.boundingBox.setRect(pnt2d.x, pnt2d.y, 1.0, 1.0);
        }
        for (int k = 1; k < this.points.length; ++k) {
            this.boundingBox.add(this.points[k]);
        }
        this.boundingBoxShouldBeUpdated = false;
        return this.boundingBox;
    }

    @Override
    public boolean intersect(Rectangle2d rectangle2d) {
        int n;
        if (rectangle2d.isEmpty() || this.points == null) {
            return true;
        }
        for (n = 0; n < this.points.length; ++n) {
            if (!rectangle2d.contains(this.points[n])) continue;
            return true;
        }
        if (this.isRimmedPick()) {
            for (n = 0; n < this.points.length; ++n) {
                GPolyline gPolyline = new GPolyline(new Pnt2d[]{this.points[n], this.points[(n + 1) % this.points.length]});
                if (!gPolyline.intersect(rectangle2d)) continue;
                return true;
            }
        } else {
            Rectangle2d rectangle2d2 = this.getBounds2d();
            if (rectangle2d.intersects(rectangle2d2)) {
                return true;
            }
        }
        return false;
    }
}

