/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.draw;

import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import net.astah.golf.draw.GArrow;
import net.astah.golf.draw.GRimmedGeometry;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.geom2D.Rectangle2d;
import net.astah.golf.util.Debug;

public class GFreeHandArrow
extends GArrow {
    private boolean hasShadow = true;
    static BasicStroke ROUND_SOLID5 = new BasicStroke(5.0f, 0, 1);
    static BasicStroke ROUND_DASH1_55 = new BasicStroke(5.0f, 0, 1, 10.0f, new float[]{5.0f, 5.0f}, 0.0f);
    static BasicStroke ROUND_DASH2_55 = new BasicStroke(5.0f, 0, 1, 10.0f, new float[]{10.0f, 5.0f}, 0.0f);
    static BasicStroke ROUND_DASH3_55 = new BasicStroke(5.0f, 0, 1, 10.0f, new float[]{60.0f, 30.0f}, 0.0f);
    private GeneralPath path = new GeneralPath();

    @Override
    public int getNoShapes() {
        return 1;
    }

    @Override
    public Shape getShape(int n) {
        return this.path;
    }

    @Override
    public GRimmedGeometry getShadow() {
        if (!this.hasShadow) {
            return null;
        }
        GFreeHandArrow gFreeHandArrow = new GFreeHandArrow();
        gFreeHandArrow.setRimWidth(this.rimWidth);
        gFreeHandArrow.setPoints(this.points);
        return gFreeHandArrow;
    }

    @Override
    public void setPoints(Pnt2d[] pnt2dArray) {
        this.boundingBoxShouldBeUpdated = true;
        this.path.reset();
        if (pnt2dArray != null && pnt2dArray.length > 0) {
            this.path.moveTo((float)pnt2dArray[0].x, (float)pnt2dArray[0].y);
            for (int k = 1; k < pnt2dArray.length; ++k) {
                this.path.lineTo((float)pnt2dArray[k].x, (float)pnt2dArray[k].y);
            }
        }
        this.points = pnt2dArray;
        this.moveKnobAndShadow();
    }

    @Override
    public boolean intersect(Rectangle2d rectangle2d) {
        int n;
        if (rectangle2d.isEmpty() || this.points == null) {
            return true;
        }
        for (n = 0; n < this.points.length; ++n) {
            if (!rectangle2d.contains(this.points[n])) continue;
            return true;
        }
        if (this.isRimmedPick()) {
            if (this.getRimWidth() < 6) {
                for (n = 0; n < this.points.length - 1; ++n) {
                    if (!rectangle2d.intersectsLine(this.points[n].x, this.points[n].y, this.points[n + 1].x, this.points[n + 1].y)) continue;
                    return true;
                }
            } else {
                BasicStroke basicStroke = this.getStroke();
                Shape shape = basicStroke.createStrokedShape(this.getShape(0));
                if (shape.intersects(rectangle2d)) {
                    return true;
                }
            }
        } else {
            Rectangle2d rectangle2d2 = this.getBounds2d();
            if (rectangle2d.intersects(rectangle2d2)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Pnt2d[] getKnobPoints() {
        Pnt2d[] pnt2dArray = new Pnt2d[4];
        Rectangle2d rectangle2d = this.getBounds2d();
        pnt2dArray[0] = new Pnt2d(rectangle2d.x, rectangle2d.y);
        pnt2dArray[1] = new Pnt2d(rectangle2d.x, rectangle2d.getMaxY());
        pnt2dArray[2] = new Pnt2d(rectangle2d.getMaxX(), rectangle2d.getMaxY());
        pnt2dArray[3] = new Pnt2d(rectangle2d.getMaxX(), rectangle2d.y);
        if (this.rimWidth > 5) {
            return this.getKnobWithWidth();
        }
        return pnt2dArray;
    }

    public Pnt2d[] getKnobWithWidth() {
        Pnt2d[] pnt2dArray = new Pnt2d[4];
        Rectangle2D rectangle2D = this.getBounds2dWithWidth();
        pnt2dArray[0] = new Pnt2d(rectangle2D.getMinX(), rectangle2D.getMinY());
        pnt2dArray[1] = new Pnt2d(rectangle2D.getMinX(), rectangle2D.getMaxY());
        pnt2dArray[2] = new Pnt2d(rectangle2D.getMaxX(), rectangle2D.getMaxY());
        pnt2dArray[3] = new Pnt2d(rectangle2D.getMaxX(), rectangle2D.getMinY());
        return pnt2dArray;
    }

    public Rectangle2D getBounds2dWithWidth() {
        BasicStroke basicStroke = this.getStroke();
        Shape shape = basicStroke.createStrokedShape(this.getShape(0));
        return shape.getBounds2D();
    }

    public double getKnobDiffWidthWithWidth() {
        if (this.rimWidth > 5) {
            Rectangle2d rectangle2d = this.getBounds2d();
            Rectangle2D rectangle2D = this.getBounds2dWithWidth();
            return rectangle2D.getWidth() - rectangle2d.width;
        }
        return 0.0;
    }

    public double getKnobDiffHeightWithWidth() {
        if (this.rimWidth > 5) {
            Rectangle2d rectangle2d = this.getBounds2d();
            Rectangle2D rectangle2D = this.getBounds2dWithWidth();
            return rectangle2D.getHeight() - rectangle2d.height;
        }
        return 0.0;
    }

    @Override
    public BasicStroke getStroke() {
        switch (this.rimPattern) {
            case 0: {
                if (this.rimWidth == 5) {
                    return ROUND_SOLID5;
                }
                return new BasicStroke(this.rimWidth, 0, 1);
            }
            case 1: {
                if (this.rimWidth == 5 && this.rimPatternScale == 5) {
                    return ROUND_DASH1_55;
                }
                return new BasicStroke(this.rimWidth, 0, 1, 10.0f, new float[]{this.rimPatternScale, this.rimPatternScale}, 0.0f);
            }
            case 2: {
                if (this.rimWidth == 5 && this.rimPatternScale == 5) {
                    return ROUND_DASH2_55;
                }
                return new BasicStroke(this.rimWidth, 0, 1, 10.0f, new float[]{2.0f * (float)this.rimPatternScale, this.rimPatternScale}, 0.0f);
            }
            case 3: {
                if (this.rimWidth == 5 && this.rimPatternScale == 5) {
                    return ROUND_DASH3_55;
                }
                return new BasicStroke(this.rimWidth, 0, 1, 10.0f, new float[]{12.0f * (float)this.rimPatternScale, 6.0f * (float)this.rimPatternScale}, 0.0f);
            }
        }
        Debug.impossible();
        return null;
    }

    public void setHasShadow(boolean bl) {
        this.hasShadow = bl;
    }

    @Override
    public boolean isShowShadow() {
        return this.hasShadow && super.isShowShadow();
    }
}

