/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.draw;

import net.astah.golf.draw.GGeometry;
import net.astah.golf.draw.GPolyline;
import net.astah.golf.geom2D.Pnt2d;

public class GFork
extends GGeometry {
    private GPolyline body = new GPolyline();
    private GPolyline arm = new GPolyline();
    private GPolyline leftLeg = new GPolyline();
    private GPolyline rightLeg = new GPolyline();
    private Pnt2d position;
    private double width;
    private double height;

    public GFork() {
        this(new Pnt2d(), 0.0, 0.0);
    }

    public GFork(Pnt2d pnt2d, double d2, double d3) {
        this.position = pnt2d;
        this.width = d2;
        this.height = d3;
        this.addNode(this.body);
        this.addNode(this.arm);
        this.addNode(this.leftLeg);
        this.addNode(this.rightLeg);
        this.setup();
    }

    public void setup() {
        this.setupBody();
        this.setupArm();
        this.setupLeftLeg();
        this.setupRightLeg();
    }

    private void setupBody() {
        Pnt2d[] pnt2dArray = new Pnt2d[]{new Pnt2d(this.position.x + this.width / 2.0, this.position.y), new Pnt2d(this.position.x + this.width / 2.0, this.position.y + this.height / 2.0)};
        this.body.setPoints(pnt2dArray);
    }

    private void setupArm() {
        Pnt2d[] pnt2dArray = new Pnt2d[]{new Pnt2d(this.position.x, this.position.y + this.height / 2.0), new Pnt2d(this.position.x + this.width, this.position.y + this.height / 2.0)};
        this.arm.setPoints(pnt2dArray);
    }

    private void setupLeftLeg() {
        Pnt2d[] pnt2dArray = new Pnt2d[]{new Pnt2d(this.position.x, this.position.y + this.height / 2.0), new Pnt2d(this.position.x, this.position.y + this.height)};
        this.leftLeg.setPoints(pnt2dArray);
    }

    private void setupRightLeg() {
        Pnt2d[] pnt2dArray = new Pnt2d[]{new Pnt2d(this.position.x + this.width, this.position.y + this.height / 2.0), new Pnt2d(this.position.x + this.width, this.position.y + this.height)};
        this.rightLeg.setPoints(pnt2dArray);
    }

    public double getHeight() {
        return this.height;
    }

    public Pnt2d getPosition() {
        return this.position;
    }

    public double getWidth() {
        return this.width;
    }

    public void setHeight(double d2) {
        this.height = d2;
    }

    public void setPosition(Pnt2d pnt2d) {
        this.position = pnt2d;
    }

    public void setWidth(double d2) {
        this.width = d2;
    }

    @Override
    public void setColorNo(byte by) {
        this.body.setColorNo(by);
        this.arm.setColorNo(by);
        this.leftLeg.setColorNo(by);
        this.rightLeg.setColorNo(by);
    }

    public void setRimWidth(int n) {
        this.body.setRimWidth(n);
        this.arm.setRimWidth(n);
        this.leftLeg.setRimWidth(n);
        this.rightLeg.setRimWidth(n);
    }
}

