/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.draw;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import net.astah.golf.draw.GArrow;
import net.astah.golf.draw.GKnob;
import net.astah.golf.draw.GPolyline;
import net.astah.golf.draw.GRimmedGeometry;
import net.astah.golf.geom2D.CubicCurve2d;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.geom2D.Rectangle2d;

public class GCurve
extends GArrow {
    protected CubicCurve2d cubicCurve2d = new CubicCurve2d();
    protected Pnt2d[] knobPoints;
    protected double width = 0.0;
    protected double height = 0.0;
    private boolean showControlKnob;
    private byte controlLineColorNo;
    protected static final double DISTANCE_CORRECTION_FACTOR = 0.78;
    private static final BufferedImage DUMMY_IMAGE = new BufferedImage(10, 10, 1);
    private static final Graphics2D DUMMY_GRAPHICS = DUMMY_IMAGE.createGraphics();
    private static final Rectangle DUMMY_RECT = new Rectangle();

    public GCurve() {
        this(false);
    }

    public GCurve(boolean bl) {
        this.showControlKnob = bl;
    }

    public GCurve(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        this(false, d2, d3, d4, d5, d6, d7, d8, d9);
    }

    public GCurve(boolean bl, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        this.setCurve(d2, d3, d4, d5, d6, d7, d8, d9);
        this.showControlKnob = bl;
    }

    public void setCurve(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        this.cubicCurve2d.setCurve(d2, d3, d4, d5, d6, d7, d8, d9);
        this.setPoints(new Pnt2d[]{new Pnt2d(d2, d3), new Pnt2d(d4, d5), new Pnt2d(d6, d7), new Pnt2d(d8, d9)});
        this.width = d8 - d2;
        if (this.width < 0.0) {
            this.width = -this.width;
        }
        this.height = d9 - d3;
        if (this.height < 0.0) {
            this.height = -this.height;
        }
        this.setPoint(d2, d3);
        if (this.showControlKnob) {
            if (this.knobPoints == null) {
                this.knobPoints = new Pnt2d[4];
            }
            this.knobPoints[0] = new Pnt2d(d2, d3);
            this.knobPoints[1] = new Pnt2d(d4, d5);
            this.knobPoints[2] = new Pnt2d(d6, d7);
            this.knobPoints[3] = new Pnt2d(d8, d9);
        } else {
            if (this.knobPoints == null) {
                this.knobPoints = new Pnt2d[2];
            }
            this.knobPoints[0] = new Pnt2d(d2, d3);
            this.knobPoints[1] = new Pnt2d(d8, d9);
        }
        this.moveKnobAndShadow();
    }

    @Override
    public void setPoint(double d2, double d3) {
        super.setPoint(d2, d3);
    }

    public void setWidth(double d2) {
        this.width = d2;
        this.moveKnobAndShadow();
    }

    public void setHeight(double d2) {
        this.height = d2;
        this.moveKnobAndShadow();
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    @Override
    public int getNoShapes() {
        return 1;
    }

    @Override
    public Shape getShape(int n) {
        return this.cubicCurve2d;
    }

    @Override
    public int getNoImage() {
        return 0;
    }

    @Override
    public Pnt2d[] getKnobPoints() {
        return this.knobPoints;
    }

    public String toString() {
        return "GCurve";
    }

    @Override
    public boolean intersect(Rectangle2d rectangle2d) {
        if (rectangle2d.isEmpty() || this.knobPoints == null) {
            return true;
        }
        if (rectangle2d.contains(this.cubicCurve2d.x1, this.cubicCurve2d.y1) || rectangle2d.contains(this.cubicCurve2d.x2, this.cubicCurve2d.y2)) {
            return true;
        }
        DUMMY_RECT.setRect((int)rectangle2d.x, (int)rectangle2d.y, (int)rectangle2d.width, (int)rectangle2d.height);
        return DUMMY_GRAPHICS.hit(DUMMY_RECT, this.cubicCurve2d, true);
    }

    @Override
    public GRimmedGeometry getShadow() {
        GCurve gCurve = new GCurve(this.cubicCurve2d.x1, this.cubicCurve2d.y1, this.cubicCurve2d.ctrlx1, this.cubicCurve2d.ctrly1, this.cubicCurve2d.ctrlx2, this.cubicCurve2d.ctrly2, this.cubicCurve2d.x2, this.cubicCurve2d.y2);
        gCurve.setRimWidth(this.rimWidth);
        return gCurve;
    }

    public void setControlLineColorNo(byte by) {
        this.controlLineColorNo = by;
    }

    @Override
    protected void knobSelectionChange() {
        super.knobSelectionChange();
        Pnt2d[] pnt2dArray = this.getKnobPoints();
        if (this.showControlKnob && pnt2dArray != null && pnt2dArray.length == 4) {
            GPolyline gPolyline = this.createControlLine(new Pnt2d[]{pnt2dArray[0], pnt2dArray[1]});
            this.addNode(gPolyline);
            GPolyline gPolyline2 = this.createControlLine(new Pnt2d[]{pnt2dArray[3], pnt2dArray[2]});
            this.addNode(gPolyline2);
        }
    }

    private GPolyline createControlLine(Pnt2d[] pnt2dArray) {
        GPolyline gPolyline = new GPolyline();
        gPolyline.setPoints(pnt2dArray);
        gPolyline.setColorNo(this.controlLineColorNo);
        gPolyline.setBackgroundNo(shadowColorNo);
        gPolyline.setAlpha(shadowAlpha);
        gPolyline.setFilled(this.isFilled());
        gPolyline.setPickable(false);
        gPolyline.setSelectable(false);
        gPolyline.level = GKnob.knobLevel;
        gPolyline.setDepth(this.depth + 1);
        this.addNode(gPolyline);
        return gPolyline;
    }

    public CubicCurve2d getPeerCurve() {
        return this.cubicCurve2d;
    }

    @Override
    double getAcuteAngle(int n) {
        double d2 = 0.0;
        if (this.points.length >= 2) {
            Pnt2d pnt2d = null;
            Pnt2d pnt2d2 = null;
            if (n == 0) {
                if (this.points.length < 4) {
                    pnt2d = this.points[0];
                    pnt2d2 = this.points[1];
                } else {
                    pnt2d = this.points[0];
                    pnt2d2 = this.getTriangleBasePoint(n);
                }
            } else if (this.points.length < 4) {
                pnt2d = this.points[this.points.length - 1];
                pnt2d2 = this.points[this.points.length - 2];
            } else {
                pnt2d = this.points[3];
                pnt2d2 = this.getTriangleBasePoint(n);
            }
            if (pnt2d.distanceSq(pnt2d2) >= 1.0E-9) {
                d2 = pnt2d.angle(pnt2d2);
            }
        }
        return d2;
    }

    Pnt2d getTriangleBasePoint(int n) {
        double d2;
        double d3;
        double d4;
        double d5;
        double d6 = this.points[0].distance(this.points[1]);
        double d7 = (d6 + (d5 = this.points[1].distance(this.points[2])) + (d4 = this.points[2].distance(this.points[3]))) * 0.78;
        if (d7 <= 0.0) {
            if (n == 0) {
                return this.points[1];
            }
            return this.points[2];
        }
        double d8 = 11.0 / d7;
        if (n == 0) {
            d3 = this.getPointXOnBezierCurve(d8);
            d2 = this.getPointYOnBezierCurve(d8);
        } else {
            d3 = this.getPointXOnBezierCurve(1.0 - d8);
            d2 = this.getPointYOnBezierCurve(1.0 - d8);
        }
        return new Pnt2d(d3, d2);
    }

    private double getPointYOnBezierCurve(double d2) {
        double d3 = 1.0 - d2;
        double d4 = Math.pow(d2, 3.0) * this.points[3].y + 3.0 * Math.pow(d2, 2.0) * d3 * this.points[2].y + 3.0 * d2 * Math.pow(d3, 2.0) * this.points[1].y + Math.pow(d3, 3.0) * this.points[0].y;
        return d4;
    }

    private double getPointXOnBezierCurve(double d2) {
        double d3 = 1.0 - d2;
        double d4 = Math.pow(d2, 3.0) * this.points[3].x + 3.0 * Math.pow(d2, 2.0) * d3 * this.points[2].x + 3.0 * d2 * Math.pow(d3, 2.0) * this.points[1].x + Math.pow(d3, 3.0) * this.points[0].x;
        return d4;
    }
}

