/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.draw;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import net.astah.golf.draw.GCanvas;
import net.astah.golf.draw.GGraphics;
import net.astah.golf.draw.GNode;
import net.astah.golf.draw.GTransform;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.geom2D.Rectangle2d;
import net.astah.golf.widget.CGraphics2D;
import net.astah.golf.widget.swing.SwingComponent;

public class GComponentNode
extends GNode
implements KeyListener {
    Component component;
    double x;
    double y;
    double width;
    double height;
    private Pnt2d tempPoint = new Pnt2d();

    public GComponentNode() {
        this(null, 0.0, 0.0, 0.0, 0.0);
    }

    public GComponentNode(Component component, Rectangle2d rectangle2d) {
        this(component, rectangle2d.x, rectangle2d.y, rectangle2d.width, rectangle2d.height);
    }

    public GComponentNode(Component component, double d2, double d3, double d4, double d5) {
        this.setComponent(component);
        this.setBounds2d(d2, d3, d4, d5);
    }

    public void setComponent(Component component) {
        this.component = component;
    }

    public Component getComponent() {
        return this.component;
    }

    public void setBounds2d(Rectangle2d rectangle2d) {
        this.setBounds2d(rectangle2d.x, rectangle2d.y, rectangle2d.width, rectangle2d.height);
    }

    public void setBounds2d(double d2, double d3, double d4, double d5) {
        this.x = d2;
        this.y = d3;
        this.width = d4;
        this.height = d5;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    @Override
    public void draw(GGraphics gGraphics) {
        this.wasDrawn = false;
        if (this.visible) {
            this.wasDrawn = true;
            if (!gGraphics.gCanvas.isDoDrawComponent()) {
                return;
            }
            CGraphics2D cGraphics2D = gGraphics.getGraphics2D();
            GTransform gTransform = null;
            int n = this.transformList.size();
            if (n > 0) {
                gTransform = (GTransform)this.transformList.get(0);
                gTransform.saveTransform(cGraphics2D);
                for (int k = 0; k < n; ++k) {
                    ((GTransform)this.transformList.get(k)).transform(cGraphics2D);
                }
            }
            this.tempPoint.set(this.x, this.y);
            cGraphics2D.getTransform().transform(this.tempPoint, this.tempPoint);
            if (gTransform != null) {
                gTransform.loadTransform(cGraphics2D);
            }
            this.component.setBounds((int)Math.round(this.tempPoint.x), (int)Math.round(this.tempPoint.y), (int)Math.round(this.width), (int)Math.round(this.height));
            gGraphics.gCanvas.add(new SwingComponent(this.component));
        }
    }

    public void clear(GGraphics gGraphics) {
        gGraphics.gCanvas.remove(new SwingComponent(this.component));
    }

    @Override
    public void repaintComponent() {
        if (this.component.isDisplayable() && JComponent.isLightweightComponent(this.component)) {
            this.component.repaint();
        }
    }

    int getDiagonalLength(GGraphics gGraphics) {
        return (int)Math.round(Math.sqrt(this.width * this.width + this.height * this.height) * gGraphics.camera.scale);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        Container container = this.component.getParent();
        if (container != null && container instanceof GCanvas) {
            ((GCanvas)container).processKeyEvent(keyEvent);
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        this.keyTyped(keyEvent);
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        this.keyTyped(keyEvent);
    }
}

