/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.draw;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import net.astah.golf.control.BaseCommandSetting;
import net.astah.golf.control.GolfAction;
import net.astah.golf.model.ModelPropertyEditor;
import net.astah.golf.util.GolfUtilities;

public class GComboBox<E>
extends JComboBox<E>
implements ItemListener,
ModelPropertyEditor<E> {
    private static final long serialVersionUID = -949558476059980303L;
    protected static GolfAction actionListener = new GolfAction(BaseCommandSetting.getModelUpdateCommandName());
    private boolean layingOut = false;
    private boolean dirty = false;

    public GComboBox(ComboBoxModel<E> comboBoxModel) {
        super(comboBoxModel);
        this.init();
    }

    public GComboBox(E[] EArray) {
        super(EArray);
        this.init();
    }

    public GComboBox(Vector<E> vector) {
        super(vector);
        this.init();
    }

    public GComboBox() {
        this.init();
    }

    protected void init() {
        this.addActionListener(actionListener);
        this.addItemListener(this);
        Dimension dimension = this.getPreferredSize();
        dimension.width = 30;
        this.setPreferredSize(dimension);
    }

    public static GolfAction getLocalListener() {
        return actionListener;
    }

    @Override
    public void setSelectedItem(Object object) {
        super.setSelectedItem(object);
        String string = this.getTooltip(object);
        int n = (int)GolfUtilities.computeStringWidth(this.getFont(), string);
        if (n > this.getWidth()) {
            this.setToolTipText(string);
        } else {
            this.setToolTipText(null);
        }
    }

    protected String getTooltip(Object object) {
        return object != null ? object.toString() : "";
    }

    @Override
    public void doLayout() {
        try {
            this.layingOut = true;
            super.doLayout();
        }
        finally {
            this.layingOut = false;
        }
    }

    @Override
    public Dimension getSize() {
        Dimension dimension = super.getSize();
        if (!this.layingOut) {
            dimension.width = Math.max(dimension.width, this.getMaxSize());
        }
        return dimension;
    }

    private int getMaxSize() {
        double d2 = 0.0;
        ListCellRenderer listCellRenderer = this.getRenderer();
        JList jList = new JList();
        for (int k = 0; k < this.getItemCount(); ++k) {
            double d3;
            Object e2 = this.getItemAt(k);
            if (listCellRenderer == null) {
                d3 = GolfUtilities.computeStringWidth(this.getFont(), e2.toString());
            } else {
                Component component = listCellRenderer.getListCellRendererComponent(jList, e2, k, false, false);
                component.setFont(this.getFont());
                d3 = component.getPreferredSize().getWidth();
            }
            if (!(d3 > d2)) continue;
            d2 = d3;
        }
        d2 += 10.0;
        if (this.getItemCount() > 20) {
            d2 += 20.0;
        }
        return (int)d2;
    }

    @Override
    protected void fireActionEvent() {
        if (this.isDirty()) {
            super.fireActionEvent();
        }
    }

    @Override
    public void setInitialValue(E e2) {
        this.removeItemListener(this);
        this.setSelectedItem(e2);
        this.dirty = false;
        this.addItemListener(this);
    }

    @Override
    public E getValue() {
        return (E)this.getSelectedItem();
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.dirty = true;
        }
    }
}

