/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.draw;

import java.util.ArrayList;
import java.util.List;
import net.astah.golf.draw.GGeneralPath;
import net.astah.golf.draw.GRimmedGeometry;
import net.astah.golf.geom2D.Pnt2d;

public class GCloudGeneralPath
extends GGeneralPath {
    private static final int CURVE_HEIGHT = 10;
    private static final double CENTER_POINT_DISTANCE = 40.0;

    public GCloudGeneralPath() {
    }

    public GCloudGeneralPath(Pnt2d[] pnt2dArray) {
        super(pnt2dArray);
    }

    @Override
    public void setPoints(Pnt2d[] pnt2dArray) {
        this.boundingBoxShouldBeUpdated = true;
        this.path.reset();
        Pnt2d[] pnt2dArray2 = this.getAllPoints(pnt2dArray);
        if (pnt2dArray2.length > 0) {
            this.path.moveTo((float)pnt2dArray2[0].x, (float)pnt2dArray2[0].y);
            for (int k = 1; k <= pnt2dArray2.length; ++k) {
                Pnt2d pnt2d = this.getControlPoint(pnt2dArray2[k - 1], pnt2dArray2[k % pnt2dArray2.length]);
                this.path.quadTo((float)pnt2d.x, (float)pnt2d.y, (float)pnt2dArray2[k % pnt2dArray2.length].x, (float)pnt2dArray2[k % pnt2dArray2.length].y);
            }
            this.path.closePath();
        }
        this.points = pnt2dArray2;
        this.moveKnobAndShadow();
    }

    private Pnt2d[] getAllPoints(Pnt2d[] pnt2dArray) {
        ArrayList<Pnt2d> arrayList = new ArrayList<Pnt2d>();
        if (pnt2dArray != null) {
            for (int k = 0; k < pnt2dArray.length; ++k) {
                arrayList.add(pnt2dArray[k]);
                arrayList.addAll(this.getCenterPoints(pnt2dArray[k], pnt2dArray[(k + 1) % pnt2dArray.length]));
            }
        }
        return arrayList.toArray(new Pnt2d[0]);
    }

    private List getCenterPoints(Pnt2d pnt2d, Pnt2d pnt2d2) {
        ArrayList<Pnt2d> arrayList = new ArrayList<Pnt2d>();
        double d2 = pnt2d.distance(pnt2d2);
        int n = (int)Math.round(d2 / 40.0);
        for (int k = 1; k < n; ++k) {
            Pnt2d pnt2d3 = new Pnt2d(pnt2d.x + (pnt2d2.x - pnt2d.x) / (double)n * (double)k, pnt2d.y + (pnt2d2.y - pnt2d.y) / (double)n * (double)k);
            arrayList.add(pnt2d3);
        }
        return arrayList;
    }

    private Pnt2d getControlPoint(Pnt2d pnt2d, Pnt2d pnt2d2) {
        double d2 = Math.min(pnt2d.x, pnt2d2.x) + Math.abs(pnt2d.x - pnt2d2.x) / 2.0;
        double d3 = Math.min(pnt2d.y, pnt2d2.y) + Math.abs(pnt2d.y - pnt2d2.y) / 2.0;
        if (pnt2d.x == pnt2d2.x) {
            double d4 = pnt2d.y < pnt2d2.y ? 10.0 : -10.0;
            return new Pnt2d(d2 + d4, d3);
        }
        double d5 = this.getGradient(pnt2d, pnt2d2);
        double d6 = Math.sqrt(Math.pow(10.0, 2.0) / (1.0 + Math.pow(d5, 2.0)));
        double d7 = pnt2d.x < pnt2d2.x ? -d6 : d6;
        double d8 = d5 * d7;
        return new Pnt2d(d2 + d8, d3 + d7);
    }

    private double getGradient(Pnt2d pnt2d, Pnt2d pnt2d2) {
        double d2 = pnt2d2.x - pnt2d.x;
        double d3 = pnt2d2.y - pnt2d.y;
        return -d3 / d2;
    }

    @Override
    public GRimmedGeometry getShadow() {
        GCloudGeneralPath gCloudGeneralPath = new GCloudGeneralPath(this.points);
        gCloudGeneralPath.setRimWidth(this.rimWidth);
        return gCloudGeneralPath;
    }
}

