/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.draw;

import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JPanel;
import net.astah.golf.draw.GCamera;
import net.astah.golf.draw.GCanvasSelectionEvent;
import net.astah.golf.draw.GCanvasSelectionListener;
import net.astah.golf.draw.GGraphics;
import net.astah.golf.draw.GNode;
import net.astah.golf.draw.GScene;
import net.astah.golf.draw.GSceneEvent;
import net.astah.golf.draw.GSceneListener;
import net.astah.golf.draw.GTransform;
import net.astah.golf.util.Debug;
import net.astah.golf.util.GolfUtilities;
import net.astah.golf.widget.CColor;
import net.astah.golf.widget.CGraphics;
import net.astah.golf.widget.swing.SwingCanvas;
import net.astah.golf.widget.swing.SwingColor;
import net.astah.golf.widget.swing.SwingGraphics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCanvas
extends JPanel
implements GSceneListener {
    private static final long serialVersionUID = -3902371700800269464L;
    List<GScene> sceneList = new ArrayList<GScene>();
    protected GGraphics gGraphics;
    protected Graphics2D graphics2D;
    Image image;
    List<GCanvasSelectionListener> selectionListeners = new ArrayList<GCanvasSelectionListener>();
    static final Color transparentColor = new Color(0, 0, 0, 0);
    private boolean updateViewport = true;
    private boolean doDrawComponent = true;
    private int gradationNo = 0;
    private Runnable operationBeforePainting;
    private static final Logger logger = LoggerFactory.getLogger(GCanvas.class);
    private boolean previousIsMacRetina = GolfUtilities.isMacRetina();

    public Graphics2D getGraphics2D() {
        return this.graphics2D;
    }

    public boolean isDoDrawComponent() {
        return this.doDrawComponent;
    }

    public void setDoDrawComponent(boolean bl) {
        this.doDrawComponent = bl;
    }

    public GCanvas() {
        super(null);
        this.setBackground(Color.WHITE);
        this.gGraphics = new GGraphics(new SwingCanvas(this));
    }

    public void addScene(GScene gScene) {
        this.sceneList.add(gScene);
    }

    public void removeScene(GScene gScene) {
        this.sceneList.remove(gScene);
    }

    public void remove() {
        this.sceneList.clear();
        this.gGraphics = null;
        this.image = null;
        if (this.graphics2D != null) {
            this.graphics2D.dispose();
            this.graphics2D = null;
        }
        this.selectionListeners.clear();
    }

    public void addGCanvasSelectionListener(GCanvasSelectionListener gCanvasSelectionListener) {
        this.selectionListeners.add(gCanvasSelectionListener);
    }

    public void removeGCanvasSelectionListener(GCanvasSelectionListener gCanvasSelectionListener) {
        this.selectionListeners.remove(gCanvasSelectionListener);
    }

    public GScene[] getAllScenes() {
        return this.sceneList.toArray(new GScene[this.sceneList.size()]);
    }

    @Override
    public void paint(Graphics graphics) {
        boolean bl;
        if (this.operationBeforePainting != null) {
            this.operationBeforePainting.run();
            this.operationBeforePainting = null;
        }
        if (this.image == null) {
            this.setupImage();
        }
        if ((bl = GolfUtilities.isMacRetina()) != this.previousIsMacRetina) {
            this.setupImage();
            this.clear();
            this.draw();
            this.xor();
            this.previousIsMacRetina = bl;
        }
        if (bl) {
            try {
                ((Graphics2D)graphics).scale(0.5, 0.5);
                graphics.drawImage(this.image, 0, 0, this);
            }
            finally {
                ((Graphics2D)graphics).scale(2.0, 2.0);
            }
        } else {
            graphics.drawImage(this.image, 0, 0, this);
        }
        int n = this.sceneList.size();
        for (int k = 0; k < n; ++k) {
            GScene gScene = this.sceneList.get(k);
            if (!gScene.visible) continue;
            gScene.repaintComponent();
        }
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw() {
        if (this.image == null) {
            this.setupImage();
        }
        int n = this.sceneList.size();
        for (int k = 0; k < n; ++k) {
            double d2;
            GScene gScene = this.sceneList.get(k);
            if (!gScene.visible) continue;
            GCamera gCamera = gScene.getCamera();
            this.gGraphics.setCamera(gCamera);
            if (this.updateViewport) {
                if (gCamera != null) {
                    d2 = gCamera.toWorldCoordX(0);
                    double d3 = gCamera.toWorldCoordY(0);
                    double d4 = gCamera.toWorldCoordX(this.getWidth()) - d2;
                    double d5 = gCamera.toWorldCoordY(this.getHeight()) - d3;
                    this.gGraphics.setViewport(d2, d3, d4, d5);
                    this.gGraphics.setEnableViewport(true);
                }
            } else {
                this.gGraphics.setEnableViewport(false);
            }
            d2 = 1.0;
            try {
                if (gCamera != null) {
                    d2 = gCamera.getScale();
                    if (GolfUtilities.isMacRetina()) {
                        gCamera.setScale(d2 * 2.0);
                    }
                }
                gScene.draw(this.gGraphics);
            }
            finally {
                if (gCamera != null) {
                    gCamera.setScale(d2);
                }
            }
            this.gGraphics.setViewport(0.0, 0.0, 0.0, 0.0);
            this.gGraphics.setEnableViewport(false);
        }
    }

    public void draw(CGraphics cGraphics) {
        CGraphics cGraphics2 = this.gGraphics.getGraphics();
        this.gGraphics.setGraphics(cGraphics);
        int n = this.sceneList.size();
        for (int k = 0; k < n; ++k) {
            GScene gScene = this.sceneList.get(k);
            if (!gScene.visible) continue;
            gScene.draw(this.gGraphics);
        }
        this.gGraphics.setGraphics(cGraphics2);
    }

    void setupImage() {
        int n;
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        int n4 = n = GolfUtilities.isMacRetina() ? 2 : 1;
        if (this.image != null && this.image.getWidth(this) == n2 * n && this.image.getHeight(this) == n3 * n) {
            return;
        }
        logger.debug("setupImage: w = {} h = {}", (Object)n2, (Object)n3);
        this.image = this.createImage(n2 < 1 ? 1 : n2 * n, n3 < 1 ? 1 : n3 * n);
        if (this.image == null) {
            logger.debug("setupImage: image = null");
            return;
        }
        Graphics graphics = this.image.getGraphics();
        graphics.setClip(0, 0, n2 * n, n3 * n);
        this.gGraphics.setGraphics(new SwingGraphics(graphics));
        this.gGraphics.getGraphics2D().setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        this.graphics2D = (Graphics2D)graphics.create();
    }

    public void draw(int n) {
        if (this.image == null) {
            this.setupImage();
        }
        int n2 = this.sceneList.size();
        for (int k = 0; k < n2; ++k) {
            GScene gScene = this.sceneList.get(k);
            if (!gScene.visible) continue;
            gScene.draw(this.gGraphics, n);
        }
    }

    public void drawTemp() {
        this.drawTemp(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawTemp(boolean bl) {
        if (this.image == null) {
            this.setupImage();
        }
        int n = this.sceneList.size();
        for (int k = 0; k < n; ++k) {
            GScene gScene = this.sceneList.get(k);
            if (!gScene.visible) continue;
            double d2 = 1.0;
            GCamera gCamera = gScene.getCamera();
            this.gGraphics.setCamera(gCamera);
            try {
                if (gCamera != null) {
                    d2 = gCamera.getScale();
                    if (bl && GolfUtilities.isMacRetina()) {
                        gCamera.setScale(d2 * 2.0);
                    }
                }
                gScene.drawTemp(this.gGraphics);
                continue;
            }
            finally {
                if (gCamera != null) {
                    gCamera.setScale(d2);
                }
            }
        }
    }

    public void drawTempFront() {
        CGraphics cGraphics = this.gGraphics.graphics;
        this.gGraphics.setGraphics(new SwingGraphics(this.getGraphics()));
        this.drawTemp(false);
        this.gGraphics.setGraphics(cGraphics);
    }

    public void repaintSync() {
        this.paint(this.getGraphics());
    }

    public void xorTemp() {
        this.gGraphics.setXORMode(true);
        CGraphics cGraphics = this.gGraphics.graphics;
        this.gGraphics.setGraphics(new SwingGraphics(this.getGraphics()));
        this.drawTemp(false);
        this.gGraphics.setGraphics(cGraphics);
        this.gGraphics.setXORMode(false);
    }

    public void xor() {
        this.gGraphics.setXORMode(true);
        this.drawTemp();
        this.gGraphics.setXORMode(false);
    }

    public void clear() {
        if (this.image == null) {
            this.setupImage();
            if (this.image == null) {
                return;
            }
        }
        GTransform.resetTransform(this.gGraphics.getGraphics2D());
        this.fillBackground();
        this.removeAll();
    }

    private Color getGradationStartColor(Color color) {
        double d2 = 0.22;
        int n = 231;
        int n2 = color.getRed();
        int n3 = color.getGreen();
        int n4 = color.getBlue();
        int n5 = (int)(1.0 / (1.0 - d2));
        if (n2 > 0 && n2 < n5) {
            n2 = n5;
        }
        if (n3 > 0 && n3 < n5) {
            n3 = n5;
        }
        if (n4 > 0 && n4 < n5) {
            n4 = n5;
        }
        int n6 = (int)((double)n2 / d2);
        int n7 = (int)((double)n3 / d2);
        int n8 = (int)((double)n4 / d2);
        if (n6 < n) {
            n6 = n;
        }
        if (n7 < n) {
            n7 = n;
        }
        if (n8 < n) {
            n8 = n;
        }
        return new Color(Math.min(n6, 255), Math.min(n7, 255), Math.min(n8, 255));
    }

    private void fillBackground() {
        if (this.image == null) {
            this.setupImage();
        }
        int n = 0;
        int n2 = 0;
        Color color = this.getBackground();
        if (this.gradationNo == 0) {
            this.gGraphics.graphics.setColor(new SwingColor(this.getBackground()));
        } else {
            color = this.getGradationStartColor(color);
            if (this.gradationNo == 1) {
                n = this.image.getWidth(this);
                n2 = this.image.getHeight(this);
            } else if (this.gradationNo == 2) {
                n = this.image.getWidth(this);
            } else if (this.gradationNo == 3) {
                n2 = this.image.getHeight(this);
            }
            this.gGraphics.graphics.setColor(new SwingColor(this.getBackground()));
            GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, color, n, n2, this.getBackground());
            this.gGraphics.getGraphics2D().setPaint(gradientPaint);
        }
        this.gGraphics.graphics.fillRect(0, 0, this.image.getWidth(this), this.image.getHeight(this));
    }

    public List<GNode> getPickedNodesWithLevel(Rectangle rectangle, int n) {
        return this.getPickedNodesWithLevel(rectangle, n, false);
    }

    public List<GNode> getPickedNodesWithLevel(Rectangle rectangle, int n, boolean bl) {
        if (bl) {
            for (int k = this.sceneList.size() - 1; k >= 0; --k) {
                List<GNode> list;
                GScene gScene = this.sceneList.get(k);
                if (!gScene.pickable || (list = gScene.getPickedNodesWithLevel(this.gGraphics.getGraphics2D(), rectangle, n, true)) == null || list.size() <= 0) continue;
                return list;
            }
            return new ArrayList<GNode>();
        }
        ArrayList<GNode> arrayList = new ArrayList<GNode>();
        int n2 = this.sceneList.size();
        for (int k = 0; k < n2; ++k) {
            List<GNode> list;
            GScene gScene = this.sceneList.get(k);
            if (!gScene.pickable || (list = gScene.getPickedNodesWithLevel(this.gGraphics.getGraphics2D(), rectangle, n)) == null) continue;
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public List<GNode> getPickedNodes(Rectangle rectangle, int n) {
        return this.getPickedNodes(rectangle, n, false);
    }

    public List<GNode> getPickedNodes(Rectangle rectangle, int n, boolean bl) {
        if (bl) {
            for (int k = this.sceneList.size() - 1; k >= 0; --k) {
                List<GNode> list;
                GScene gScene = this.sceneList.get(k);
                if (!gScene.pickable || (list = gScene.getPickedNodes(this.gGraphics.getGraphics2D(), rectangle, n, true)) == null || list.size() <= 0) continue;
                return list;
            }
            return new ArrayList<GNode>(0);
        }
        ArrayList<GNode> arrayList = new ArrayList<GNode>();
        int n2 = this.sceneList.size();
        for (int k = 0; k < n2; ++k) {
            List<GNode> list;
            GScene gScene = this.sceneList.get(k);
            if (!gScene.pickable || (list = gScene.getPickedNodes(this.gGraphics.getGraphics2D(), rectangle, n)) == null || list.isEmpty()) continue;
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public void selectWithLevel(Rectangle rectangle, int n) {
        this.selectWithLevel(rectangle, n, false);
    }

    public void selectWithLevel(Rectangle rectangle, int n, boolean bl) {
        List<GNode> list = this.getSelectedNodes();
        List<GNode> list2 = this.getPickedNodesWithLevel(rectangle, n, bl);
        for (int k = 0; k < list2.size(); ++k) {
            list2.get(k).setSelected(true);
        }
        List<GNode> list3 = this.getSelectedNodes();
        GCanvasSelectionEvent gCanvasSelectionEvent = new GCanvasSelectionEvent(this, list, list3);
        this.fireSelectionChanged(gCanvasSelectionEvent);
    }

    public void select(Rectangle rectangle, int n) {
        this.select(rectangle, n, false);
    }

    public void select(Rectangle rectangle, int n, boolean bl) {
        List<GNode> list = this.getSelectedNodes();
        List<GNode> list2 = this.getPickedNodes(rectangle, n, bl);
        for (int k = 0; k < list2.size(); ++k) {
            list2.get(k).setSelected(true);
        }
        List<GNode> list3 = this.getSelectedNodes();
        GCanvasSelectionEvent gCanvasSelectionEvent = new GCanvasSelectionEvent(this, list, list3);
        this.fireSelectionChanged(gCanvasSelectionEvent);
    }

    public synchronized void fireSelectionChanged(GCanvasSelectionEvent gCanvasSelectionEvent) {
        for (int k = 0; k < this.selectionListeners.size(); ++k) {
            this.selectionListeners.get(k).selectionChanged(gCanvasSelectionEvent);
        }
    }

    public void unselect() {
        int n = this.sceneList.size();
        for (int k = 0; k < n; ++k) {
            this.sceneList.get(k).unselect();
        }
    }

    public void selectAndNotify(List<GNode> list) {
        List<GNode> list2 = this.getSelectedNodes();
        for (GNode object2 : list) {
            object2.setSelected(true);
        }
        List<GNode> list3 = this.getSelectedNodes();
        GCanvasSelectionEvent gCanvasSelectionEvent = new GCanvasSelectionEvent(this, list2, list3);
        this.fireSelectionChanged(gCanvasSelectionEvent);
    }

    public void select(List<GNode> list) {
        for (GNode gNode : list) {
            gNode.setSelected(true);
        }
    }

    public void selectNodes(Collection<GNode> collection) {
        List<GNode> list = this.getSelectedNodes();
        for (GScene gScene : this.sceneList) {
            for (GNode gNode : gScene.getAllNodes()) {
                gNode.setSelected(collection.contains(gNode));
            }
        }
        List<GNode> list2 = this.getSelectedNodes();
        this.fireSelectionChanged(new GCanvasSelectionEvent(this, list, list2));
    }

    public List<GNode> getSelectedNodes() {
        ArrayList<GNode> arrayList = new ArrayList<GNode>();
        int n = this.sceneList.size();
        for (int k = 0; k < n; ++k) {
            List<GNode> list = this.sceneList.get(k).getSelectedNodes();
            if (list == null || list.isEmpty()) continue;
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public List<GNode> getAllNodes() {
        ArrayList<GNode> arrayList = new ArrayList<GNode>();
        int n = this.sceneList.size();
        for (int k = 0; k < n; ++k) {
            List<GNode> list = this.sceneList.get(k).getAllNodes();
            if (list == null || list.isEmpty()) continue;
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public List<GNode> getSelectedNodes(int n) {
        ArrayList<GNode> arrayList = new ArrayList<GNode>();
        int n2 = this.sceneList.size();
        for (int k = 0; k < n2; ++k) {
            List<GNode> list = this.sceneList.get(k).getSelectedNodes(n);
            if (list == null) continue;
            for (int i2 = 0; i2 < list.size(); ++i2) {
                if (list.get(i2) == null) continue;
                arrayList.add(list.get(i2));
            }
        }
        return arrayList;
    }

    public void setColorMap(CColor[] cColorArray) {
        this.gGraphics.setColorMap(cColorArray);
    }

    public CColor[] getColorMap() {
        return this.gGraphics.colorMap;
    }

    public CColor getColorMap(int n) {
        return this.getColor(n);
    }

    public CColor getColor(int n) {
        return this.getColorMap()[n];
    }

    public static Color getColor(Color color, float f2) {
        return GCanvas.getColor(color, f2, 1.0f);
    }

    public static Color getColor(Color color, float f2, float f3) {
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f3 < 0.0f) {
            f3 = 0.0f;
        }
        if (f3 > 1.0f) {
            f3 = 1.0f;
        }
        return f3 == 0.0f ? transparentColor : (f2 == 1.0f && f3 == 1.0f ? color : new Color(Math.min(Math.round((float)color.getRed() * f2), 255), Math.min(Math.round((float)color.getGreen() * f2), 255), Math.min(Math.round((float)color.getBlue() * f2), 255), Math.round(255.0f * f3)));
    }

    @Override
    public void sceneChange(GSceneEvent gSceneEvent) {
        if (this.image == null) {
            this.setupImage();
        }
        GScene gScene = (GScene)gSceneEvent.getSource();
        switch (gSceneEvent.type) {
            case 0: {
                if (gScene.visible) {
                    if (gSceneEvent.mask == 0) {
                        gScene.draw(this.gGraphics);
                    } else {
                        gScene.draw(this.gGraphics, gSceneEvent.mask);
                    }
                }
                return;
            }
            case 3: {
                this.gGraphics.setXORMode(true);
                this.gGraphics.setGraphics(new SwingGraphics(this.getGraphics()));
            }
            case 1: {
                if (gScene.visible) {
                    gScene.drawTemp(this.gGraphics);
                }
                this.gGraphics.setXORMode(false);
                this.gGraphics.setGraphics(new SwingGraphics(this.image.getGraphics()));
                return;
            }
        }
        Debug.impossible();
        Debug.impossible();
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    @Override
    public void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
    }

    @Override
    public void reshape(int n, int n2, int n3, int n4) {
        boolean bl = this.getWidth() != n3 || this.getHeight() != n4;
        super.reshape(n, n2, n3, n4);
        if (bl) {
            this.setupImage();
            this.clear();
            this.draw();
        }
    }

    public void setDrawingOrder(int[] nArray) {
        this.gGraphics.setDrawingOrder(nArray);
    }

    public int[] getDrawingOrder() {
        return this.gGraphics.drawingOrder;
    }

    public Image getImage() {
        return this.image;
    }

    public GScene[] getScenes() {
        return this.getAllScenes();
    }

    public void clearTemp() {
    }

    public void paintImmediately() {
        if (this.image == null) {
            this.setupImage();
        }
        this.paintImmediately(0, 0, this.image.getWidth(this), this.image.getHeight(this));
    }

    public void setUpdateViewport(boolean bl) {
        this.updateViewport = bl;
    }

    @Override
    public Component add(Component component) {
        if (this.doDrawComponent) {
            return super.add(component);
        }
        return null;
    }

    public void setGradationNo(int n) {
        this.gradationNo = n;
    }

    public void repaint(Runnable runnable) {
        this.operationBeforePainting = runnable;
        this.repaint();
    }
}

