/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.draw;

import java.awt.Point;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.geom2D.Vec2d;
import net.astah.golf.widget.CGraphics2D;

public class GCamera
implements Serializable {
    static final long serialVersionUID = -8512709729937189457L;
    double positionX = 0.0;
    double positionY = 0.0;
    double scale = 1.0;
    int deviceOriginX = 0;
    int deviceOriginY = 0;
    private PropertyChangeSupport changeSupport;

    public void setPosition(Pnt2d pnt2d) {
        this.setPosition(pnt2d.x, pnt2d.y);
    }

    public void setPosition(double d2, double d3) {
        this.positionX = d2;
        this.positionY = d3;
    }

    public double getPositionX() {
        return this.positionX;
    }

    public double getPositionY() {
        return this.positionY;
    }

    public void pan(double d2, double d3) {
        this.setPosition(this.positionX + d2, this.positionY + d3);
    }

    public void pan(Vec2d vec2d) {
        this.pan(vec2d.x, vec2d.y);
    }

    public void setScale(double d2) {
        this.scale = d2;
    }

    public double getScale() {
        return this.scale;
    }

    public void setDeviceOrigin(Point point) {
        this.setDeviceOrigin(point.x, point.y);
    }

    public void setDeviceOrigin(int n, int n2) {
        this.deviceOriginX = n;
        this.deviceOriginY = n2;
    }

    public int getDeviceOriginX() {
        return this.deviceOriginX;
    }

    public int getDeviceOriginY() {
        return this.deviceOriginY;
    }

    public double toWorldCoordX(int n) {
        return (double)(n - this.deviceOriginX) / this.scale + this.positionX;
    }

    public double toWorldCoordY(int n) {
        return (double)(n - this.deviceOriginY) / this.scale + this.positionY;
    }

    public int toDeviceCoordX(double d2) {
        return this.deviceOriginX + (int)Math.round((d2 - this.positionX) * this.scale);
    }

    public int toDeviceCoordY(double d2) {
        return this.deviceOriginY + (int)Math.round((d2 - this.positionY) * this.scale);
    }

    public void transform(CGraphics2D cGraphics2D) {
        cGraphics2D.translate(this.deviceOriginX, this.deviceOriginY);
        cGraphics2D.scale(this.scale, this.scale);
        cGraphics2D.translate(-this.positionX, -this.positionY);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(string, object, object2);
        }
    }

    public void firePropertyChange(String string, boolean bl, boolean bl2) {
        if (this.changeSupport != null && bl != bl2) {
            this.changeSupport.firePropertyChange(string, (Object)bl, (Object)bl2);
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public PropertyChangeSupport getChangeSupport() {
        return this.changeSupport;
    }

    public void setChangeSupport(PropertyChangeSupport propertyChangeSupport) {
        this.changeSupport = propertyChangeSupport;
    }
}

