/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.draw;

import java.awt.geom.AffineTransform;
import net.astah.golf.draw.GOval;
import net.astah.golf.draw.GPolygon;
import net.astah.golf.draw.GPolyline;
import net.astah.golf.draw.GRimmedGeometry;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.util.AssertionFailError;
import net.astah.golf.util.Debug;
import net.astah.golf.widget.CColor;
import net.astah.golf.widget.swing.SwingColor;

public class GArrow
extends GPolyline {
    public static final int START = 0;
    public static final int END = 1;
    public static final int NONE = 0;
    public static final int LINES = 1;
    public static final int TRIANGLE = 2;
    public static final int RECTANGLE = 3;
    public static final int FILLED_RECTANGLE = 4;
    public static final int CIRCLE = 5;
    public static final int CROSS = 6;
    public static final int RECTANGLE_CROSS = 7;
    public static final int FILLED_RECTANGLE_CROSS = 8;
    public static final int VERTICAL = 9;
    public static final int VERTICAL_CIRCLE = 10;
    public static final int VERTICAL_FORK = 11;
    public static final int CIRCLE_FORK = 12;
    public static final int FILLED_CIRCLE = 13;
    public static final int FILLED_TRIANGLE = 14;
    public static final int ARROW_WITH_LINE = 15;
    public static final int VERTICAL_WITH_LINE = 16;
    public static final int TRIANGLE_WITH_LINE = 17;
    public static final int ACUTE_TRIANGLE = 18;
    public static final int FILLED_ACUTE_TRIANGLE = 19;
    int startType = 0;
    int endType = 0;
    static final double ROOT2 = 1.4142135623730951;
    static final double ROOT3_2 = 0.8660254037844386;
    double arrowHeadLength = 12.0;
    static final double TRIANGLE_WIDTH = 13.0;
    static final double RECTANGLE_WIDTH = 10.0;
    static final double CIRCLE_WIDTH = 8.0;
    static final double CROSS_WIDTH = 10.0;
    static final double CROSS_OFFSET = 38.0;
    static final double VERTICAL_WIDTH = 14.0;
    static final double VERTICAL_OFFSET = 12.0;
    static final double VERTICAL_WITH_LINE_WIDTH = 8.0;
    static final double TRIANGLE_WITH_LINE_WIDTH = 8.0;
    static final double FORK_HEIGHT = 10.0;
    static final double ACUTE_TRIANGLE_HEIGHT = 11.0;
    static final double ACUTE_TRIANGLE_WIDTH = 9.0;
    private GRimmedGeometry[] startList;
    private GRimmedGeometry[] endList;

    public GArrow() {
    }

    public GArrow(Pnt2d[] pnt2dArray, int n, int n2) {
        super(pnt2dArray);
        this.setType(0, n);
        this.setType(1, n2);
    }

    private static Pnt2d getRotatedPnt(Pnt2d pnt2d, double d2, Pnt2d pnt2d2) {
        AffineTransform affineTransform = AffineTransform.getRotateInstance(d2, pnt2d.x, pnt2d.y);
        return (Pnt2d)affineTransform.transform(pnt2d2, pnt2d2);
    }

    private static Pnt2d[] getRotatedPnts(Pnt2d pnt2d, double d2, Pnt2d[] pnt2dArray) {
        AffineTransform affineTransform = AffineTransform.getRotateInstance(d2, pnt2d.x, pnt2d.y);
        affineTransform.transform(pnt2dArray, 0, pnt2dArray, 0, pnt2dArray.length);
        return pnt2dArray;
    }

    private static Pnt2d[] getTrianglePnts(Pnt2d pnt2d, double d2) {
        Pnt2d[] pnt2dArray = GArrow.getTrianglePnts(pnt2d);
        return GArrow.getRotatedPnts(pnt2d, d2, pnt2dArray);
    }

    private static Pnt2d[] getVerticalPnts(Pnt2d pnt2d, double d2) {
        Pnt2d[] pnt2dArray = GArrow.getVerticalPnts(pnt2d);
        return GArrow.getRotatedPnts(pnt2d, d2, pnt2dArray);
    }

    private static Pnt2d[] getVerticalPnts(Pnt2d pnt2d) {
        return new Pnt2d[]{new Pnt2d(pnt2d.x + 14.0, pnt2d.y + 7.0), new Pnt2d(pnt2d.x + 14.0, pnt2d.y - 7.0)};
    }

    private static Pnt2d[] getTrianglePnts(Pnt2d pnt2d) {
        return new Pnt2d[]{new Pnt2d(pnt2d.x, pnt2d.y), new Pnt2d(pnt2d.x + 11.258330249197702, pnt2d.y + 6.5), new Pnt2d(pnt2d.x + 11.258330249197702, pnt2d.y - 6.5)};
    }

    private static Pnt2d[] getRectPnts(Pnt2d pnt2d, double d2) {
        Pnt2d[] pnt2dArray = GArrow.getRectPnts(pnt2d);
        return GArrow.getRotatedPnts(pnt2d, d2, pnt2dArray);
    }

    private static Pnt2d[] getRectPnts(Pnt2d pnt2d) {
        double d2 = 7.071067811865475;
        return new Pnt2d[]{new Pnt2d(pnt2d.x, pnt2d.y), new Pnt2d(pnt2d.x + d2, pnt2d.y + d2 / 1.5), new Pnt2d(pnt2d.x + 14.142135623730951, pnt2d.y), new Pnt2d(pnt2d.x + d2, pnt2d.y - d2 / 1.5)};
    }

    private static Pnt2d[] getAcuteTrianglePnts(Pnt2d pnt2d, double d2) {
        Pnt2d[] pnt2dArray = GArrow.getAcuteTrianglePnts(pnt2d);
        return GArrow.getRotatedPnts(pnt2d, d2, pnt2dArray);
    }

    private static Pnt2d[] getAcuteTrianglePnts(Pnt2d pnt2d) {
        return new Pnt2d[]{new Pnt2d(pnt2d.x, pnt2d.y), new Pnt2d(pnt2d.x + 11.0, pnt2d.y + 4.5), new Pnt2d(pnt2d.x + 11.0, pnt2d.y - 4.5)};
    }

    public void setType(int n, int n2) {
        if (n == 0) {
            this.setStartType(n, n2);
            return;
        }
        if (n == 1) {
            this.setEndType(n, n2);
            return;
        }
        Debug.impossible();
    }

    public void setEndType(int n, int n2) throws AssertionFailError {
        this.endType = n2;
        if (this.points.length > 1) {
            if (this.endList != null) {
                this.removeNodes(this.endList);
            }
            this.setupHead(n, n2);
            if (this.endList != null) {
                this.addNodes(this.endList);
            }
        }
    }

    public void setStartType(int n, int n2) throws AssertionFailError {
        this.startType = n2;
        if (this.points.length > 1) {
            if (this.startList != null) {
                this.removeNodes(this.startList);
            }
            this.setupHead(n, n2);
            if (this.startList != null) {
                this.addNodes(this.startList);
            }
        }
    }

    private void setupHead(int n, int n2) throws AssertionFailError {
        switch (n2) {
            case 0: {
                if (n == 0) {
                    this.startList = null;
                    break;
                }
                this.endList = null;
                break;
            }
            case 1: {
                this.setupHead(n, this.getLineHead(n));
                break;
            }
            case 2: {
                this.setupHead(n, this.getTriangleHead(n, false));
                break;
            }
            case 14: {
                this.setupHead(n, this.getTriangleHead(n, true));
                break;
            }
            case 3: {
                this.setupHead(n, this.getRectangleHead(n, false));
                break;
            }
            case 4: {
                this.setupHead(n, this.getRectangleHead(n, true));
                break;
            }
            case 5: {
                this.setupHead(n, this.getCircleHead(n, false));
                break;
            }
            case 6: {
                this.setupHead(n, this.getCrossHead(n));
                break;
            }
            case 7: {
                GRimmedGeometry[] gRimmedGeometryArray = this.getRectangleHead(n, false);
                GRimmedGeometry[] gRimmedGeometryArray2 = this.getCrossHead(n);
                this.setupHead(n, this.getGRimmedGeometrys(gRimmedGeometryArray, gRimmedGeometryArray2));
                break;
            }
            case 8: {
                GRimmedGeometry[] gRimmedGeometryArray = this.getRectangleHead(n, true);
                GRimmedGeometry[] gRimmedGeometryArray3 = this.getCrossHead(n);
                this.setupHead(n, this.getGRimmedGeometrys(gRimmedGeometryArray, gRimmedGeometryArray3));
                break;
            }
            case 9: {
                this.setupHead(n, this.getVerticalHead(n));
                break;
            }
            case 10: {
                this.setupHead(n, this.getVerticalCircleHead(n));
                break;
            }
            case 11: {
                this.setupHead(n, this.getVerticalForkHead(n));
                break;
            }
            case 12: {
                this.setupHead(n, this.getCircleForkHead(n));
                break;
            }
            case 13: {
                this.setupHead(n, this.getCircleHead(n, true));
                break;
            }
            case 15: {
                this.setupHead(n, this.getArrowWithLineHead(n, true));
                break;
            }
            case 18: {
                this.setupHead(n, this.getAcuteTriangleHead(n, false));
                break;
            }
            case 19: {
                this.setupHead(n, this.getAcuteTriangleHead(n, true));
                break;
            }
            case 16: {
                this.setupHead(n, this.getVerticalWithLineHead(n, true));
                break;
            }
            case 17: {
                this.setupHead(n, this.getTriangleWithLineHead(n, true));
                break;
            }
            default: {
                Debug.impossible();
            }
        }
    }

    private GRimmedGeometry[] getVerticalHead(int n) {
        double d2 = this.getAngle(n);
        Pnt2d pnt2d = this.getAnchorPoint(n);
        Pnt2d[] pnt2dArray = GArrow.getVerticalPnts(pnt2d, d2);
        GPolyline gPolyline = new GPolyline(pnt2dArray);
        this.setSameProperties(gPolyline);
        Pnt2d pnt2d2 = this.getOffSetPoint(n, 14.0);
        Pnt2d[] pnt2dArray2 = new Pnt2d[]{pnt2d, pnt2d2};
        GPolyline gPolyline2 = new GPolyline(pnt2dArray2);
        this.setSameProperties(gPolyline2);
        return new GRimmedGeometry[]{gPolyline, gPolyline2};
    }

    private GRimmedGeometry[] getVerticalCircleHead(int n) {
        double d2 = this.getAngle(n);
        Pnt2d pnt2d = this.getAnchorPoint(n);
        Pnt2d[] pnt2dArray = GArrow.getVerticalPnts(pnt2d, d2);
        GPolyline gPolyline = new GPolyline(pnt2dArray);
        this.setSameProperties(gPolyline);
        Pnt2d pnt2d2 = this.getCenter(n, 14.0);
        GOval gOval = new GOval(pnt2d2.x - 4.0, pnt2d2.y - 4.0, 8.0, 8.0);
        this.setSameProperties(gOval);
        this.trimEndPoint(n, 22.0);
        Pnt2d pnt2d3 = this.getOffSetPoint(n, 14.0);
        Pnt2d[] pnt2dArray2 = new Pnt2d[]{pnt2d, pnt2d3};
        GPolyline gPolyline2 = new GPolyline(pnt2dArray2);
        this.setSameProperties(gPolyline2);
        return new GRimmedGeometry[]{gPolyline, gOval, gPolyline2};
    }

    private GRimmedGeometry[] getVerticalForkHead(int n) {
        double d2 = this.getAngle(n);
        Pnt2d pnt2d = this.getAnchorPoint(n);
        Pnt2d[] pnt2dArray = GArrow.getVerticalPnts(pnt2d, d2);
        GPolyline gPolyline = new GPolyline(pnt2dArray);
        this.setSameProperties(gPolyline);
        GPolyline[] gPolylineArray = this.getForkLines(pnt2d, d2, n);
        this.setSameProperties(gPolylineArray[0]);
        this.setSameProperties(gPolylineArray[1]);
        this.setSameProperties(gPolylineArray[2]);
        return new GRimmedGeometry[]{gPolyline, gPolylineArray[0], gPolylineArray[1], gPolylineArray[2]};
    }

    private GPolyline[] getForkLines(Pnt2d pnt2d, double d2, int n) {
        Pnt2d[] pnt2dArray = new Pnt2d[]{new Pnt2d(pnt2d.x, pnt2d.y + 5.0), new Pnt2d(pnt2d.x, pnt2d.y - 5.0)};
        Pnt2d[] pnt2dArray2 = GArrow.getRotatedPnts(pnt2d, d2, pnt2dArray);
        Pnt2d pnt2d2 = this.getOffSetPoint(n, 14.0);
        Pnt2d[] pnt2dArray3 = new Pnt2d[]{pnt2d2, pnt2dArray2[0]};
        GPolyline gPolyline = new GPolyline(pnt2dArray3);
        Pnt2d pnt2d3 = this.getOffSetPoint(n, 14.0);
        Pnt2d[] pnt2dArray4 = new Pnt2d[]{pnt2d, pnt2d3};
        GPolyline gPolyline2 = new GPolyline(pnt2dArray4);
        Pnt2d[] pnt2dArray5 = new Pnt2d[]{pnt2d2, pnt2dArray2[1]};
        GPolyline gPolyline3 = new GPolyline(pnt2dArray5);
        GPolyline[] gPolylineArray = new GPolyline[]{gPolyline, gPolyline2, gPolyline3};
        return gPolylineArray;
    }

    private GRimmedGeometry[] getCircleForkHead(int n) {
        double d2 = this.getAngle(n);
        Pnt2d pnt2d = this.getAnchorPoint(n);
        Pnt2d pnt2d2 = this.getCenter(n, 14.0);
        GOval gOval = new GOval(pnt2d2.x - 4.0, pnt2d2.y - 4.0, 8.0, 8.0);
        this.setSameProperties(gOval);
        this.trimEndPoint(n, 22.0);
        GPolyline[] gPolylineArray = this.getForkLines(pnt2d, d2, n);
        this.setSameProperties(gPolylineArray[0]);
        this.setSameProperties(gPolylineArray[1]);
        this.setSameProperties(gPolylineArray[2]);
        return new GRimmedGeometry[]{gOval, gPolylineArray[0], gPolylineArray[1], gPolylineArray[2]};
    }

    private GRimmedGeometry[] getGRimmedGeometrys(GRimmedGeometry[] gRimmedGeometryArray, GRimmedGeometry[] gRimmedGeometryArray2) {
        int n;
        GRimmedGeometry[] gRimmedGeometryArray3 = new GRimmedGeometry[gRimmedGeometryArray.length + gRimmedGeometryArray2.length];
        for (n = 0; n < gRimmedGeometryArray.length; ++n) {
            gRimmedGeometryArray3[n] = gRimmedGeometryArray[n];
        }
        for (n = 0; n < gRimmedGeometryArray2.length; ++n) {
            gRimmedGeometryArray3[gRimmedGeometryArray.length + n] = gRimmedGeometryArray2[n];
        }
        return gRimmedGeometryArray3;
    }

    private void setupHead(int n, GRimmedGeometry[] gRimmedGeometryArray) {
        if (n == 0) {
            this.startList = gRimmedGeometryArray;
        } else {
            this.endList = gRimmedGeometryArray;
        }
    }

    private GRimmedGeometry[] getCircleHead(int n, boolean bl) {
        Pnt2d pnt2d = this.getCenter(n, 0.0);
        GOval gOval = new GOval(pnt2d.x - 4.0, pnt2d.y - 4.0, 8.0, 8.0);
        if (bl) {
            gOval.setFilled(true);
            if (this.foregroundColor != null) {
                gOval.setBackgroundColor(new SwingColor(this.foregroundColor));
            } else {
                gOval.setBackgroundNo(this.colorNo);
            }
        }
        this.setSameProperties(gOval);
        this.trimEndPoint(n, 8.0);
        return new GRimmedGeometry[]{gOval};
    }

    private GRimmedGeometry[] getArrowWithLineHead(int n, boolean bl) {
        double d2 = this.getAngle(n);
        Pnt2d pnt2d = this.getAnchorPoint(n);
        Pnt2d pnt2d2 = new Pnt2d(pnt2d.x + this.arrowHeadLength, pnt2d.y);
        GPolyline gPolyline = new GPolyline(new Pnt2d[]{new Pnt2d(pnt2d.x - 10.0, pnt2d.y), new Pnt2d(pnt2d.x + 10.0, pnt2d.y)});
        this.setSameProperties(gPolyline);
        Pnt2d pnt2d3 = GArrow.getRotatedPnt(pnt2d, d2 + 0.5235987755982988, new Pnt2d(pnt2d2));
        Pnt2d[] pnt2dArray = new Pnt2d[]{pnt2d, pnt2d3};
        GPolyline gPolyline2 = new GPolyline(pnt2dArray);
        this.setSameProperties(gPolyline2);
        Pnt2d pnt2d4 = GArrow.getRotatedPnt(pnt2d, d2 - 0.5235987755982988, pnt2d2);
        Pnt2d[] pnt2dArray2 = new Pnt2d[]{pnt2d, pnt2d4};
        GPolyline gPolyline3 = new GPolyline(pnt2dArray2);
        this.setSameProperties(gPolyline3);
        return new GRimmedGeometry[]{gPolyline, gPolyline2, gPolyline3};
    }

    private GRimmedGeometry[] getCrossHead(int n) {
        double d2 = this.getAngle(n);
        Pnt2d pnt2d = this.getCrossAnchorPoint(n, d2);
        Pnt2d pnt2d2 = new Pnt2d(pnt2d.x + 5.0, pnt2d.y);
        Pnt2d pnt2d3 = GArrow.getRotatedPnt(pnt2d, d2 + 0.7853981633974483, new Pnt2d(pnt2d2));
        Pnt2d pnt2d4 = GArrow.getRotatedPnt(pnt2d, d2 - 0.7853981633974483, new Pnt2d(pnt2d2));
        Pnt2d pnt2d5 = this.getSymmetricalPoint(pnt2d3, pnt2d);
        Pnt2d pnt2d6 = this.getSymmetricalPoint(pnt2d4, pnt2d);
        Pnt2d[] pnt2dArray = new Pnt2d[]{pnt2d5, pnt2d3};
        GPolyline gPolyline = new GPolyline(pnt2dArray);
        this.setSameProperties(gPolyline);
        Pnt2d[] pnt2dArray2 = new Pnt2d[]{pnt2d6, pnt2d4};
        GPolyline gPolyline2 = new GPolyline(pnt2dArray2);
        this.setSameProperties(gPolyline2);
        return new GRimmedGeometry[]{gPolyline, gPolyline2};
    }

    private Pnt2d getSymmetricalPoint(Pnt2d pnt2d, Pnt2d pnt2d2) {
        return new Pnt2d(pnt2d2.x * 2.0 - pnt2d.x, pnt2d2.y * 2.0 - pnt2d.y);
    }

    private GRimmedGeometry[] getRectangleHead(int n, boolean bl) {
        double d2 = this.getAngle(n);
        Pnt2d pnt2d = this.getAnchorPoint(n);
        Pnt2d[] pnt2dArray = GArrow.getRectPnts(pnt2d, d2);
        GPolygon gPolygon = new GPolygon(pnt2dArray);
        gPolygon.setFilled(true);
        if (this.foregroundColor != null) {
            gPolygon.setForegroundColor(new SwingColor(this.foregroundColor));
            if (bl) {
                gPolygon.setBackgroundColor(new SwingColor(this.foregroundColor));
            } else {
                gPolygon.setBackgroundNo(this.backgroundNo);
            }
        } else if (bl) {
            gPolygon.setBackgroundNo(this.colorNo);
        } else {
            gPolygon.setBackgroundNo(this.backgroundNo);
        }
        this.setSameProperties(gPolygon);
        this.trimEndPoint(n, 14.142135623730951);
        return new GPolygon[]{gPolygon};
    }

    private GRimmedGeometry[] getTriangleHead(int n, boolean bl) {
        double d2 = this.getAngle(n);
        Pnt2d pnt2d = this.getAnchorPoint(n);
        Pnt2d[] pnt2dArray = GArrow.getTrianglePnts(pnt2d, d2);
        GPolygon gPolygon = new GPolygon(pnt2dArray);
        gPolygon.setFilled(true);
        if (this.foregroundColor != null) {
            gPolygon.setForegroundColor(new SwingColor(this.foregroundColor));
            if (bl) {
                gPolygon.setBackgroundColor(new SwingColor(this.foregroundColor));
            } else {
                gPolygon.setBackgroundNo(this.backgroundNo);
            }
        } else if (bl) {
            gPolygon.setBackgroundNo(this.colorNo);
        } else {
            gPolygon.setBackgroundNo(this.backgroundNo);
        }
        this.setSameProperties(gPolygon);
        this.trimEndPoint(n, 11.258330249197702);
        return new GPolygon[]{gPolygon};
    }

    private GRimmedGeometry[] getLineHead(int n) {
        double d2 = this.getAngle(n);
        Pnt2d pnt2d = this.getAnchorPoint(n);
        Pnt2d pnt2d2 = new Pnt2d(pnt2d.x + this.arrowHeadLength, pnt2d.y);
        Pnt2d pnt2d3 = GArrow.getRotatedPnt(pnt2d, d2 + 0.5235987755982988, new Pnt2d(pnt2d2));
        Pnt2d[] pnt2dArray = new Pnt2d[]{pnt2d, pnt2d3};
        GPolyline gPolyline = new GPolyline(pnt2dArray);
        this.setSameProperties(gPolyline);
        Pnt2d pnt2d4 = GArrow.getRotatedPnt(pnt2d, d2 - 0.5235987755982988, pnt2d2);
        Pnt2d[] pnt2dArray2 = new Pnt2d[]{pnt2d, pnt2d4};
        GPolyline gPolyline2 = new GPolyline(pnt2dArray2);
        this.setSameProperties(gPolyline2);
        return new GRimmedGeometry[]{gPolyline, gPolyline2};
    }

    private GRimmedGeometry[] getAcuteTriangleHead(int n, boolean bl) {
        double d2 = this.getAcuteAngle(n);
        Pnt2d pnt2d = this.getAnchorPoint(n);
        Pnt2d[] pnt2dArray = GArrow.getAcuteTrianglePnts(pnt2d, d2);
        GPolygon gPolygon = new GPolygon(pnt2dArray);
        gPolygon.setFilled(true);
        if (this.foregroundColor != null) {
            gPolygon.setForegroundColor(new SwingColor(this.foregroundColor));
            if (bl) {
                gPolygon.setBackgroundColor(new SwingColor(this.foregroundColor));
            } else {
                gPolygon.setBackgroundNo(this.backgroundNo);
            }
        } else if (bl) {
            gPolygon.setBackgroundNo(this.colorNo);
        } else {
            gPolygon.setBackgroundNo(this.backgroundNo);
        }
        this.setSameProperties(gPolygon);
        this.trimEndPoint(n, 9.0);
        return new GPolygon[]{gPolygon};
    }

    private Pnt2d getAnchorPoint(int n) {
        Pnt2d pnt2d = n == 0 ? this.points[0] : this.points[this.points.length - 1];
        return pnt2d;
    }

    private Pnt2d getCrossAnchorPoint(int n, double d2) {
        Pnt2d pnt2d = n == 0 ? this.getCrossPoint(this.points[0], d2) : this.getCrossPoint(this.points[this.points.length - 1], d2);
        return pnt2d;
    }

    private Pnt2d getCrossPoint(Pnt2d pnt2d, double d2) {
        return new Pnt2d(pnt2d.x + 19.0 * Math.cos(d2), pnt2d.y + 19.0 * Math.sin(d2));
    }

    private void setSameProperties(GRimmedGeometry gRimmedGeometry) {
        gRimmedGeometry.setRimWidth(this.rimWidth);
        gRimmedGeometry.setSelectable(false);
        if (this.foregroundColor != null) {
            gRimmedGeometry.setForegroundColor(new SwingColor(this.foregroundColor));
        } else {
            gRimmedGeometry.setColorNo(this.colorNo);
        }
        gRimmedGeometry.setIntensity(this.intensity);
        gRimmedGeometry.setAlpha(this.alpha);
        gRimmedGeometry.setDepth(this.depth);
    }

    double getAngle(int n) {
        double d2 = 0.0;
        if (this.points.length >= 2) {
            Pnt2d pnt2d = null;
            Pnt2d pnt2d2 = null;
            if (n == 0) {
                pnt2d = this.points[0];
                pnt2d2 = this.points[1];
            } else {
                pnt2d = this.points[this.points.length - 1];
                pnt2d2 = this.points[this.points.length - 2];
            }
            if (pnt2d.distanceSq(pnt2d2) >= 1.0E-9) {
                d2 = pnt2d.angle(pnt2d2);
            }
        }
        return d2;
    }

    double getAcuteAngle(int n) {
        return this.getAngle(n);
    }

    void trimEndPoint(int n, double d2) {
        Pnt2d pnt2d = new Pnt2d();
        switch (n) {
            case 0: {
                if (this.points[0].distance(this.points[1]) == 0.0) {
                    pnt2d.interpolate(this.points[0], this.points[1], 1.0);
                } else {
                    pnt2d.interpolate(this.points[0], this.points[1], d2 / this.points[0].distance(this.points[1]));
                }
                this.line2ds[0].setLine(pnt2d.x, pnt2d.y, this.line2ds[0].x2, this.line2ds[0].y2);
                return;
            }
            case 1: {
                pnt2d.interpolate(this.points[this.points.length - 1], this.points[this.points.length - 2], d2 / this.points[this.points.length - 1].distance(this.points[this.points.length - 2]));
                this.line2ds[this.points.length - 2].setLine(this.line2ds[this.points.length - 2].x1, this.line2ds[this.points.length - 2].y1, pnt2d.x, pnt2d.y);
                return;
            }
        }
        Debug.impossible();
    }

    Pnt2d getCenter(int n, double d2) {
        Pnt2d pnt2d = new Pnt2d();
        switch (n) {
            case 0: {
                pnt2d.interpolate(this.points[0], this.points[1], (8.0 + 2.0 * d2) / 2.0 / this.points[0].distance(this.points[1]));
                return pnt2d;
            }
            case 1: {
                pnt2d.interpolate(this.points[this.points.length - 1], this.points[this.points.length - 2], (8.0 + 2.0 * d2) / 2.0 / this.points[this.points.length - 1].distance(this.points[this.points.length - 2]));
                return pnt2d;
            }
        }
        Debug.impossible();
        return null;
    }

    Pnt2d getOffSetPoint(int n, double d2) {
        Pnt2d pnt2d = new Pnt2d();
        switch (n) {
            case 0: {
                pnt2d.interpolate(this.points[0], this.points[1], d2 / this.points[0].distance(this.points[1]));
                return pnt2d;
            }
            case 1: {
                pnt2d.interpolate(this.points[this.points.length - 1], this.points[this.points.length - 2], d2 / this.points[this.points.length - 1].distance(this.points[this.points.length - 2]));
                return pnt2d;
            }
        }
        Debug.impossible();
        return null;
    }

    public int getType(int n) {
        return n == 0 ? this.startType : this.endType;
    }

    @Override
    public void setPoints(Pnt2d[] pnt2dArray) {
        super.setPoints(pnt2dArray);
        this.setType(0, this.startType);
        this.setType(1, this.endType);
    }

    @Override
    public void setRimWidth(int n) {
        int n2;
        super.setRimWidth(n);
        if (this.startList != null) {
            for (n2 = 0; n2 < this.startList.length; ++n2) {
                this.startList[n2].setRimWidth(n);
            }
        }
        if (this.endList != null) {
            for (n2 = 0; n2 < this.endList.length; ++n2) {
                this.endList[n2].setRimWidth(n);
            }
        }
    }

    @Override
    public void setColorNo(byte by) {
        super.setColorNo(by);
        this.setStartColor(by);
        this.setEndColor(by);
    }

    private void setEndColor(byte by) {
        if (this.endList != null) {
            for (int k = 0; k < this.endList.length; ++k) {
                this.endList[k].setColorNo(by);
            }
            if (this.endType == 4 || this.endType == 8 || this.endType == 13 || this.endType == 14 || this.endType == 19) {
                this.endList[0].setBackgroundNo(by);
            }
        }
    }

    private void setStartColor(byte by) {
        if (this.startList != null) {
            for (int k = 0; k < this.startList.length; ++k) {
                this.startList[k].setColorNo(by);
            }
            if (this.startType == 4 || this.startType == 8 || this.startType == 13 || this.startType == 14 || this.startType == 19) {
                this.startList[0].setBackgroundNo(by);
            }
        }
    }

    @Override
    public void setForegroundColor(CColor cColor) {
        this.foregroundColor = cColor.transferToAWTColor();
        this.setStartColor(cColor);
        this.setEndColor(cColor);
    }

    @Override
    public void setShadowColorNo(byte by) {
        int n;
        super.setShadowColorNo(by);
        if (this.startList != null) {
            for (n = 0; n < this.startList.length; ++n) {
                this.startList[n].setShadowColorNo(by);
            }
        }
        if (this.endList != null) {
            for (n = 0; n < this.endList.length; ++n) {
                this.endList[n].setShadowColorNo(by);
            }
        }
    }

    private void setEndColor(CColor cColor) {
        if (this.endList != null) {
            for (int k = 0; k < this.endList.length; ++k) {
                this.endList[k].setForegroundColor(cColor);
            }
        }
    }

    private void setStartColor(CColor cColor) {
        if (this.startList != null) {
            for (int k = 0; k < this.startList.length; ++k) {
                this.startList[k].setForegroundColor(cColor);
            }
        }
    }

    @Override
    public void setIntensity(float f2) {
        int n;
        super.setIntensity(f2);
        if (this.startList != null) {
            for (n = 0; n < this.startList.length; ++n) {
                this.startList[n].setIntensity(f2);
            }
        }
        if (this.endList != null) {
            for (n = 0; n < this.endList.length; ++n) {
                this.endList[n].setIntensity(f2);
            }
        }
    }

    @Override
    public void setAlpha(float f2) {
        int n;
        super.setAlpha(f2);
        if (this.startList != null) {
            for (n = 0; n < this.startList.length; ++n) {
                this.startList[n].setAlpha(f2);
            }
        }
        if (this.endList != null) {
            for (n = 0; n < this.endList.length; ++n) {
                this.endList[n].setAlpha(f2);
            }
        }
    }

    @Override
    public void setDepth(int n) {
        int n2;
        super.setDepth(n);
        if (this.startList != null) {
            for (n2 = 0; n2 < this.startList.length; ++n2) {
                this.startList[n2].setDepth(n);
            }
        }
        if (this.endList != null) {
            for (n2 = 0; n2 < this.endList.length; ++n2) {
                this.endList[n2].setDepth(n);
            }
        }
    }

    @Override
    public GRimmedGeometry getShadow() {
        GArrow gArrow = new GArrow(this.points, this.startType, this.endType);
        gArrow.setRimWidth(this.rimWidth);
        return gArrow;
    }

    public void setArrowHeadLength(double d2) {
        this.arrowHeadLength = d2;
    }

    private GRimmedGeometry[] getVerticalWithLineHead(int n, boolean bl) {
        double d2 = this.getAngle(n);
        Pnt2d pnt2d = this.getAnchorPoint(n);
        Pnt2d[] pnt2dArray = this.getVerticalWithLinePnts(pnt2d, d2);
        GPolyline gPolyline = new GPolyline(pnt2dArray);
        this.setSameProperties(gPolyline);
        return new GRimmedGeometry[]{gPolyline};
    }

    private Pnt2d[] getVerticalWithLinePnts(Pnt2d pnt2d, double d2) {
        Pnt2d[] pnt2dArray = this.getVerticalWithLinePnts(pnt2d);
        return GArrow.getRotatedPnts(pnt2d, d2, pnt2dArray);
    }

    private Pnt2d[] getVerticalWithLinePnts(Pnt2d pnt2d) {
        return new Pnt2d[]{new Pnt2d(pnt2d.x, pnt2d.y + 4.0), new Pnt2d(pnt2d.x, pnt2d.y - 4.0)};
    }

    private GRimmedGeometry[] getTriangleWithLineHead(int n, boolean bl) {
        double d2 = this.getAngle(n);
        Pnt2d pnt2d = this.getAnchorPoint(n);
        Pnt2d[] pnt2dArray = this.getTriangleWithLinePnts(pnt2d, d2);
        GPolygon gPolygon = new GPolygon(pnt2dArray);
        gPolygon.setFilled(true);
        if (this.foregroundColor != null) {
            gPolygon.setForegroundColor(new SwingColor(this.foregroundColor));
            if (bl) {
                gPolygon.setBackgroundColor(new SwingColor(this.foregroundColor));
            } else {
                gPolygon.setBackgroundNo(this.backgroundNo);
            }
        } else if (bl) {
            gPolygon.setBackgroundNo(this.colorNo);
        } else {
            gPolygon.setBackgroundNo(this.backgroundNo);
        }
        this.setSameProperties(gPolygon);
        this.trimEndPoint(n, 6.928203230275509);
        return new GPolygon[]{gPolygon};
    }

    private Pnt2d[] getTriangleWithLinePnts(Pnt2d pnt2d, double d2) {
        Pnt2d[] pnt2dArray = this.getTriangleWithLinePnts(pnt2d);
        return GArrow.getRotatedPnts(pnt2d, d2, pnt2dArray);
    }

    private Pnt2d[] getTriangleWithLinePnts(Pnt2d pnt2d) {
        return new Pnt2d[]{new Pnt2d(pnt2d.x, pnt2d.y), new Pnt2d(pnt2d.x + 6.928203230275509, pnt2d.y + 4.0), new Pnt2d(pnt2d.x + 6.928203230275509, pnt2d.y - 4.0)};
    }
}

