/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.draw;

import java.awt.Shape;
import net.astah.golf.draw.GGraphics;
import net.astah.golf.draw.GRimmedGeometry;
import net.astah.golf.geom2D.Arc2d;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.geom2D.Rectangle2d;

public class GArc
extends GRimmedGeometry {
    Arc2d arc2d;
    private Pnt2d[] knobPoints;

    public GArc() {
        this(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0);
        this.arc2d = new Arc2d();
    }

    public GArc(double d2, double d3, double d4, double d5, double d6, double d7, int n) {
        super.setPoint(d2, d3);
        this.setType(n);
        this.arc2d = new Arc2d(d2, d3, d4, d5, d6, d7, n);
    }

    public void setExtent(double d2) {
        this.arc2d.extent = d2;
        this.moveKnobAndShadow();
    }

    public void setStart(double d2) {
        this.arc2d.start = d2;
        this.moveKnobAndShadow();
    }

    @Override
    public void setPoint(double d2, double d3) {
        super.setPoint(d2, d3);
        this.arc2d.setFrame(d2, d3, this.getWidth(), this.getHeight());
    }

    public double getExtent() {
        return this.arc2d.extent;
    }

    public double getStart() {
        return this.arc2d.start;
    }

    public void setWidth(double d2) {
        this.arc2d.width = d2;
        this.moveKnobAndShadow();
    }

    public void setHeight(double d2) {
        this.arc2d.height = d2;
        this.moveKnobAndShadow();
    }

    public double getWidth() {
        return this.arc2d.width;
    }

    public double getHeight() {
        return this.arc2d.height;
    }

    @Override
    public int getNoShapes() {
        return 1;
    }

    @Override
    public Shape getShape(int n) {
        return this.arc2d;
    }

    @Override
    public Pnt2d[] getKnobPoints() {
        if (this.knobPoints == null) {
            this.knobPoints = new Pnt2d[4];
            this.knobPoints[0] = new Pnt2d();
            this.knobPoints[1] = new Pnt2d();
            this.knobPoints[2] = new Pnt2d();
            this.knobPoints[3] = new Pnt2d();
        }
        double d2 = this.getWidth();
        double d3 = this.getHeight();
        this.knobPoints[0].set(this.x, this.y);
        this.knobPoints[1].set(this.x, this.y + d3);
        this.knobPoints[2].set(this.x + d2, this.y + d3);
        this.knobPoints[3].set(this.x + d2, this.y);
        return this.knobPoints;
    }

    @Override
    public int getDiagonalLength(GGraphics gGraphics) {
        double d2 = this.getWidth();
        double d3 = this.getHeight();
        return (int)Math.round(Math.sqrt(d2 * d2 + d3 * d3) * gGraphics.camera.scale);
    }

    @Override
    public GRimmedGeometry getShadow() {
        GArc gArc = new GArc(this.x, this.y, this.getWidth(), this.getHeight(), this.getStart(), this.getExtent(), 0);
        gArc.setRimWidth(this.rimWidth);
        return gArc;
    }

    @Override
    public boolean intersect(Rectangle2d rectangle2d) {
        if (this == null) {
            return false;
        }
        boolean bl = this.isRimmedPick();
        if (bl) {
            double d2 = this.getX();
            double d3 = this.getY();
            double d4 = this.getX() + this.getWidth();
            double d5 = this.getY() + this.getHeight();
            if (rectangle2d.intersectsLine(d2, d3, d2, d5)) {
                return true;
            }
            if (rectangle2d.intersectsLine(d2, d5, d4, d5)) {
                return true;
            }
            if (rectangle2d.intersectsLine(d4, d3, d4, d5)) {
                return true;
            }
            return rectangle2d.intersectsLine(d2, d3, d4, d3);
        }
        Rectangle2d rectangle2d2 = new Rectangle2d(this.x, this.y, this.getWidth(), this.getHeight());
        return rectangle2d.intersects(rectangle2d2);
    }
}

