/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.control;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JTable;
import javax.swing.SwingUtilities;

public class TableCellListener
implements PropertyChangeListener,
Runnable {
    private JTable table;
    private int row;
    private int column;
    private Object oldValue;
    private Object newValue;

    public TableCellListener(JTable jTable) {
        this.table = jTable;
    }

    public int getColumn() {
        return this.column;
    }

    public Object getNewValue() {
        return this.newValue;
    }

    public Object getOldValue() {
        return this.oldValue;
    }

    public int getRow() {
        return this.row;
    }

    public JTable getTable() {
        return this.table;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("tableCellEditor".equals(propertyChangeEvent.getPropertyName()) && this.table.isEditing()) {
            this.processEditingStarted();
        }
    }

    private void processEditingStarted() {
        SwingUtilities.invokeLater(this);
    }

    @Override
    public void run() {
        if (!this.table.isEditing()) {
            return;
        }
        int n = this.table.getEditingRow();
        int n2 = this.table.getEditingColumn();
        this.row = this.table.convertRowIndexToModel(n);
        this.column = this.table.convertColumnIndexToModel(n2);
        this.oldValue = this.table.getModel().getValueAt(this.row, this.column);
        this.newValue = null;
    }
}

