/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.control;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.List;
import net.astah.golf.control.Command;
import net.astah.golf.control.CommandEvent;
import net.astah.golf.control.CommandListener;
import net.astah.golf.control.CommandManager;
import net.astah.golf.view.UIView;
import net.astah.golf.widget.CCursor;
import proguard.annotation.Keep;
import proguard.annotation.KeepImplementations;

@Keep
@KeepImplementations
public class Mode
implements KeyListener,
MouseListener,
MouseMotionListener,
MouseWheelListener {
    protected static final int ROLL_FACTOR = 20;
    protected static final int AUTOSCROLL_FACTOR = 1;
    private static List commandListeners = new ArrayList(1);
    protected CCursor cursor = null;
    protected UIView view = null;

    public Mode() {
        if (commandListeners.size() < 1) {
            commandListeners.add(CommandManager.instance());
        }
    }

    public void setView(UIView uIView) {
        this.view = uIView;
    }

    public CCursor getCursor() {
        return this.cursor;
    }

    public void addCommandListener(CommandListener commandListener) {
        commandListeners.add(commandListener);
    }

    public void removeCommandListener(CommandListener commandListener) {
        commandListeners.remove(commandListener);
    }

    public void fireCommandPerformed(CommandEvent commandEvent) {
        for (CommandListener commandListener : commandListeners) {
            commandListener.commandPerformed(commandEvent);
        }
    }

    public void fireCommandPerformed(Command command, String string, MouseEvent mouseEvent) {
        this.fireCommandPerformed(new CommandEvent(mouseEvent.getSource(), mouseEvent.getID(), string, command, mouseEvent.getModifiers()));
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
    }

    public void remove() {
    }
}

