/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.control;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.event.EventListenerList;
import net.astah.golf.control.CommandEvent;
import net.astah.golf.control.CommandListener;
import net.astah.golf.control.CommandManager;

public class KeyActionListener
implements KeyListener {
    protected static final EventListenerList listenerList = new EventListenerList();
    protected int runType = 1;
    private String actionName = null;
    protected boolean enabled = true;

    public KeyActionListener(String string) {
        this(string, 1);
    }

    public KeyActionListener(String string, int n) {
        this.setActionName(string);
        if (listenerList.getListenerCount() < 1) {
            this.addCommandListener(CommandManager.instance());
        }
        this.runType = n;
    }

    protected String getActionName() {
        return this.actionName;
    }

    protected void setActionName(String string) {
        this.actionName = string;
    }

    public void setRunType(int n) {
        this.runType = n;
    }

    public void addCommandListener(CommandListener commandListener) {
        listenerList.add(CommandListener.class, commandListener);
    }

    public void removeCommandListener(CommandListener commandListener) {
        listenerList.remove(CommandListener.class, commandListener);
    }

    public void actionPerformed(KeyEvent keyEvent) {
        if (!this.isEnabled()) {
            return;
        }
        this.fireCommandPerformed(new CommandEvent(keyEvent.getSource(), keyEvent.getID(), this.actionName, keyEvent.getModifiers(), this.runType));
    }

    protected void fireCommandPerformed(CommandEvent commandEvent) {
        Object[] objectArray = listenerList.getListenerList();
        for (int k = objectArray.length - 2; k >= 0; k -= 2) {
            if (objectArray[k] != CommandListener.class) continue;
            ((CommandListener)objectArray[k + 1]).commandPerformed(commandEvent);
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.actionPerformed(keyEvent);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }
}

