/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.control;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.event.EventListenerList;
import net.astah.golf.control.CommandEvent;
import net.astah.golf.control.CommandListener;
import net.astah.golf.control.CommandManager;

public class GolfAction
extends AbstractAction {
    private String actionName = "";
    private static final long serialVersionUID = -2467726829188297258L;
    protected static final EventListenerList listenerList = new EventListenerList();
    protected int runType = 1;
    private List changeListeners;

    public GolfAction(String string) {
        this(string, 1);
    }

    public GolfAction(String string, String string2) {
        this(string, string2, 1);
    }

    public GolfAction(String string, int n) {
        this(string, string, n);
    }

    public GolfAction(String string, String string2, int n) {
        super(string2);
        this.setEnabled(true);
        if (listenerList.getListenerCount() < 1) {
            this.addCommandListener(CommandManager.instance());
        }
        this.actionName = string;
        this.runType = n;
    }

    public void setRunType(int n) {
        this.runType = n;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.isEnabled()) {
            return;
        }
        this.fireCommandPerformed(new CommandEvent(actionEvent.getSource(), actionEvent.getID(), (String)this.getValue("Name"), actionEvent.getModifiers(), this.runType));
    }

    protected void fireCommandPerformed(CommandEvent commandEvent) {
        Object[] objectArray = listenerList.getListenerList();
        for (int k = objectArray.length - 2; k >= 0; k -= 2) {
            if (objectArray[k] != CommandListener.class) continue;
            ((CommandListener)objectArray[k + 1]).commandPerformed(commandEvent);
        }
    }

    public void addCommandListener(CommandListener commandListener) {
        listenerList.add(CommandListener.class, commandListener);
    }

    public void removeCommandListener(CommandListener commandListener) {
        listenerList.remove(CommandListener.class, commandListener);
    }

    public String toString() {
        return "[NEME=" + this.getValue("Name") + "]";
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(propertyChangeListener);
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList();
        }
        this.changeListeners.add(propertyChangeListener);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.removePropertyChangeListener(propertyChangeListener);
        if (this.changeListeners == null) {
            return;
        }
        this.changeListeners.remove(propertyChangeListener);
    }

    public PropertyChangeListener[] getPropertyChangeListenersArray() {
        if (this.changeListeners == null) {
            return null;
        }
        return this.changeListeners.toArray(new PropertyChangeListener[0]);
    }

    public void setActionCommand(String string) {
        super.putValue("Name", string);
    }

    public String getActionName() {
        return this.actionName;
    }

    public List getChangeListeners() {
        return this.changeListeners;
    }

    public void setChangeListeners(List list) {
        this.changeListeners = list;
    }
}

