/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.control;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComboBox;
import javax.swing.event.EventListenerList;
import javax.swing.text.JTextComponent;
import net.astah.golf.control.CommandEvent;
import net.astah.golf.control.CommandListener;
import net.astah.golf.control.CommandManager;

public class FocusActionListener
implements ActionListener,
FocusListener {
    protected static final EventListenerList listenerList = new EventListenerList();
    protected int runType = 1;
    protected boolean enabled = true;
    private String actionName = null;
    String oldText = null;

    public FocusActionListener(String string) {
        this(string, 1);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public FocusActionListener(String string, int n) {
        this.setActionName(string);
        if (listenerList.getListenerCount() < 1) {
            this.addCommandListener(CommandManager.instance());
        }
        this.runType = n;
    }

    protected String getActionName() {
        return this.actionName;
    }

    protected void setActionName(String string) {
        this.actionName = string;
    }

    public void setRunType(int n) {
        this.runType = n;
    }

    public void addCommandListener(CommandListener commandListener) {
        listenerList.add(CommandListener.class, commandListener);
    }

    public void removeCommandListener(CommandListener commandListener) {
        listenerList.remove(CommandListener.class, commandListener);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        JComboBox jComboBox;
        if (focusEvent.getComponent() instanceof JTextComponent) {
            JTextComponent jTextComponent = (JTextComponent)focusEvent.getComponent();
            this.oldText = jTextComponent.getText();
        } else if (focusEvent.getComponent() instanceof JComboBox && (jComboBox = (JComboBox)focusEvent.getComponent()).getSelectedItem() instanceof String) {
            this.oldText = (String)jComboBox.getSelectedItem();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getComponent() instanceof JTextComponent) {
            JTextComponent jTextComponent = (JTextComponent)focusEvent.getComponent();
            if (!jTextComponent.getText().equals(this.oldText)) {
                this.actionPerformed(focusEvent);
            }
        } else if (focusEvent.getComponent() instanceof JComboBox) {
            JComboBox jComboBox = (JComboBox)focusEvent.getComponent();
            if (jComboBox.getSelectedItem() instanceof String) {
                if (!jComboBox.getSelectedItem().equals(this.oldText)) {
                    this.actionPerformed(focusEvent);
                }
            } else {
                this.actionPerformed(focusEvent);
            }
        } else {
            this.actionPerformed(focusEvent);
        }
    }

    public void actionPerformed(FocusEvent focusEvent) {
        if (!this.isEnabled()) {
            return;
        }
        this.fireCommandPerformed(new CommandEvent(focusEvent.getSource(), focusEvent.getID(), this.actionName, -1, this.runType));
    }

    protected void fireCommandPerformed(CommandEvent commandEvent) {
        Object[] objectArray = listenerList.getListenerList();
        for (int k = objectArray.length - 2; k >= 0; k -= 2) {
            if (objectArray[k] != CommandListener.class) continue;
            ((CommandListener)objectArray[k + 1]).commandPerformed(commandEvent);
        }
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.fireCommandPerformed(new CommandEvent(actionEvent.getSource(), actionEvent.getID(), this.actionName, -1, this.runType));
    }

    public void actionPerformed() {
        this.fireCommandPerformed(new CommandEvent((Object)this, 1, this.actionName, -1, this.runType));
    }
}

