/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.control;

import java.util.concurrent.CopyOnWriteArrayList;
import lombok.NonNull;
import net.astah.golf.control.Command;
import net.astah.golf.control.CommandEvent;
import net.astah.golf.control.CommandExecutionListener;
import net.astah.jomt.jutil.ExecutorManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class CommandRunner
implements Runnable {
    protected Command command = null;
    protected CommandEvent commandEvent = null;
    protected boolean isScript;
    protected String scriptFile = null;
    protected Thread thread = null;
    protected Thread.UncaughtExceptionHandler handler;
    protected int runType = 0;
    public static final int RUN_TYPE_THREAD_SAME = 0;
    public static final int RUN_TYPE_THREAD_ANOTHER = 1;
    protected int runStatus = 0;
    public static final int COMMAND_NOT_RUNNING = 0;
    public static final int COMMAND_RUNNING = 1;
    private final CopyOnWriteArrayList<CommandExecutionListener> executionListeners = new CopyOnWriteArrayList();
    private static final Logger logger = LoggerFactory.getLogger(CommandRunner.class);
    private static final Marker marker = MarkerFactory.getMarker((String)"command");

    public CommandRunner(Command command) {
        this(command, Thread.currentThread().getUncaughtExceptionHandler());
    }

    public CommandRunner(Command command, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.command = command;
        this.handler = uncaughtExceptionHandler;
        this.isScript = false;
    }

    public String getCommandName() {
        if (this.isScript) {
            return this.scriptFile;
        }
        return this.command.getName();
    }

    @Override
    public void run() {
        if (this.command != null) {
            if (this.handler != null) {
                Thread.currentThread().setUncaughtExceptionHandler(this.handler);
            } else {
                logger.warn(marker, "UncaughtExceptionHandler has not been set", (Object)this.command);
            }
            try {
                logger.trace(marker, "start {}", (Object)this.command);
                this.command.start();
                logger.trace(marker, "end {}", (Object)this.command);
                this.fireCommandExecutionEvent();
            }
            catch (Throwable throwable) {
                if (this.shouldHandle(throwable)) {
                    this.fireCommandExecutionEvent(throwable);
                }
                throw throwable;
            }
        }
    }

    public void start() {
        if (this.runType == 1) {
            ExecutorManager.getExecutor().execute(this);
        } else {
            this.run();
        }
    }

    protected void lowerPriority(Thread thread) {
        int n = thread.getPriority() - 2;
        thread.setPriority(n > 1 ? n : 1);
    }

    public boolean isScript() {
        return this.isScript;
    }

    public void setRunType(int n) {
        this.runType = n;
    }

    public void setCommandEvent(CommandEvent commandEvent) {
        this.commandEvent = commandEvent;
        if (this.command != null) {
            this.command.setCommandEvent(this.commandEvent);
        }
    }

    public void addCommandExecutionListener(@NonNull CommandExecutionListener commandExecutionListener) {
        if (commandExecutionListener == null) {
            throw new NullPointerException("listener");
        }
        this.executionListeners.addIfAbsent(commandExecutionListener);
    }

    public void removeCommandExecutionListener(CommandExecutionListener commandExecutionListener) {
        this.executionListeners.remove(commandExecutionListener);
    }

    protected boolean shouldHandle(Throwable throwable) {
        return throwable instanceof RuntimeException;
    }

    private void fireCommandExecutionEvent() {
        if (this.commandEvent != null && !this.executionListeners.isEmpty()) {
            for (CommandExecutionListener commandExecutionListener : this.executionListeners) {
                commandExecutionListener.commandExecuted(this.commandEvent);
            }
        }
    }

    private void fireCommandExecutionEvent(Throwable throwable) throws RuntimeException, Error {
        if (this.commandEvent != null && !this.executionListeners.isEmpty()) {
            for (CommandExecutionListener commandExecutionListener : this.executionListeners) {
                commandExecutionListener.commandAborted(this.commandEvent, throwable);
            }
        } else {
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
        }
    }
}

