/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.control;

import java.awt.Point;
import net.astah.golf.control.Command;
import net.astah.golf.control.CommandEvent;
import net.astah.golf.control.CommandExecutionListener;
import net.astah.golf.control.CommandFactory;
import net.astah.golf.control.CommandListener;
import net.astah.golf.control.CommandRunner;
import net.astah.golf.util.RuntimeGlobal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class CommandManager
implements CommandListener {
    private static CommandManager instance;
    private CommandFactory commandFactory = new CommandFactory();
    private Point point = null;
    private CommandExecutionListener executionListener;
    public static boolean IS_PAUSE_COMMAND;
    private static final Logger logger;
    private static final Marker marker;

    private CommandManager() {
    }

    public static CommandManager instance() {
        if (instance == null) {
            instance = new CommandManager();
        }
        return instance;
    }

    public void setCommandPackageName(String string) {
        this.commandFactory.setCommandPackageName(string);
    }

    @Override
    public void commandPerformed(CommandEvent commandEvent) {
        if (IS_PAUSE_COMMAND) {
            return;
        }
        CommandRunner commandRunner = this.createCommandRunner(commandEvent);
        if (commandRunner == null) {
            return;
        }
        if (logger.isDebugEnabled(marker)) {
            String string = commandRunner.getCommandName();
            if (string == null) {
                string = commandRunner.getClass().getCanonicalName();
            }
            logger.debug(marker, "CM: {} was Performed.", (Object)string);
        }
        commandRunner.start();
    }

    public void setCommandExecutionListener(CommandExecutionListener commandExecutionListener) {
        this.executionListener = commandExecutionListener;
    }

    protected CommandRunner createCommandRunner(CommandEvent commandEvent) {
        CommandRunner commandRunner = null;
        String string = null;
        String string2 = commandEvent.getCommandName();
        Command command = commandEvent.getCommandObject();
        if (command == null) {
            int n = string2.indexOf("%");
            String string3 = string2;
            String string4 = null;
            if (n != -1) {
                string3 = string2.substring(0, n);
                if (n + 1 < string2.length()) {
                    string4 = string2.substring(n + 1);
                }
            }
            if ((command = CommandFactory.createCommand(string3)) == null) {
                return null;
            }
            string = command.getName();
            if (string4 != null) {
                command.setArgumentString(string4);
            }
        } else {
            string = command.getName();
        }
        RuntimeGlobal.addCommandLog(string);
        if (logger.isDebugEnabled(marker)) {
            logger.debug(marker, "CM: {}", (Object)string);
        }
        if (this.point != null) {
            command.setPoint(this.point);
        }
        commandRunner = new CommandRunner(command);
        commandRunner.setCommandEvent(commandEvent);
        switch (commandEvent.getRunType()) {
            case 1: {
                commandRunner.setRunType(0);
                break;
            }
            case 2: {
                commandRunner.setRunType(1);
            }
        }
        if (this.executionListener != null) {
            commandRunner.addCommandExecutionListener(this.executionListener);
        }
        return commandRunner;
    }

    protected boolean isScript(String string) {
        return string.startsWith("Py");
    }

    public void setPoint(Point point) {
        this.point = point;
    }

    public Point getPoint() {
        return this.point;
    }

    public int callCommand(Command command) {
        this.callCommand(command, 1);
        return command.getEndState();
    }

    private void callCommand(Command command, int n) {
        CommandEvent commandEvent = new CommandEvent(this, 0, "", command, 0, n);
        this.commandPerformed(commandEvent);
    }

    public CommandFactory getCommandFactory() {
        return this.commandFactory;
    }

    static {
        IS_PAUSE_COMMAND = false;
        logger = LoggerFactory.getLogger(CommandManager.class);
        marker = MarkerFactory.getMarker((String)"command");
    }
}

