/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.control;

import java.awt.Point;
import net.astah.golf.control.CommandEvent;
import net.astah.golf.control.CommandManager;
import proguard.annotation.Keep;
import proguard.annotation.KeepImplementations;

@Keep
@KeepImplementations
public abstract class Command {
    public static final int NORMAL_END = 0;
    public static final int FAIL_END = 1;
    private int endState = 0;
    private Point point = null;
    protected boolean useTransaction = true;
    protected CommandEvent event = null;

    public void start() {
        this.execute();
        this.event = null;
    }

    protected void setEndState(int n) {
        this.endState = n;
    }

    public int getEndState() {
        return this.endState;
    }

    public abstract void execute();

    public String getName() {
        return this.getClass().getName();
    }

    protected void callCommand(CommandEvent commandEvent) {
        if (CommandManager.instance() != null) {
            CommandManager.instance().commandPerformed(commandEvent);
        }
    }

    protected void callCommand(Command command) {
        this.callCommand(command, 1);
    }

    protected void callCommand(Command command, int n) {
        CommandEvent commandEvent = new CommandEvent(this, 0, "", command, 0, n);
        this.callCommand(commandEvent);
    }

    protected void callCommand(String string) {
        this.callCommand(string, 1);
    }

    protected void callCommand(String string, int n) {
        CommandEvent commandEvent = new CommandEvent((Object)this, 0, string, 0, n);
        this.callCommand(commandEvent);
        commandEvent = null;
    }

    public void setCommandEvent(CommandEvent commandEvent) {
        this.event = commandEvent;
    }

    void setPoint(Point point) {
        this.point = point;
    }

    protected Point getPoint() {
        return this.point;
    }

    public void setArgumentString(String string) {
    }

    public void setUseTransaction(boolean bl) {
        this.useTransaction = bl;
    }
}

