/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.control;

import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import net.astah.golf.control.CommandEvent;
import net.astah.golf.control.CommandListener;
import net.astah.golf.control.CommandManager;

public class CellEditorActionListener
implements CellEditorListener {
    protected static final EventListenerList listenerList = new EventListenerList();
    protected int runType = 1;
    private String actionName = null;
    protected boolean enabled = true;

    public CellEditorActionListener(String string) {
        this(string, 1);
    }

    public CellEditorActionListener(String string, int n) {
        this.setActionName(string);
        if (listenerList.getListenerCount() < 1) {
            this.addCommandListener(CommandManager.instance());
        }
        this.runType = n;
    }

    protected String getActionName() {
        return this.actionName;
    }

    protected void setActionName(String string) {
        this.actionName = string;
    }

    public void setRunType(int n) {
        this.runType = n;
    }

    public void addCommandListener(CommandListener commandListener) {
        listenerList.add(CommandListener.class, commandListener);
    }

    public void removeCommandListener(CommandListener commandListener) {
        listenerList.remove(CommandListener.class, commandListener);
    }

    public void actionPerformed(ChangeEvent changeEvent) {
        if (!this.isEnabled()) {
            return;
        }
        this.fireCommandPerformed(new CommandEvent(changeEvent.getSource(), 0, this.actionName, -1, this.runType));
    }

    protected void fireCommandPerformed(CommandEvent commandEvent) {
        Object[] objectArray = listenerList.getListenerList();
        for (int k = objectArray.length - 2; k >= 0; k -= 2) {
            if (objectArray[k] != CommandListener.class) continue;
            ((CommandListener)objectArray[k + 1]).commandPerformed(commandEvent);
        }
    }

    @Override
    public void editingStopped(ChangeEvent changeEvent) {
        this.actionPerformed(changeEvent);
    }

    @Override
    public void editingCanceled(ChangeEvent changeEvent) {
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }
}

