/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.notation.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.astah.stpa.stamp.notation.AccidentHazardSafetyConstraintTable;
import net.astah.stpa.stamp.notation.ComponentExtractingTable;
import net.astah.stpa.stamp.notation.CountermeasureTable;
import net.astah.stpa.stamp.notation.HCFSummeryTable;
import net.astah.stpa.stamp.notation.HCFTable;
import net.astah.stpa.stamp.notation.PreconditionTable;
import net.astah.stpa.stamp.notation.STAMPCompartment;
import net.astah.stpa.stamp.notation.STAMPCompartmentableShape;
import net.astah.stpa.stamp.notation.STAMPComponentShape;
import net.astah.stpa.stamp.notation.STAMPControlLoopDiagram;
import net.astah.stpa.stamp.notation.STAMPControlStructureDiagram;
import net.astah.stpa.stamp.notation.STAMPDiagram;
import net.astah.stpa.stamp.notation.STAMPDiagramElement;
import net.astah.stpa.stamp.notation.STAMPEdge;
import net.astah.stpa.stamp.notation.STAMPGraphicalShape;
import net.astah.stpa.stamp.notation.STAMPLabel;
import net.astah.stpa.stamp.notation.STAMPNotationPackage;
import net.astah.stpa.stamp.notation.STAMPNotationPlugin;
import net.astah.stpa.stamp.notation.STAMPShape;
import net.astah.stpa.stamp.notation.STAMPTable;
import net.astah.stpa.stamp.notation.UCATable;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMapUtil;

public class STAMPNotationValidator
extends EObjectValidator {
    public static final STAMPNotationValidator INSTANCE = new STAMPNotationValidator();
    public static final String DIAGNOSTIC_SOURCE = "net.astah.stpa.stamp.notation";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;

    protected EPackage getEPackage() {
        return STAMPNotationPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateSTAMPDiagramElement((STAMPDiagramElement)value, diagnostics, context);
            }
            case 1: {
                return this.validateSTAMPEdge((STAMPEdge)value, diagnostics, context);
            }
            case 2: {
                return this.validateSTAMPDiagram((STAMPDiagram)value, diagnostics, context);
            }
            case 3: {
                return this.validateSTAMPShape((STAMPShape)value, diagnostics, context);
            }
            case 4: {
                return this.validateSTAMPLabel((STAMPLabel)value, diagnostics, context);
            }
            case 5: {
                return this.validateSTAMPCompartment((STAMPCompartment)value, diagnostics, context);
            }
            case 6: {
                return this.validateSTAMPCompartmentableShape((STAMPCompartmentableShape)value, diagnostics, context);
            }
            case 7: {
                return this.validateSTAMPComponentShape((STAMPComponentShape)value, diagnostics, context);
            }
            case 8: {
                return this.validateSTAMPGraphicalShape((STAMPGraphicalShape)value, diagnostics, context);
            }
            case 9: {
                return this.validateSTAMPControlStructureDiagram((STAMPControlStructureDiagram)value, diagnostics, context);
            }
            case 10: {
                return this.validateComponentExtractingTable((ComponentExtractingTable)value, diagnostics, context);
            }
            case 11: {
                return this.validateSTAMPTable((STAMPTable)value, diagnostics, context);
            }
            case 12: {
                return this.validateSTAMPControlLoopDiagram((STAMPControlLoopDiagram)value, diagnostics, context);
            }
            case 13: {
                return this.validatePreconditionTable((PreconditionTable)value, diagnostics, context);
            }
            case 14: {
                return this.validateAccidentHazardSafetyConstraintTable((AccidentHazardSafetyConstraintTable)value, diagnostics, context);
            }
            case 15: {
                return this.validateUCATable((UCATable)value, diagnostics, context);
            }
            case 16: {
                return this.validateHCFTable((HCFTable)value, diagnostics, context);
            }
            case 17: {
                return this.validateHCFSummeryTable((HCFSummeryTable)value, diagnostics, context);
            }
            case 18: {
                return this.validateCountermeasureTable((CountermeasureTable)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateSTAMPDiagramElement(STAMPDiagramElement stampDiagramElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)stampDiagramElement, diagnostics, context);
    }

    public boolean validateSTAMPEdge(STAMPEdge stampEdge, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)stampEdge, diagnostics, context);
    }

    public boolean validateSTAMPDiagram(STAMPDiagram stampDiagram, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)stampDiagram, diagnostics, context);
    }

    public boolean validateSTAMPShape(STAMPShape stampShape, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)stampShape, diagnostics, context);
    }

    public boolean validateSTAMPLabel(STAMPLabel stampLabel, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)stampLabel, diagnostics, context);
    }

    public boolean validateSTAMPCompartment(STAMPCompartment stampCompartment, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)stampCompartment, diagnostics, context);
    }

    public boolean validateSTAMPCompartmentableShape(STAMPCompartmentableShape stampCompartmentableShape, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)stampCompartmentableShape, diagnostics, context);
    }

    public boolean validateSTAMPControlStructureDiagram(STAMPControlStructureDiagram stampControlStructureDiagram, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)stampControlStructureDiagram, diagnostics, context);
    }

    public boolean validateComponentExtractingTable(ComponentExtractingTable componentExtractingTable, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)componentExtractingTable, diagnostics, context);
    }

    public boolean validateSTAMPGraphicalShape(STAMPGraphicalShape stampGraphicalShape, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)stampGraphicalShape, diagnostics, context);
    }

    public boolean validatePreconditionTable(PreconditionTable preconditionTable, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)preconditionTable, diagnostics, context);
    }

    public boolean validateSTAMPTable(STAMPTable stampTable, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)stampTable, diagnostics, context);
    }

    public boolean validateAccidentHazardSafetyConstraintTable(AccidentHazardSafetyConstraintTable accidentHazardSafetyConstraintTable, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)accidentHazardSafetyConstraintTable, diagnostics, context);
    }

    public boolean validateUCATable(UCATable ucaTable, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)ucaTable, diagnostics, context);
    }

    public boolean validateSTAMPControlLoopDiagram(STAMPControlLoopDiagram stampControlLoopDiagram, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)stampControlLoopDiagram, diagnostics, context);
    }

    public boolean validateHCFSummeryTable(HCFSummeryTable hcfSummeryTable, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)hcfSummeryTable, diagnostics, context);
    }

    public boolean validateHCFTable(HCFTable hcfTable, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)hcfTable, diagnostics, context);
    }

    public boolean validateCountermeasureTable(CountermeasureTable countermeasureTable, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)countermeasureTable, diagnostics, context);
    }

    public boolean validateSTAMPComponentShape(STAMPComponentShape stampComponentShape, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)stampComponentShape, diagnostics, context);
    }

    public ResourceLocator getResourceLocator() {
        return STAMPNotationPlugin.INSTANCE;
    }

    private String getRedefinitionDetail(EClass eClass, String featureName, String key) {
        ArrayList<EClass> eClasses = new ArrayList<EClass>();
        eClasses.add(eClass);
        eClasses.addAll((Collection<EClass>)eClass.getEAllSuperTypes());
        String redefinitionDetail = null;
        Iterator eClassesIterator = eClasses.iterator();
        while (redefinitionDetail == null && eClassesIterator.hasNext()) {
            EAnnotation nestedEAnnotation;
            EAnnotation eAnnotation = ((EClass)eClassesIterator.next()).getEAnnotation("duplicates");
            if (eAnnotation == null || (nestedEAnnotation = eAnnotation.getEAnnotation(featureName)) == null) continue;
            redefinitionDetail = (String)nestedEAnnotation.getDetails().get((Object)key);
        }
        return redefinitionDetail;
    }

    protected int getLowerBound(EObject eObject, EStructuralFeature eStructuralFeature) {
        String redefinitionDetail = this.getRedefinitionDetail(eObject.eClass(), eStructuralFeature.getName(), "lowerBound");
        if (redefinitionDetail != null && redefinitionDetail.length() > 0) {
            try {
                return Integer.parseInt(redefinitionDetail);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return eStructuralFeature.getLowerBound();
    }

    protected int getUpperBound(EObject eObject, EStructuralFeature eStructuralFeature) {
        String redefinitionDetail = this.getRedefinitionDetail(eObject.eClass(), eStructuralFeature.getName(), "upperBound");
        if (redefinitionDetail != null && redefinitionDetail.length() > 0) {
            try {
                return Integer.parseInt(redefinitionDetail);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return eStructuralFeature.getUpperBound();
    }

    protected boolean isEcoreString(String key) {
        return super.isEcoreString(key) || "_UI_FeatureHasTooFewValues_diagnostic".equals(key) || "_UI_FeatureHasTooManyValues_diagnostic".equals(key) || "_UI_RequiredFeatureMustBeSet_diagnostic".equals(key);
    }

    protected boolean validate_MultiplicityConforms(EObject eObject, EStructuralFeature eStructuralFeature, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        if (eStructuralFeature.isMany()) {
            if (FeatureMapUtil.isFeatureMap((EStructuralFeature)eStructuralFeature) && ExtendedMetaData.INSTANCE.isDocumentRoot(eObject.eClass())) {
                result = super.validate_MultiplicityConforms(eObject, eStructuralFeature, diagnostics, context);
            } else {
                int lowerBound = this.getLowerBound(eObject, eStructuralFeature);
                if (lowerBound > 0) {
                    int upperBound;
                    int size = ((List)eObject.eGet(eStructuralFeature)).size();
                    if (size < lowerBound) {
                        result = false;
                        if (diagnostics != null) {
                            diagnostics.add((Diagnostic)this.createDiagnostic(4, "org.eclipse.emf.ecore", 1, "_UI_FeatureHasTooFewValues_diagnostic", new Object[]{STAMPNotationValidator.getFeatureLabel((EStructuralFeature)eStructuralFeature, context), STAMPNotationValidator.getObjectLabel((EObject)eObject, context), size, lowerBound}, new Object[]{eObject, eStructuralFeature}, context));
                        }
                    }
                    if ((upperBound = this.getUpperBound(eObject, eStructuralFeature)) > 0 && size > upperBound) {
                        result = false;
                        if (diagnostics != null) {
                            diagnostics.add((Diagnostic)this.createDiagnostic(4, "org.eclipse.emf.ecore", 1, "_UI_FeatureHasTooManyValues_diagnostic", new Object[]{STAMPNotationValidator.getFeatureLabel((EStructuralFeature)eStructuralFeature, context), STAMPNotationValidator.getObjectLabel((EObject)eObject, context), size, upperBound}, new Object[]{eObject, eStructuralFeature}, context));
                        }
                    }
                } else {
                    int size;
                    int upperBound = this.getUpperBound(eObject, eStructuralFeature);
                    if (upperBound > 0 && (size = ((List)eObject.eGet(eStructuralFeature)).size()) > upperBound) {
                        result = false;
                        if (diagnostics != null) {
                            diagnostics.add((Diagnostic)this.createDiagnostic(4, "org.eclipse.emf.ecore", 1, "_UI_FeatureHasTooManyValues_diagnostic", new Object[]{STAMPNotationValidator.getFeatureLabel((EStructuralFeature)eStructuralFeature, context), STAMPNotationValidator.getObjectLabel((EObject)eObject, context), size, upperBound}, new Object[]{eObject, eStructuralFeature}, context));
                        }
                    }
                }
            }
        } else if (this.getLowerBound(eObject, eStructuralFeature) >= 1 && (eStructuralFeature.isUnsettable() ? !eObject.eIsSet(eStructuralFeature) : eObject.eGet(eStructuralFeature, false) == null)) {
            result = false;
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, "org.eclipse.emf.ecore", 1, "_UI_RequiredFeatureMustBeSet_diagnostic", new Object[]{STAMPNotationValidator.getFeatureLabel((EStructuralFeature)eStructuralFeature, context), STAMPNotationValidator.getObjectLabel((EObject)eObject, context)}, new Object[]{eObject, eStructuralFeature}, context));
            }
        }
        return result;
    }
}

