/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.notation.util;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.astah.dd.di.DiagramElement;
import net.astah.stpa.stamp.notation.STAMPNotationPackage;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.uml2.common.util.UML2Util;

public class STAMPDiagramElements {
    public static <T extends DiagramElement> List<T> getDiagramElements(EObject modelElement, DiagramElement ancestor, Class<T> targetClass) {
        if (modelElement == null) {
            return Collections.emptyList();
        }
        return UML2Util.getNonNavigableInverseReferences((EObject)modelElement).stream().filter(setting -> STAMPDiagramElements.isTargetSetting(setting, ancestor, targetClass)).map(setting -> (DiagramElement)targetClass.cast(setting.getEObject())).collect(Collectors.toList());
    }

    public static List<DiagramElement> getDiagramElements(EObject modelElement, DiagramElement ancestor) {
        return STAMPDiagramElements.getDiagramElements(modelElement, ancestor, DiagramElement.class);
    }

    private static <T> boolean isTargetSetting(EStructuralFeature.Setting setting, DiagramElement ancestor, Class<T> targetClass) {
        if (setting.getEStructuralFeature() != STAMPNotationPackage.Literals.STAMP_DIAGRAM_ELEMENT__STAMP_MODEL_ELEMENT) {
            return false;
        }
        EObject eObject = setting.getEObject();
        if (!targetClass.isInstance(eObject)) {
            return false;
        }
        return ancestor == null || EcoreUtil.isAncestor((EObject)ancestor, (EObject)eObject);
    }
}

