/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.notation.impl;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.stream.Collectors;
import net.astah.dd.dc.Bounds;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.Style;
import net.astah.emf.common.collect.EObjectELists;
import net.astah.emf.common.ecore.EFeatureCache;
import net.astah.stpa.stamp.ControlAction;
import net.astah.stpa.stamp.LinkEnd;
import net.astah.stpa.stamp.UCAAnalysis;
import net.astah.stpa.stamp.UCAAnalysisResult;
import net.astah.stpa.stamp.notation.STAMPControlStructureDiagram;
import net.astah.stpa.stamp.notation.STAMPNotationPackage;
import net.astah.stpa.stamp.notation.STAMPShape;
import net.astah.stpa.stamp.notation.UCATable;
import net.astah.stpa.stamp.notation.impl.STAMPTableImpl;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class UCATableImpl
extends STAMPTableImpl
implements UCATable {
    protected STAMPControlStructureDiagram controlStructureDiagram;
    protected UCAAnalysis analysis;
    protected static final EFeatureCache<UCATableImpl, EList<ControlAction>> CONTROL_ACTION_CACHE = new EFeatureCache.Global((EStructuralFeature)STAMPNotationPackage.Literals.UCA_TABLE__CONTROL_ACTION, UCATableImpl::calculateControlActions);
    protected static final EFeatureCache<UCATableImpl, EList<UCAAnalysisResult>> RESULT_CACHE = new EFeatureCache.Global((EStructuralFeature)STAMPNotationPackage.Literals.UCA_TABLE__RESULT, UCATableImpl::calculateResults);

    protected UCATableImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return STAMPNotationPackage.Literals.UCA_TABLE;
    }

    @Override
    public STAMPControlStructureDiagram getControlStructureDiagram() {
        if (this.controlStructureDiagram != null && this.controlStructureDiagram.eIsProxy()) {
            InternalEObject oldControlStructureDiagram = (InternalEObject)this.controlStructureDiagram;
            this.controlStructureDiagram = (STAMPControlStructureDiagram)this.eResolveProxy(oldControlStructureDiagram);
            if (this.controlStructureDiagram != oldControlStructureDiagram && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 13, (Object)oldControlStructureDiagram, (Object)this.controlStructureDiagram));
            }
        }
        return this.controlStructureDiagram;
    }

    public STAMPControlStructureDiagram basicGetControlStructureDiagram() {
        return this.controlStructureDiagram;
    }

    @Override
    public void setControlStructureDiagram(STAMPControlStructureDiagram newControlStructureDiagram) {
        STAMPControlStructureDiagram oldControlStructureDiagram = this.controlStructureDiagram;
        this.controlStructureDiagram = newControlStructureDiagram;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 13, (Object)oldControlStructureDiagram, (Object)this.controlStructureDiagram));
        }
    }

    @Override
    public UCAAnalysis getAnalysis() {
        if (this.analysis != null && this.analysis.eIsProxy()) {
            InternalEObject oldAnalysis = (InternalEObject)this.analysis;
            this.analysis = (UCAAnalysis)this.eResolveProxy(oldAnalysis);
            if (this.analysis != oldAnalysis && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 14, (Object)oldAnalysis, (Object)this.analysis));
            }
        }
        return this.analysis;
    }

    public UCAAnalysis basicGetAnalysis() {
        return this.analysis;
    }

    @Override
    public void setAnalysis(UCAAnalysis newAnalysis) {
        UCAAnalysis oldAnalysis = this.analysis;
        this.analysis = newAnalysis;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 14, (Object)oldAnalysis, (Object)this.analysis));
        }
    }

    @Override
    public EList<ControlAction> getControlActions() {
        return (EList)CONTROL_ACTION_CACHE.get((EObject)this);
    }

    protected EList<ControlAction> calculateControlActions() {
        STAMPControlStructureDiagram diagram = this.getControlStructureDiagram();
        UCAAnalysis analysis = this.getAnalysis();
        if (diagram == null || analysis == null) {
            return ECollections.emptyEList();
        }
        ArrayList controlActionsOnDiagram = Lists.newArrayList((Iterator)Iterators.filter((Iterator)Iterators.concat((Iterator)Iterators.transform((Iterator)Iterators.filter((Iterator)EcoreUtil.getAllContents((EObject)diagram, (boolean)true), STAMPShape.class), shape -> shape.getModelElements().iterator())), ControlAction.class));
        return EObjectELists.unmodifiableEObjectEList((InternalEObject)this, (int)6, analysis.getControlActions().stream().filter(m -> controlActionsOnDiagram.contains(m) && !(m.getLink().getSource() instanceof LinkEnd) && !(m.getLink().getTarget() instanceof LinkEnd)).collect(Collectors.toList()));
    }

    @Override
    public EList<UCAAnalysisResult> getResults() {
        return (EList)RESULT_CACHE.get((EObject)this);
    }

    protected EList<UCAAnalysisResult> calculateResults() {
        EList<ControlAction> controlActions = this.getControlActions();
        if (controlActions.isEmpty()) {
            return ECollections.emptyEList();
        }
        return EObjectELists.unmodifiableEObjectEList((InternalEObject)this, (int)2, this.getAnalysis().getResults().stream().filter(result -> controlActions.contains(result.getControlAction())).collect(Collectors.toList()));
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getEAnnotations();
            }
            case 1: {
                return this.getModelElements();
            }
            case 2: {
                if (resolve) {
                    return this.getOwningElement();
                }
                return this.basicGetOwningElement();
            }
            case 3: {
                return this.getOwnedElements();
            }
            case 4: {
                return this.getTargetEdges();
            }
            case 5: {
                return this.getSourceEdges();
            }
            case 6: {
                return this.getLocalStyle();
            }
            case 7: {
                if (resolve) {
                    return this.getSharedStyle();
                }
                return this.basicGetSharedStyle();
            }
            case 8: {
                return this.getBounds();
            }
            case 9: {
                return this.getName();
            }
            case 10: {
                return this.getDocumentation();
            }
            case 11: {
                return this.getResolution();
            }
            case 12: {
                if (resolve) {
                    return this.getOwner();
                }
                return this.basicGetOwner();
            }
            case 13: {
                if (resolve) {
                    return this.getControlStructureDiagram();
                }
                return this.basicGetControlStructureDiagram();
            }
            case 14: {
                if (resolve) {
                    return this.getAnalysis();
                }
                return this.basicGetAnalysis();
            }
            case 15: {
                return this.getControlActions();
            }
            case 16: {
                return this.getResults();
            }
        }
        return this.eDynamicGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getEAnnotations().clear();
                this.getEAnnotations().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.getModelElements().clear();
                this.getModelElements().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.setOwningElement((DiagramElement)newValue);
                return;
            }
            case 3: {
                this.getOwnedElements().clear();
                this.getOwnedElements().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.getTargetEdges().clear();
                this.getTargetEdges().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.getSourceEdges().clear();
                this.getSourceEdges().addAll((Collection)newValue);
                return;
            }
            case 6: {
                this.setLocalStyle((Style)newValue);
                return;
            }
            case 7: {
                this.setSharedStyle((Style)newValue);
                return;
            }
            case 8: {
                this.setBounds((Bounds)newValue);
                return;
            }
            case 9: {
                this.setName((String)newValue);
                return;
            }
            case 10: {
                this.setDocumentation((String)newValue);
                return;
            }
            case 11: {
                this.setResolution((Double)newValue);
                return;
            }
            case 12: {
                this.setOwner((EObject)newValue);
                return;
            }
            case 13: {
                this.setControlStructureDiagram((STAMPControlStructureDiagram)newValue);
                return;
            }
            case 14: {
                this.setAnalysis((UCAAnalysis)newValue);
                return;
            }
        }
        this.eDynamicSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getEAnnotations().clear();
                return;
            }
            case 1: {
                this.getModelElements().clear();
                return;
            }
            case 2: {
                this.setOwningElement(null);
                return;
            }
            case 3: {
                this.getOwnedElements().clear();
                return;
            }
            case 4: {
                this.getTargetEdges().clear();
                return;
            }
            case 5: {
                this.getSourceEdges().clear();
                return;
            }
            case 6: {
                this.setLocalStyle(null);
                return;
            }
            case 7: {
                this.setSharedStyle(null);
                return;
            }
            case 8: {
                this.setBounds(null);
                return;
            }
            case 9: {
                this.setName("");
                return;
            }
            case 10: {
                this.setDocumentation("");
                return;
            }
            case 11: {
                this.setResolution(300.0);
                return;
            }
            case 12: {
                this.setOwner(null);
                return;
            }
            case 13: {
                this.setControlStructureDiagram(null);
                return;
            }
            case 14: {
                this.setAnalysis(null);
                return;
            }
        }
        this.eDynamicUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.eAnnotations != null && !this.eAnnotations.isEmpty();
            }
            case 1: {
                return !this.getModelElements().isEmpty();
            }
            case 2: {
                return this.basicGetOwningElement() != null;
            }
            case 3: {
                return !this.getOwnedElements().isEmpty();
            }
            case 4: {
                return !this.getTargetEdges().isEmpty();
            }
            case 5: {
                return !this.getSourceEdges().isEmpty();
            }
            case 6: {
                return this.localStyle != null;
            }
            case 7: {
                return this.sharedStyle != null;
            }
            case 8: {
                return this.bounds != null;
            }
            case 9: {
                return "" == null ? this.name != null : !"".equals(this.name);
            }
            case 10: {
                return "" == null ? this.documentation != null : !"".equals(this.documentation);
            }
            case 11: {
                return this.resolution != 300.0;
            }
            case 12: {
                return this.owner != null;
            }
            case 13: {
                return this.controlStructureDiagram != null;
            }
            case 14: {
                return this.analysis != null;
            }
            case 15: {
                return !this.getControlActions().isEmpty();
            }
            case 16: {
                return !this.getResults().isEmpty();
            }
        }
        return this.eDynamicIsSet(featureID);
    }
}

