/*
 * Decompiled with CFR 0.152.
 */
package net.astah.dd.di.edit.provider;

import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import net.astah.dd.dc.Bounds;
import net.astah.dd.dc.DCFactory;
import net.astah.dd.dc.Dimension;
import net.astah.dd.dc.Point;
import net.astah.dd.di.DIPackage;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.Edge;
import net.astah.dd.di.edit.provider.FeatureAccessor;
import net.astah.dd.di.edit.provider.Geometries;
import net.astah.dd.di.edit.provider.IItemGeometryProvider;
import net.astah.dd.di.edit.provider.LayoutCache;
import net.astah.emf.edit.provider.ItemProviders;
import net.astah.golf.geom2D.Rectangle2d;

public class LayoutCalculator {
    private final LayoutCache a;
    private final FeatureAccessor b;

    public LayoutCalculator() {
        this(new LayoutCache(), new FeatureAccessor());
    }

    public LayoutCalculator(@NonNull LayoutCache layoutCache, @NonNull FeatureAccessor featureAccessor) {
        if (layoutCache == null) {
            throw new NullPointerException("layoutCache");
        }
        if (featureAccessor == null) {
            throw new NullPointerException("featureAccessor");
        }
        this.a = layoutCache;
        this.b = featureAccessor;
    }

    public LayoutCache getLayoutCache() {
        return this.a;
    }

    public FeatureAccessor getFeatureAccessor() {
        return this.b;
    }

    public Point getOrigin(Object object) {
        return this.getOrigin(object, null);
    }

    public Point getOrigin(Object object, Object object2) {
        IItemGeometryProvider iItemGeometryProvider = (IItemGeometryProvider)ItemProviders.adapt((Object)object, IItemGeometryProvider.class);
        return iItemGeometryProvider != null ? this.getOrigin(object, object2, iItemGeometryProvider, true) : null;
    }

    public Point getUnaffectedOrigin(Object object, Object object2) {
        IItemGeometryProvider iItemGeometryProvider = (IItemGeometryProvider)ItemProviders.adapt((Object)object, IItemGeometryProvider.class);
        return iItemGeometryProvider != null ? this.getOrigin(object, object2, iItemGeometryProvider, false) : null;
    }

    protected Point getOrigin(Object object, Object object2, IItemGeometryProvider iItemGeometryProvider, boolean bl) {
        IItemGeometryProvider iItemGeometryProvider2;
        Object object3;
        if (object != object2 && (object3 = iItemGeometryProvider.getOriginatingElement(object, this)) != null && (iItemGeometryProvider2 = (IItemGeometryProvider)ItemProviders.adapt((Object)object3, IItemGeometryProvider.class)) != null) {
            Point point = this.getOrigin(object3, object2, iItemGeometryProvider2, bl);
            return LayoutCalculator.translate(iItemGeometryProvider2.getElementOrigin(object3, bl ? object : null, this), point);
        }
        return null;
    }

    public Bounds getTotalBounds(Iterable<?> iterable) {
        return this.getTotalBounds(iterable, null);
    }

    public Bounds getTotalBounds(Iterable<?> iterable, Object object) {
        return this.getTotalBounds(iterable, object, false);
    }

    public Bounds getTotalBounds(Iterable<?> iterable, boolean bl) {
        return this.getTotalBounds(iterable, null, bl);
    }

    public Bounds getTotalBounds(Iterable<?> iterable, Object object, boolean bl) {
        Rectangle2D rectangle2D = null;
        for (Object obj : iterable) {
            List<DiagramElement> list;
            rectangle2D = this.a(rectangle2D, this.getBounds(obj, object));
            if (!bl || !(obj instanceof DiagramElement) || (list = this.getOwnedElements((DiagramElement)obj)).isEmpty()) continue;
            rectangle2D = this.a(rectangle2D, this.getTotalBounds(list, object, true));
        }
        return rectangle2D != null ? Geometries.toBounds(rectangle2D) : DCFactory.eINSTANCE.createBounds();
    }

    private Rectangle2D a(Rectangle2D rectangle2D, Bounds bounds) {
        if (bounds != null) {
            Rectangle2d rectangle2d = Geometries.toRectangle2d(bounds);
            if (rectangle2D == null) {
                return rectangle2d;
            }
            rectangle2D.add((Rectangle2D)rectangle2d);
        }
        return rectangle2D;
    }

    public Bounds getBounds(Object object) {
        return this.getBounds(object, null);
    }

    public Bounds getBounds(Object object, Object object2) {
        IItemGeometryProvider iItemGeometryProvider = (IItemGeometryProvider)ItemProviders.adapt((Object)object, IItemGeometryProvider.class);
        if (iItemGeometryProvider != null) {
            Point point = this.getOrigin(object, object2, iItemGeometryProvider, true);
            Bounds bounds = this.a.getBounds(object);
            if (bounds != null) {
                return LayoutCalculator.translate(bounds, point);
            }
            Bounds bounds2 = iItemGeometryProvider.getBoundsOn(object, this);
            this.a.put(object, bounds2);
            return LayoutCalculator.translate(bounds2, point);
        }
        return null;
    }

    public Point getBoundsLocation(Object object) {
        return this.getBoundsLocation(object, null);
    }

    protected Point getBoundsLocation(Object object, Object object2) {
        IItemGeometryProvider iItemGeometryProvider = (IItemGeometryProvider)ItemProviders.adapt((Object)object, IItemGeometryProvider.class);
        if (iItemGeometryProvider != null) {
            Point point = this.getOrigin(object, object2, iItemGeometryProvider, true);
            Point point2 = this.a.getLocation(object);
            if (point2 != null) {
                return LayoutCalculator.translate(point2, point);
            }
            Point point3 = iItemGeometryProvider.getLocationOn(object, this);
            this.a.put(object, point3);
            return LayoutCalculator.translate(point3, point);
        }
        return null;
    }

    public Bounds getBoundsOn(Object object, Point point) {
        Bounds bounds = this.a.getBounds(object);
        if (bounds != null) {
            return LayoutCalculator.translate(bounds, point);
        }
        IItemGeometryProvider iItemGeometryProvider = (IItemGeometryProvider)ItemProviders.adapt((Object)object, IItemGeometryProvider.class);
        if (iItemGeometryProvider != null) {
            Bounds bounds2 = iItemGeometryProvider.getBoundsOn(object, this);
            this.a.put(object, bounds2);
            return LayoutCalculator.translate(bounds2, point);
        }
        return null;
    }

    public Point getLocationOn(Object object, Point point) {
        Point point2 = this.a.getLocation(object);
        if (point2 != null) {
            return LayoutCalculator.translate(point2, point);
        }
        IItemGeometryProvider iItemGeometryProvider = (IItemGeometryProvider)ItemProviders.adapt((Object)object, IItemGeometryProvider.class);
        if (iItemGeometryProvider != null) {
            Point point3 = iItemGeometryProvider.getLocationOn(object, this);
            if (point3 == null) {
                return point;
            }
            this.a.put(object, point3);
            return LayoutCalculator.translate(point3, point);
        }
        return null;
    }

    public Dimension getBoundsSize(Object object) {
        Dimension dimension = this.a.getSize(object);
        if (dimension != null) {
            return dimension;
        }
        IItemGeometryProvider iItemGeometryProvider = (IItemGeometryProvider)ItemProviders.adapt((Object)object, IItemGeometryProvider.class);
        if (iItemGeometryProvider != null) {
            Dimension dimension2 = iItemGeometryProvider.getBoundsSize(object, this);
            this.a.put(object, dimension2);
            return dimension2;
        }
        return null;
    }

    public Point getElementLocationOn(Object object, Object object2, Point point) {
        IItemGeometryProvider iItemGeometryProvider = (IItemGeometryProvider)ItemProviders.adapt((Object)object, IItemGeometryProvider.class);
        return LayoutCalculator.translate(iItemGeometryProvider.getElementLocationOn(object, object2, this), point);
    }

    public Dimension getElementSize(Object object, Object object2) {
        IItemGeometryProvider iItemGeometryProvider = (IItemGeometryProvider)ItemProviders.adapt((Object)object, IItemGeometryProvider.class);
        return iItemGeometryProvider.getElementSize(object, object2, this);
    }

    public List<Point> getWaypoints(Object object, Point point) {
        List<Point> list = this.a.getWaypoints(object);
        if (list != null) {
            return LayoutCalculator.translate(list, point);
        }
        IItemGeometryProvider iItemGeometryProvider = (IItemGeometryProvider)ItemProviders.adapt((Object)object, IItemGeometryProvider.class);
        if (iItemGeometryProvider != null) {
            List<Point> list2 = iItemGeometryProvider.getWaypoints(object, this);
            this.a.put(object, list2);
            return LayoutCalculator.translate(list2, point);
        }
        return null;
    }

    public List<Point> getControlPoints(Object object, Point point) {
        IItemGeometryProvider iItemGeometryProvider = (IItemGeometryProvider)ItemProviders.adapt((Object)object, IItemGeometryProvider.class);
        if (iItemGeometryProvider != null) {
            return LayoutCalculator.translate(iItemGeometryProvider.getControlPoints(object, this), point);
        }
        return null;
    }

    public Point getAnchorPoint(Object object, Object object2, Point point) {
        IItemGeometryProvider iItemGeometryProvider = (IItemGeometryProvider)ItemProviders.adapt((Object)object, IItemGeometryProvider.class);
        if (iItemGeometryProvider != null) {
            return LayoutCalculator.translate(iItemGeometryProvider.getAnchorPoint(object, object2, this), point);
        }
        return null;
    }

    public Point getFeatureEndPoint(Object object, Object object2, Point point) {
        IItemGeometryProvider iItemGeometryProvider = (IItemGeometryProvider)ItemProviders.adapt((Object)object, IItemGeometryProvider.class);
        if (iItemGeometryProvider != null) {
            return LayoutCalculator.translate(iItemGeometryProvider.getFeatureEndPoint(object, object2, this), point);
        }
        return null;
    }

    public Point getSourceEndPoint(Edge edge, Point point) {
        return this.getFeatureEndPoint(edge, DIPackage.Literals.EDGE__SOURCE, point);
    }

    public Point getTargetEndPoint(Edge edge, Point point) {
        return this.getFeatureEndPoint(edge, DIPackage.Literals.EDGE__TARGET, point);
    }

    public Point getElementOrigin(Object object, Object object2, Point point) {
        IItemGeometryProvider iItemGeometryProvider = (IItemGeometryProvider)ItemProviders.adapt((Object)object, IItemGeometryProvider.class);
        if (iItemGeometryProvider != null) {
            return LayoutCalculator.translate(iItemGeometryProvider.getElementOrigin(object, object2, this), point);
        }
        return null;
    }

    public static Point translate(Point point, Point point2) {
        if (point2 != null && point != null) {
            double d = point2.getX() + point.getX();
            double d2 = point2.getY() + point.getY();
            return DCFactory.eINSTANCE.createPoint(d, d2);
        }
        return point;
    }

    public static Bounds translate(Bounds bounds, Point point) {
        if (point != null && bounds != null) {
            double d = point.getX() + bounds.getX();
            double d2 = point.getY() + bounds.getY();
            double d3 = bounds.getWidth();
            double d4 = bounds.getHeight();
            return DCFactory.eINSTANCE.createBounds(d, d2, d3, d4);
        }
        return bounds;
    }

    public static List<Point> translate(List<Point> list, Point point) {
        if (point != null && !list.isEmpty()) {
            return list.stream().map(point2 -> LayoutCalculator.translate(point2, point)).collect(Collectors.toList());
        }
        return list;
    }

    public static Bounds relativize(Bounds bounds, Point point) {
        return LayoutCalculator.translate(bounds, LayoutCalculator.a(point));
    }

    public static Point relativize(Point point, Point point2) {
        return LayoutCalculator.translate(point, LayoutCalculator.a(point2));
    }

    public static List<Point> relativize(List<Point> list, Point point) {
        return LayoutCalculator.translate(list, LayoutCalculator.a(point));
    }

    private static Point a(Point point) {
        if (point != null) {
            return DCFactory.eINSTANCE.createPoint(-point.getX(), -point.getY());
        }
        return point;
    }

    public static Point addition(Point point, Point point2) {
        if (point != null && point2 != null) {
            double d = point.getX() + point2.getX();
            double d2 = point.getY() + point2.getY();
            return DCFactory.eINSTANCE.createPoint(d, d2);
        }
        if (point != null) {
            return DCFactory.eINSTANCE.createPoint(point);
        }
        if (point2 != null) {
            return DCFactory.eINSTANCE.createPoint(point2);
        }
        return null;
    }

    public static Point subtraction(Point point, Point point2) {
        return LayoutCalculator.addition(point, LayoutCalculator.a(point2));
    }

    public Bounds getSourceEndBounds(Edge edge, Point point) {
        Point point2 = this.getSourceEndPoint(edge, point);
        DiagramElement diagramElement = this.getSource(edge);
        return this.getEdgeEndBounds(edge, diagramElement, point2, point);
    }

    public Bounds getTargetEndBounds(Edge edge, Point point) {
        Point point2 = this.getTargetEndPoint(edge, point);
        DiagramElement diagramElement = this.getTarget(edge);
        return this.getEdgeEndBounds(edge, diagramElement, point2, point);
    }

    public Bounds getEdgeEndBounds(Edge edge, DiagramElement diagramElement, Point point, Point point2) {
        point2 = LayoutCalculator.addition(point2, this.getOrigin(diagramElement));
        point2 = LayoutCalculator.subtraction(point2, this.getOrigin(edge));
        if (diagramElement instanceof Edge) {
            if (point != null) {
                return LayoutCalculator.translate(DCFactory.eINSTANCE.createBounds(point.getX() - 0.5, point.getY() - 0.5, 1.0, 1.0), point2);
            }
            return null;
        }
        return this.getBoundsOn(diagramElement, point2);
    }

    public DiagramElement getSource(@NonNull Edge edge) {
        if (edge == null) {
            throw new NullPointerException("edge");
        }
        Object object = this.getFeatureAccessor().get(edge, DIPackage.Literals.EDGE__SOURCE);
        if (object != null) {
            return FeatureAccessor.actualValue(object, DiagramElement.class);
        }
        return edge.getSource();
    }

    public DiagramElement getTarget(@NonNull Edge edge) {
        if (edge == null) {
            throw new NullPointerException("edge");
        }
        Object object = this.getFeatureAccessor().get(edge, DIPackage.Literals.EDGE__TARGET);
        if (object != null) {
            return FeatureAccessor.actualValue(object, DiagramElement.class);
        }
        return edge.getTarget();
    }

    public <T extends DiagramElement> T getOwningElement(@NonNull DiagramElement diagramElement) {
        if (diagramElement == null) {
            throw new NullPointerException("diagramElement");
        }
        Object object = this.getFeatureAccessor().get(diagramElement, DIPackage.Literals.DIAGRAM_ELEMENT__OWNING_ELEMENT);
        if (object != null) {
            return (T)((DiagramElement)FeatureAccessor.actualValue(object));
        }
        return (T)diagramElement.getOwningElement();
    }

    public List<DiagramElement> getOwnedElements(@NonNull DiagramElement diagramElement) {
        if (diagramElement == null) {
            throw new NullPointerException("diagramElement");
        }
        return this.getFeatureAccessor().getOwnedElements(diagramElement);
    }
}

