/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import javax.swing.border.AbstractBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.html.CSS;

class CSSBorder
extends AbstractBorder {
    static final int COLOR = 0;
    static final int STYLE = 1;
    static final int WIDTH = 2;
    static final int TOP = 0;
    static final int RIGHT = 1;
    static final int BOTTOM = 2;
    static final int LEFT = 3;
    static final CSS.Attribute[][] ATTRIBUTES = new CSS.Attribute[][]{{CSS.Attribute.BORDER_TOP_COLOR, CSS.Attribute.BORDER_RIGHT_COLOR, CSS.Attribute.BORDER_BOTTOM_COLOR, CSS.Attribute.BORDER_LEFT_COLOR}, {CSS.Attribute.BORDER_TOP_STYLE, CSS.Attribute.BORDER_RIGHT_STYLE, CSS.Attribute.BORDER_BOTTOM_STYLE, CSS.Attribute.BORDER_LEFT_STYLE}, {CSS.Attribute.BORDER_TOP_WIDTH, CSS.Attribute.BORDER_RIGHT_WIDTH, CSS.Attribute.BORDER_BOTTOM_WIDTH, CSS.Attribute.BORDER_LEFT_WIDTH}};
    static final CSS.CssValue[] PARSERS = new CSS.CssValue[]{new CSS.ColorValue(), new CSS.BorderStyle(), new CSS.BorderWidthValue(null, 0)};
    static final Object[] DEFAULTS = new Object[]{CSS.Attribute.BORDER_COLOR, PARSERS[1].parseCssValue(CSS.Attribute.BORDER_STYLE.getDefaultValue()), PARSERS[2].parseCssValue(CSS.Attribute.BORDER_WIDTH.getDefaultValue())};
    final AttributeSet attrs;
    static Map<CSS.Value, BorderPainter> borderPainters = new HashMap<CSS.Value, BorderPainter>();

    CSSBorder(AttributeSet attributeSet) {
        this.attrs = attributeSet;
    }

    private Color getBorderColor(int n) {
        CSS.ColorValue colorValue;
        Object object = this.attrs.getAttribute(ATTRIBUTES[0][n]);
        if (object instanceof CSS.ColorValue) {
            colorValue = (CSS.ColorValue)object;
        } else {
            colorValue = (CSS.ColorValue)this.attrs.getAttribute(CSS.Attribute.COLOR);
            if (colorValue == null) {
                colorValue = (CSS.ColorValue)PARSERS[0].parseCssValue(CSS.Attribute.COLOR.getDefaultValue());
            }
        }
        return colorValue.getValue();
    }

    private int getBorderWidth(int n) {
        int n2 = 0;
        CSS.BorderStyle borderStyle = (CSS.BorderStyle)this.attrs.getAttribute(ATTRIBUTES[1][n]);
        if (borderStyle != null && borderStyle.getValue() != CSS.Value.NONE) {
            CSS.LengthValue lengthValue = (CSS.LengthValue)this.attrs.getAttribute(ATTRIBUTES[2][n]);
            if (lengthValue == null) {
                lengthValue = (CSS.LengthValue)DEFAULTS[2];
            }
            n2 = (int)lengthValue.getValue(true);
        }
        return n2;
    }

    private int[] getWidths() {
        int[] nArray = new int[4];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.getBorderWidth(i);
        }
        return nArray;
    }

    private CSS.Value getBorderStyle(int n) {
        CSS.BorderStyle borderStyle = (CSS.BorderStyle)this.attrs.getAttribute(ATTRIBUTES[1][n]);
        if (borderStyle == null) {
            borderStyle = (CSS.BorderStyle)DEFAULTS[1];
        }
        return borderStyle.getValue();
    }

    private Polygon getBorderShape(int n) {
        Polygon polygon = null;
        int[] nArray = this.getWidths();
        if (nArray[n] != 0) {
            polygon = new Polygon(new int[4], new int[4], 0);
            polygon.addPoint(0, 0);
            polygon.addPoint(-nArray[(n + 3) % 4], -nArray[n]);
            polygon.addPoint(nArray[(n + 1) % 4], -nArray[n]);
            polygon.addPoint(0, 0);
        }
        return polygon;
    }

    private BorderPainter getBorderPainter(int n) {
        CSS.Value value = this.getBorderStyle(n);
        return borderPainters.get(value);
    }

    static Color getAdjustedColor(Color color, double d) {
        double d2 = 1.0 - Math.min(Math.abs(d), 1.0);
        double d3 = d > 0.0 ? 255.0 * (1.0 - d2) : 0.0;
        return new Color((int)((double)color.getRed() * d2 + d3), (int)((double)color.getGreen() * d2 + d3), (int)((double)color.getBlue() * d2 + d3));
    }

    @Override
    public Insets getBorderInsets(Component component, Insets insets) {
        int[] nArray = this.getWidths();
        insets.set(nArray[0], nArray[3], nArray[2], nArray[1]);
        return insets;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        if (!(graphics instanceof Graphics2D)) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        int[] nArray = this.getWidths();
        int n5 = n + nArray[3];
        int n6 = n2 + nArray[0];
        int n7 = n3 - (nArray[1] + nArray[3]);
        int n8 = n4 - (nArray[0] + nArray[2]);
        int[][] nArrayArray = new int[][]{{n5, n6}, {n5 + n7, n6}, {n5 + n7, n6 + n8}, {n5, n6 + n8}};
        for (int i = 0; i < 4; ++i) {
            CSS.Value value = this.getBorderStyle(i);
            Polygon polygon = this.getBorderShape(i);
            if (value == CSS.Value.NONE || polygon == null) continue;
            int n9 = i % 2 == 0 ? n7 : n8;
            polygon.xpoints[2] = polygon.xpoints[2] + n9;
            polygon.xpoints[3] = polygon.xpoints[3] + n9;
            Color color = this.getBorderColor(i);
            BorderPainter borderPainter = this.getBorderPainter(i);
            double d = (double)i * Math.PI / 2.0;
            graphics2D.setClip(graphics.getClip());
            graphics2D.translate(nArrayArray[i][0], nArrayArray[i][1]);
            graphics2D.rotate(d);
            graphics2D.clip(polygon);
            borderPainter.paint(polygon, graphics2D, color, i);
            graphics2D.rotate(-d);
            graphics2D.translate(-nArrayArray[i][0], -nArrayArray[i][1]);
        }
        graphics2D.dispose();
    }

    static void registerBorderPainter(CSS.Value value, BorderPainter borderPainter) {
        borderPainters.put(value, borderPainter);
    }

    static {
        CSSBorder.registerBorderPainter(CSS.Value.NONE, new NullPainter());
        CSSBorder.registerBorderPainter(CSS.Value.HIDDEN, new NullPainter());
        CSSBorder.registerBorderPainter(CSS.Value.SOLID, new SolidPainter());
        CSSBorder.registerBorderPainter(CSS.Value.DOUBLE, new DoublePainter());
        CSSBorder.registerBorderPainter(CSS.Value.DOTTED, new DottedDashedPainter(1));
        CSSBorder.registerBorderPainter(CSS.Value.DASHED, new DottedDashedPainter(3));
        CSSBorder.registerBorderPainter(CSS.Value.GROOVE, new GrooveRidgePainter(CSS.Value.GROOVE));
        CSSBorder.registerBorderPainter(CSS.Value.RIDGE, new GrooveRidgePainter(CSS.Value.RIDGE));
        CSSBorder.registerBorderPainter(CSS.Value.INSET, new InsetOutsetPainter(CSS.Value.INSET));
        CSSBorder.registerBorderPainter(CSS.Value.OUTSET, new InsetOutsetPainter(CSS.Value.OUTSET));
    }

    static class InsetOutsetPainter
    extends ShadowLightPainter {
        CSS.Value type;

        InsetOutsetPainter(CSS.Value value) {
            this.type = value;
        }

        @Override
        public void paint(Polygon polygon, Graphics graphics, Color color, int n) {
            graphics.setColor((n + 1) % 4 < 2 == (this.type == CSS.Value.INSET) ? InsetOutsetPainter.getShadowColor(color) : InsetOutsetPainter.getLightColor(color));
            graphics.fillPolygon(polygon);
        }
    }

    static class GrooveRidgePainter
    extends ShadowLightPainter {
        final CSS.Value type;

        GrooveRidgePainter(CSS.Value value) {
            this.type = value;
        }

        @Override
        public void paint(Polygon polygon, Graphics graphics, Color color, int n) {
            Color[] colorArray;
            Rectangle rectangle = polygon.getBounds();
            int n2 = Math.max(rectangle.height / 2, 1);
            int[] nArray = new int[]{n2, n2};
            if ((n + 1) % 4 < 2 == (this.type == CSS.Value.GROOVE)) {
                Color[] colorArray2 = new Color[2];
                colorArray2[0] = GrooveRidgePainter.getShadowColor(color);
                colorArray = colorArray2;
                colorArray2[1] = GrooveRidgePainter.getLightColor(color);
            } else {
                Color[] colorArray3 = new Color[2];
                colorArray3[0] = GrooveRidgePainter.getLightColor(color);
                colorArray = colorArray3;
                colorArray3[1] = GrooveRidgePainter.getShadowColor(color);
            }
            Color[] colorArray4 = colorArray;
            this.paintStrokes(rectangle, graphics, 1, nArray, colorArray4);
        }
    }

    static abstract class ShadowLightPainter
    extends StrokePainter {
        ShadowLightPainter() {
        }

        static Color getShadowColor(Color color) {
            return CSSBorder.getAdjustedColor(color, -0.3);
        }

        static Color getLightColor(Color color) {
            return CSSBorder.getAdjustedColor(color, 0.7);
        }
    }

    static class DottedDashedPainter
    extends StrokePainter {
        final int factor;

        DottedDashedPainter(int n) {
            this.factor = n;
        }

        @Override
        public void paint(Polygon polygon, Graphics graphics, Color color, int n) {
            Rectangle rectangle = polygon.getBounds();
            int n2 = rectangle.height * this.factor;
            int[] nArray = new int[]{n2, n2};
            Color[] colorArray = new Color[]{color, null};
            this.paintStrokes(rectangle, graphics, 0, nArray, colorArray);
        }
    }

    static class DoublePainter
    extends StrokePainter {
        DoublePainter() {
        }

        @Override
        public void paint(Polygon polygon, Graphics graphics, Color color, int n) {
            Rectangle rectangle = polygon.getBounds();
            int n2 = Math.max(rectangle.height / 3, 1);
            int[] nArray = new int[]{n2, n2};
            Color[] colorArray = new Color[]{color, null};
            this.paintStrokes(rectangle, graphics, 1, nArray, colorArray);
        }
    }

    static abstract class StrokePainter
    implements BorderPainter {
        StrokePainter() {
        }

        void paintStrokes(Rectangle rectangle, Graphics graphics, int n, int[] nArray, Color[] colorArray) {
            int n2;
            boolean bl = n == 0;
            int n3 = 0;
            int n4 = n2 = bl ? rectangle.width : rectangle.height;
            while (n3 < n2) {
                int n5;
                for (int i = 0; i < nArray.length && n3 < n2; n3 += n5, ++i) {
                    n5 = nArray[i];
                    Color color = colorArray[i];
                    if (color == null) continue;
                    int n6 = rectangle.x + (bl ? n3 : 0);
                    int n7 = rectangle.y + (bl ? 0 : n3);
                    int n8 = bl ? n5 : rectangle.width;
                    int n9 = bl ? rectangle.height : n5;
                    graphics.setColor(color);
                    graphics.fillRect(n6, n7, n8, n9);
                }
            }
        }
    }

    static class SolidPainter
    implements BorderPainter {
        SolidPainter() {
        }

        @Override
        public void paint(Polygon polygon, Graphics graphics, Color color, int n) {
            graphics.setColor(color);
            graphics.fillPolygon(polygon);
        }
    }

    static class NullPainter
    implements BorderPainter {
        NullPainter() {
        }

        @Override
        public void paint(Polygon polygon, Graphics graphics, Color color, int n) {
        }
    }

    static interface BorderPainter {
        public void paint(Polygon var1, Graphics var2, Color var3, int var4);
    }
}

