/*
 * Decompiled with CFR 0.152.
 */
package net.astah.project.provider;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.astah.emf.edit.provider.ExtraLabelVariant;
import net.astah.project.Facet;
import net.astah.project.Project;
import net.astah.project.ProjectFactory;
import net.astah.project.ProjectManagerAdapter;
import net.astah.project.ProjectPackage;
import net.astah.project.provider.ProjectElementItemProvider;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;

public class ProjectItemProvider
extends ProjectElementItemProvider {
    protected final Set<IChangeNotifier> changeNotifiers = new HashSet<IChangeNotifier>();
    protected final INotifyChangedListener listener = this::notifyChanged;

    public ProjectItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addIdPropertyDescriptor(object);
            this.addNamePropertyDescriptor(object);
            this.addRealURIPropertyDescriptor(object);
            this.addVirtualURIPropertyDescriptor(object);
            this.addResourcesPropertyDescriptor(object);
            this.addReadonlyPropertyDescriptor(object);
            this.addModifiedPropertyDescriptor(object);
            this.addManagedPropertyDescriptor(object);
            this.addDependingProjectsPropertyDescriptor(object);
            this.addContentsPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addIdPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Project_id_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Project_id_feature", "_UI_Project_type"), (EStructuralFeature)ProjectPackage.Literals.PROJECT__ID, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addNamePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Project_name_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Project_name_feature", "_UI_Project_type"), (EStructuralFeature)ProjectPackage.Literals.PROJECT__NAME, false, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addRealURIPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Project_realURI_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Project_realURI_feature", "_UI_Project_type"), (EStructuralFeature)ProjectPackage.Literals.PROJECT__REAL_URI, false, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addVirtualURIPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Project_virtualURI_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Project_virtualURI_feature", "_UI_Project_type"), (EStructuralFeature)ProjectPackage.Literals.PROJECT__VIRTUAL_URI, false, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addResourcesPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Project_resources_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Project_resources_feature", "_UI_Project_type"), (EStructuralFeature)ProjectPackage.Literals.PROJECT__RESOURCES, false, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addReadonlyPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Project_readonly_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Project_readonly_feature", "_UI_Project_type"), (EStructuralFeature)ProjectPackage.Literals.PROJECT__READONLY, false, false, false, ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE, null, null));
    }

    protected void addModifiedPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Project_modified_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Project_modified_feature", "_UI_Project_type"), (EStructuralFeature)ProjectPackage.Literals.PROJECT__MODIFIED, false, false, false, ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE, null, null));
    }

    protected void addManagedPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Project_managed_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Project_managed_feature", "_UI_Project_type"), (EStructuralFeature)ProjectPackage.Literals.PROJECT__MANAGED, true, false, false, ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE, null, null));
    }

    protected void addDependingProjectsPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Project_dependingProjects_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Project_dependingProjects_feature", "_UI_Project_type"), (EStructuralFeature)ProjectPackage.Literals.PROJECT__DEPENDING_PROJECTS, true, false, true, null, null, null));
    }

    protected void addContentsPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Project_contents_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Project_contents_feature", "_UI_Project_type"), (EStructuralFeature)ProjectPackage.Literals.PROJECT__CONTENTS, true, false, true, null, null, null));
    }

    @Override
    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(ProjectPackage.Literals.PROJECT__NESTED_PROJECTS);
            this.childrenFeatures.add(ProjectPackage.Literals.PROJECT__FACETS);
        }
        return this.childrenFeatures;
    }

    @Override
    protected EStructuralFeature getChildFeature(Object object, Object object2) {
        return super.getChildFeature(object, object2);
    }

    @Override
    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("astah/ProjectPackage.png"));
    }

    @Override
    public String getText(Object object) {
        String string = ((Project)object).getName();
        return string == null || string.length() == 0 ? this.getString("_UI_Project_type") : this.getString("_UI_Project_type") + " " + string;
    }

    public String getText(Object object, Object object2) {
        if (object2 == ExtraLabelVariant.MODEL_TREE) {
            String string = ((Project)object).getName();
            return Objects.toString(string, "no_title");
        }
        return super.getText(object, object2);
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(Project.class)) {
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
            case 17: 
            case 19: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> collection, Object object) {
        super.collectNewChildDescriptors(collection, object);
        collection.add(this.createChildParameter(ProjectPackage.Literals.PROJECT__NESTED_PROJECTS, ProjectFactory.eINSTANCE.createProject()));
        collection.add(this.createChildParameter(ProjectPackage.Literals.PROJECT__FACETS, ProjectFactory.eINSTANCE.createFacet()));
    }

    protected Command factorAddCommand(EditingDomain editingDomain, CommandParameter commandParameter) {
        Command command = super.factorAddCommand(editingDomain, commandParameter);
        if (command == UnexecutableCommand.INSTANCE) {
            Collection collection = commandParameter.getCollection();
            for (Facet facet : ((Project)commandParameter.getOwner()).getFacets()) {
                Command command2 = AddCommand.create((EditingDomain)editingDomain, (Object)facet, null, (Collection)collection);
                if (command2.canExecute()) {
                    return command2;
                }
                command2.dispose();
            }
        }
        return command;
    }

    public void setTarget(Notifier notifier) {
        ProjectManagerAdapter projectManagerAdapter;
        super.setTarget(notifier);
        if (notifier instanceof Project && (projectManagerAdapter = ProjectManagerAdapter.getProjectManagerAdapter((Notifier)notifier)) != null && this.changeNotifiers.add((IChangeNotifier)projectManagerAdapter)) {
            projectManagerAdapter.addListener(this::notifyChanged);
        }
    }

    public void dispose() {
        for (IChangeNotifier iChangeNotifier : Iterables.consumingIterable(this.changeNotifiers)) {
            iChangeNotifier.removeListener(this.listener);
        }
        super.dispose();
    }
}

