/*
 * Decompiled with CFR 0.152.
 */
package net.astah.project.edit.command;

import lombok.NonNull;
import net.astah.emf.common.resource.ResourceSets;
import net.astah.project.Facet;
import net.astah.project.ProjectPackage;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

public class RegisterFacetContentCommand
extends CompoundCommand {
    protected final EditingDomain domain;
    protected final Facet owner;
    protected final String contentType;
    protected final URI uri;
    protected EObject value;

    public RegisterFacetContentCommand(EditingDomain editingDomain, Facet facet, String string, String string2, EObject eObject) {
        this(editingDomain, facet, string, URI.createURI((String)string2), eObject);
    }

    public RegisterFacetContentCommand(@NonNull EditingDomain editingDomain, @NonNull Facet facet, @NonNull String string, @NonNull URI uRI, EObject eObject) {
        super(Integer.MIN_VALUE);
        if (editingDomain == null) {
            throw new NullPointerException("domain");
        }
        if (facet == null) {
            throw new NullPointerException("owner");
        }
        if (string == null) {
            throw new NullPointerException("contentType");
        }
        if (uRI == null) {
            throw new NullPointerException("uri");
        }
        this.domain = editingDomain;
        this.owner = facet;
        this.contentType = string;
        this.uri = uRI;
        this.value = eObject;
    }

    public EObject getValue() {
        return this.value;
    }

    protected boolean prepare() {
        URI uRI = this.getResourceURI();
        this.value = this.addFacetContent(uRI);
        return this.value != null && super.prepare();
    }

    protected URI getResourceURI() {
        return this.uri.resolve(this.owner.getProject().getVirtualURI().appendSegment(""));
    }

    protected EObject resolveValue() {
        return this.value;
    }

    protected EObject addFacetContent(URI uRI) {
        Resource resource = this.owner.eResource();
        if (resource == null) {
            return null;
        }
        ResourceSet resourceSet = resource.getResourceSet();
        if (resourceSet == null) {
            return null;
        }
        EObject eObject = this.resolveValue();
        if (eObject == null) {
            return null;
        }
        Resource resource2 = ResourceSets.getOrCreateResource((ResourceSet)resourceSet, (URI)uRI, (String)this.contentType);
        this.append((Command)new AddCommand(this.domain, resource2.getContents(), (Object)eObject));
        this.append(AddCommand.create((EditingDomain)this.domain, (Object)this.owner, (Object)ProjectPackage.Literals.FACET__CONTENTS, (Object)eObject));
        return eObject;
    }
}

