/*
 * Decompiled with CFR 0.152.
 */
package net.astah.project.edit.command;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import net.astah.project.Facet;
import net.astah.project.IFacetActivator;
import net.astah.project.Project;
import net.astah.project.ProjectElement;
import net.astah.project.ProjectPackage;
import net.astah.project.edit.command.AddProjectVersionHistoryCommand;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;

public class MigrateFacetsCommand
extends CompoundCommand {
    protected IFacetActivator.Registry registry = IFacetActivator.Registry.INSTANCE;
    protected EditingDomain domain;
    protected Collection<Project> projects;
    protected String modelProducer;

    public MigrateFacetsCommand(EditingDomain editingDomain, Project project, String string) {
        this(editingDomain, Collections.singleton(project), string);
    }

    public MigrateFacetsCommand(EditingDomain editingDomain, Collection<Project> collection, String string) {
        this.domain = editingDomain;
        this.projects = collection;
        this.modelProducer = string;
    }

    protected boolean prepare() {
        if (this.domain == null || this.projects == null) {
            return false;
        }
        Date date = new Date();
        for (Project project : this.projects) {
            if (!project.eIsSet((EStructuralFeature)ProjectPackage.Literals.PROJECT__FACETS)) continue;
            for (Facet facet : project.getFacets()) {
                this.appendMigrateFacetCommand(this.domain, facet, date);
            }
        }
        return super.prepare();
    }

    protected void appendMigrateFacetCommand(EditingDomain editingDomain, Facet facet, Date date) {
        Object object;
        IFacetActivator iFacetActivator = this.registry.getActivator(facet.getSymbolicName());
        if (iFacetActivator != null && (object = this.registry.get((Object)facet.getSymbolicName())) instanceof IFacetActivator.Descriptor) {
            IFacetActivator.Descriptor descriptor = (IFacetActivator.Descriptor)object;
            int n = descriptor.getVersion();
            if (facet.getLastModelVersion() != n && this.appendIfCanExecute(iFacetActivator.migrate(editingDomain, facet))) {
                AddProjectVersionHistoryCommand.a(editingDomain, this, (ProjectElement)facet, this.modelProducer, n, date);
            }
        }
    }
}

