/*
 * Decompiled with CFR 0.152.
 */
package net.astah.project.edit.command;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import net.astah.project.Facet;
import net.astah.project.IFacetActivator;
import net.astah.project.Project;
import net.astah.project.ProjectPackage;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;

public class LoadedFacetsCommand
extends CompoundCommand {
    protected IFacetActivator.Registry registry = IFacetActivator.Registry.INSTANCE;
    protected EditingDomain domain;
    protected Collection<Project> projects;

    public LoadedFacetsCommand(EditingDomain editingDomain, Project project) {
        this(editingDomain, Collections.singleton(project));
    }

    public LoadedFacetsCommand(EditingDomain editingDomain, Collection<Project> collection) {
        this.domain = editingDomain;
        this.projects = collection;
    }

    protected boolean prepare() {
        if (this.domain == null || this.projects == null) {
            return false;
        }
        Date date = new Date();
        for (Project project : this.projects) {
            if (!project.eIsSet((EStructuralFeature)ProjectPackage.Literals.PROJECT__FACETS)) continue;
            for (Facet facet : project.getFacets()) {
                this.appendLoadedFacetCommand(this.domain, facet, date);
            }
        }
        return super.prepare();
    }

    protected void appendLoadedFacetCommand(EditingDomain editingDomain, Facet facet, Date date) {
        IFacetActivator iFacetActivator = this.registry.getActivator(facet.getSymbolicName());
        if (iFacetActivator != null) {
            this.append(iFacetActivator.loaded(editingDomain, facet));
        }
    }
}

