/*
 * Decompiled with CFR 0.152.
 */
package net.astah.project.edit.command;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.ListIterator;
import java.util.Objects;
import net.astah.project.Facet;
import net.astah.project.IFacetActivator;
import net.astah.project.Project;
import net.astah.project.ProjectElement;
import net.astah.project.ProjectFactory;
import net.astah.project.ProjectManagerAdapter;
import net.astah.project.ProjectPackage;
import net.astah.project.VersionHistory;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

public class AddProjectVersionHistoryCommand
extends CompoundCommand {
    protected EditingDomain domain;
    protected Collection<Project> projects;
    protected String modelProducer;
    protected int modelVersion;

    public static Command create(EditingDomain editingDomain, String string, int n) {
        Project project = ProjectManagerAdapter.getRootProject((Notifier)editingDomain.getResourceSet());
        if (project == null) {
            return UnexecutableCommand.INSTANCE;
        }
        return new AddProjectVersionHistoryCommand(editingDomain, Collections.singleton(project), string, n);
    }

    public AddProjectVersionHistoryCommand(EditingDomain editingDomain, Collection<Project> collection, String string, int n) {
        this.domain = editingDomain;
        this.projects = collection;
        this.modelProducer = string;
        this.modelVersion = n;
    }

    protected boolean prepare() {
        if (this.domain == null || this.projects == null) {
            return false;
        }
        Date date = new Date();
        for (Project project : this.projects) {
            this.process((ProjectElement)project, this.modelProducer, this.modelVersion, date);
            for (Facet facet : project.getFacets()) {
                this.processFacet(facet, date);
            }
        }
        return super.prepare();
    }

    protected void process(ProjectElement projectElement, String string, int n, Date date) {
        AddProjectVersionHistoryCommand.a(this.domain, this, projectElement, string, n, date);
    }

    static void a(EditingDomain editingDomain, CompoundCommand compoundCommand, ProjectElement projectElement, String string, int n, Date date) {
        VersionHistory versionHistory;
        EList eList = projectElement.getVersionHistories();
        ListIterator listIterator = eList.listIterator();
        while (listIterator.hasNext()) {
            versionHistory = (VersionHistory)listIterator.next();
            if (!Objects.equals(string, versionHistory.getModelProducer())) continue;
            int n2 = listIterator.previousIndex();
            if (n2 > 0) {
                compoundCommand.append(MoveCommand.create((EditingDomain)editingDomain, (Object)projectElement, (Object)ProjectPackage.Literals.PROJECT_ELEMENT__VERSION_HISTORIES, (Object)versionHistory, (int)0));
            }
            compoundCommand.append(SetCommand.create((EditingDomain)editingDomain, (Object)versionHistory, (Object)ProjectPackage.Literals.VERSION_HISTORY__LAST_MODIFIED, (Object)date));
            return;
        }
        if (eList.size() >= 50) {
            versionHistory = (VersionHistory)eList.get(eList.size() - 1);
            compoundCommand.append(RemoveCommand.create((EditingDomain)editingDomain, (Object)projectElement, (Object)ProjectPackage.Literals.PROJECT_ELEMENT__VERSION_HISTORIES, (Object)versionHistory));
        }
        versionHistory = ProjectFactory.eINSTANCE.createVersionHistory();
        versionHistory.setModelProducer(string);
        versionHistory.setModelVersion(n);
        versionHistory.setLastModified(date);
        compoundCommand.append(AddCommand.create((EditingDomain)editingDomain, (Object)projectElement, (Object)ProjectPackage.Literals.PROJECT_ELEMENT__VERSION_HISTORIES, (Object)versionHistory, (int)0));
    }

    protected void processFacet(Facet facet, Date date) {
        Object object;
        if (facet.getContents().stream().anyMatch(this::isResourceModified) && (object = IFacetActivator.Registry.INSTANCE.get((Object)facet.getSymbolicName())) instanceof IFacetActivator.Descriptor) {
            IFacetActivator.Descriptor descriptor = (IFacetActivator.Descriptor)object;
            this.process((ProjectElement)facet, this.modelProducer, descriptor.getVersion(), date);
        }
    }

    protected boolean isResourceModified(EObject eObject) {
        Resource resource = eObject.eResource();
        return resource != null && resource.isModified();
    }
}

